/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.psi.XmlPsiBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaPrefix
extends RenameableFakePsiElement {
    private final TextRange myRange;
    private final String myName;

    public SchemaPrefix(XmlAttribute parent, TextRange range, String name) {
        super((PsiElement)parent);
        this.myRange = range;
        this.myName = name;
    }

    public static SchemaPrefix createJspPrefix(XmlAttributeValue element, String prefix) {
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element).shiftRight(element.getStartOffsetInParent());
        return new SchemaPrefix((XmlAttribute)element.getParent(), range, prefix){

            @Override
            protected String getNamespace() {
                return ((XmlAttribute)this.getParent()).getParent().getAttributeValue("uri");
            }
        };
    }

    public String getTypeName() {
        return XmlPsiBundle.message((String)"xml.namespace.prefix", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.Variable);
    }

    public int getTextOffset() {
        return this.getParent().getTextRange().getStartOffset() + this.myRange.getStartOffset();
    }

    public int getTextLength() {
        return this.myName.length();
    }

    public String getName() {
        return this.myName;
    }

    public XmlAttribute getDeclaration() {
        return (XmlAttribute)this.getParent();
    }

    public TextRange getTextRange() {
        return TextRange.from((int)this.getTextOffset(), (int)this.getTextLength());
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = XmlExtension.getExtension(this.getContainingFile()).getNsPrefixScope(this.getDeclaration());
        if (searchScope == null) {
            SchemaPrefix.$$$reportNull$$$0(0);
        }
        return searchScope;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return another instanceof SchemaPrefix && ((SchemaPrefix)another).getDeclaration() == this.getDeclaration();
    }

    @NlsSafe
    public String getQuickNavigateInfo() {
        String ns = this.getNamespace();
        StringBuilder builder2 = new StringBuilder().append(this.getTypeName()).append(" \"").append(this.getName()).append("\"");
        if (ns != null) {
            builder2.append(" (").append(ns).append(")");
        }
        return builder2.toString();
    }

    @Nullable
    protected String getNamespace() {
        XmlAttribute parent = (XmlAttribute)this.getParent();
        return parent == null ? null : parent.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/SchemaPrefix", "getUseScope"));
    }
}

