/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.xml.util.IncludedXmlAttribute;
import com.intellij.xml.util.IncludedXmlTag;
import com.intellij.xml.util.IncludedXmlText;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IncludedXmlElement<T extends XmlElement>
extends LightElement
implements XmlElement {
    private final PsiAnchor myOriginal;
    private SoftReference<T> myRef;
    private final PsiElement myParent;

    public IncludedXmlElement(@NotNull T original, @Nullable PsiElement parent) {
        if (original == null) {
            IncludedXmlElement.$$$reportNull$$$0(0);
        }
        super(original.getManager(), original.getLanguage());
        T realOriginal = original instanceof IncludedXmlElement ? ((IncludedXmlElement)((Object)original)).getOriginal() : original;
        this.myOriginal = PsiAnchor.create(realOriginal);
        this.myRef = new SoftReference<T>(realOriginal);
        this.myParent = parent;
    }

    public boolean isValid() {
        XmlElement t = (XmlElement)this.myRef.get();
        if (t != null) {
            return t.isValid();
        }
        return this.myOriginal.retrieve() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IncludedXmlElement element = (IncludedXmlElement)((Object)o);
        if (!this.myParent.equals(element.myParent)) {
            return false;
        }
        return this.myOriginal.equals(element.myOriginal);
    }

    public int hashCode() {
        int result = this.myOriginal.hashCode();
        result = 31 * result + this.myParent.hashCode();
        return result;
    }

    public T getOriginal() {
        XmlElement element = (XmlElement)this.myRef.get();
        if (element != null) {
            return (T)element;
        }
        element = (XmlElement)this.myOriginal.retrieve();
        if (element == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        this.myRef = new SoftReference<XmlElement>(element);
        return (T)element;
    }

    @NotNull
    public T getNavigationElement() {
        T t = this.getOriginal();
        if (t == null) {
            IncludedXmlElement.$$$reportNull$$$0(1);
        }
        return t;
    }

    public PsiFile getContainingFile() {
        return this.myParent.getContainingFile();
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public boolean processElements(final PsiElementProcessor processor, PsiElement place) {
        final IncludedXmlElement self = this;
        return this.getOriginal().processElements(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof XmlTag) {
                    XmlTag theirParent = ((XmlTag)element).getParentTag();
                    XmlTag parent = IncludedXmlElement.this.getOriginal().equals(theirParent) ? (XmlTag)self : theirParent;
                    return processor.execute((PsiElement)new IncludedXmlTag((XmlTag)element, (PsiElement)parent));
                }
                if (element instanceof XmlAttribute) {
                    XmlTag theirParent = ((XmlAttribute)element).getParent();
                    XmlTag parent = IncludedXmlElement.this.getOriginal().equals(theirParent) ? (XmlTag)self : theirParent;
                    return processor.execute((PsiElement)new IncludedXmlAttribute((XmlAttribute)element, parent));
                }
                if (element instanceof XmlText) {
                    XmlTag theirParent = ((XmlText)element).getParentTag();
                    XmlTag parent = IncludedXmlElement.this.getOriginal().equals(theirParent) ? (XmlTag)self : theirParent;
                    return processor.execute((PsiElement)new IncludedXmlText((XmlText)element, parent));
                }
                return processor.execute(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/xml/util/IncludedXmlElement$1", "execute"));
            }
        }, place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/IncludedXmlElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/IncludedXmlElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

