/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.sqlite.AlreadyClosedException;
import org.jetbrains.sqlite.Binder;
import org.jetbrains.sqlite.NativeDB;
import org.jetbrains.sqlite.SafeStatementPointer;
import org.jetbrains.sqlite.SqliteConnection;
import org.jetbrains.sqlite.SqliteConnectionKt;
import org.jetbrains.sqlite.SqliteResultSet;
import org.jetbrains.sqlite.SqliteStatement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B!\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0006\u0010\u0019\u001a\u00020\u000fJ\u0006\u0010\u001a\u001a\u00020\u0015J\u0006\u0010\u001b\u001a\u00020\u001cJ\r\u0010\u001d\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001f\u001a\u00020\u0013J\b\u0010 \u001a\u0004\u0018\u00010\u0007JL\u0010!\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u000126\u0010\"\u001a2\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u0002H\u00010#H\u0082\b\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u0015H\u0016R\u0010\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00118\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "T", "Lorg/jetbrains/sqlite/Binder;", "Lorg/jetbrains/sqlite/SqliteStatement;", "connection", "Lorg/jetbrains/sqlite/SqliteConnection;", "sql", "", "binder", "<init>", "(Lorg/jetbrains/sqlite/SqliteConnection;[BLorg/jetbrains/sqlite/Binder;)V", "getBinder", "()Lorg/jetbrains/sqlite/Binder;", "Lorg/jetbrains/sqlite/Binder;", "resultSet", "Lorg/jetbrains/sqlite/SqliteResultSet;", "pointer", "Lorg/jetbrains/sqlite/SafeStatementPointer;", "columnCount", "", "close", "", "db", "Lorg/jetbrains/sqlite/NativeDB;", "close$intellij_platform_sqlite", "executeQuery", "executeUpdate", "selectBoolean", "", "selectInt", "()Ljava/lang/Integer;", "selectNotNullInt", "selectByteArray", "executeLifecycle", "executor", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "isEmpty", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "bindParams", "toString", "", "executeBatch", "intellij.platform.sqlite"})
@SourceDebugExtension(value={"SMAP\nSqlitePreparedStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlitePreparedStatement.kt\norg/jetbrains/sqlite/SqlitePreparedStatement\n+ 2 SqliteConnection.kt\norg/jetbrains/sqlite/SqliteConnection\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n104#1:164\n105#1,8:171\n104#1:179\n105#1,8:186\n104#1:194\n105#1,8:201\n104#1:209\n105#1,8:216\n67#2,6:139\n67#2,6:145\n67#2,6:152\n67#2,6:158\n67#2,6:165\n67#2,6:180\n67#2,6:195\n67#2,6:210\n67#2,6:224\n67#2,6:230\n1#3:151\n*S KotlinDebug\n*F\n+ 1 SqlitePreparedStatement.kt\norg/jetbrains/sqlite/SqlitePreparedStatement\n*L\n80#1:164\n80#1:171,8\n86#1:179\n86#1:186,8\n92#1:194\n92#1:201,8\n98#1:209\n98#1:216,8\n17#1:139,6\n32#1:145,6\n45#1:152,6\n67#1:158,6\n80#1:165,6\n86#1:180,6\n92#1:195,6\n98#1:210,6\n104#1:224,6\n129#1:230,6\n*E\n"})
public final class SqlitePreparedStatement<T extends Binder>
implements SqliteStatement {
    @JvmField
    @NotNull
    public final SqliteConnection connection;
    @NotNull
    private final byte[] sql;
    @NotNull
    private final T binder;
    @NotNull
    private final SqliteResultSet resultSet;
    @JvmField
    @NotNull
    public final SafeStatementPointer pointer;
    private final int columnCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlitePreparedStatement(@NotNull SqliteConnection connection, @NotNull byte[] sql2, @NotNull T binder) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter(binder, (String)"binder");
        this.connection = connection;
        this.sql = sql2;
        this.binder = binder;
        this.resultSet = new SqliteResultSet(this);
        SafeStatementPointer pointer = null;
        int columnCount = 0;
        SqliteConnection this_$iv = this.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl = false;
            NativeDB db = SqliteConnection.access$getDb(this_$iv);
            boolean bl2 = false;
            pointer = db.addStatement(new SafeStatementPointer(this.connection, db.prepare_utf8(this.sql)));
            SafeStatementPointer safeStatementPointer = pointer;
            if (safeStatementPointer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pointer");
                safeStatementPointer = null;
            }
            columnCount = db.column_count(safeStatementPointer.pointer);
            int paramCount = db.bind_parameter_count(pointer.pointer);
            if (paramCount != ((Binder)this.binder).getParamCount$intellij_platform_sqlite()) {
                pointer.close$intellij_platform_sqlite(db);
                throw new IllegalStateException("statement param count: " + paramCount + ", binder param count: " + ((Binder)this.binder).getParamCount$intellij_platform_sqlite());
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.pointer = pointer;
        this.columnCount = columnCount;
    }

    @NotNull
    public final T getBinder() {
        return this.binder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SqliteConnection this_$iv = this.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl = false;
            NativeDB p0 = SqliteConnection.access$getDb(this_$iv);
            boolean bl2 = false;
            this.close$intellij_platform_sqlite(p0);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void close$intellij_platform_sqlite(@NotNull NativeDB db) {
        SafeStatementPointer safeStatementPointer;
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        SafeStatementPointer it = safeStatementPointer = this.pointer;
        boolean bl = false;
        SafeStatementPointer safeStatementPointer2 = !it.isClosed() ? safeStatementPointer : null;
        if (safeStatementPointer2 == null) {
            return;
        }
        SafeStatementPointer pointer = safeStatementPointer2;
        this.resultSet.close$intellij_platform_sqlite(db);
        ((Binder)this.binder).clearBatch$intellij_platform_sqlite();
        pointer.close$intellij_platform_sqlite(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SqliteResultSet executeQuery() {
        if (!(this.columnCount > 0)) {
            boolean $i$a$-require-SqlitePreparedStatement$executeQuery$22 = false;
            String $i$a$-require-SqlitePreparedStatement$executeQuery$22 = "Query does not return results";
            throw new IllegalArgumentException($i$a$-require-SqlitePreparedStatement$executeQuery$22.toString());
        }
        SqliteConnection this_$iv = this.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl = false;
            NativeDB db = SqliteConnection.access$getDb(this_$iv);
            boolean bl2 = false;
            this.pointer.ensureOpen();
            this.resultSet.close$intellij_platform_sqlite(db);
            this.bindParams(db);
            boolean isEmpty = SqliteConnectionKt.step(this.pointer.pointer, this.sql, db);
            if (isEmpty) {
                db.reset(this.pointer.pointer);
            } else {
                this.resultSet.setOpen$intellij_platform_sqlite(true);
            }
            SqliteResultSet sqliteResultSet = this.resultSet;
            return sqliteResultSet;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeUpdate() {
        SqliteConnection this_$iv = this.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl;
            boolean bl2 = false;
            NativeDB db = SqliteConnection.access$getDb(this_$iv);
            boolean bl3 = false;
            this.pointer.ensureOpen();
            this.bindParams(db);
            try {
                bl = SqliteConnectionKt.step(this.pointer.pointer, this.sql, db);
            }
            finally {
                db.reset(this.pointer.pointer);
            }
            boolean bl4 = bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean selectBoolean() {
        SqlitePreparedStatement this_$iv = this;
        boolean $i$f$executeLifecycle = false;
        SqliteConnection this_$iv$iv = this_$iv.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv$iv);
        lock.lock();
        try {
            boolean bl;
            boolean bl2 = false;
            NativeDB db$iv = SqliteConnection.access$getDb(this_$iv$iv);
            boolean bl3 = false;
            this_$iv.pointer.ensureOpen();
            try {
                void isEmpty;
                boolean isEmpty$iv;
                this_$iv.bindParams(db$iv);
                boolean bl4 = isEmpty$iv = SqliteConnectionKt.step(this_$iv.pointer.pointer, this_$iv.sql, db$iv);
                NativeDB db = db$iv;
                boolean bl5 = false;
                bl = isEmpty == false && db.column_int(this.pointer.pointer, 0) != 0;
                db$iv.reset(this_$iv.pointer.pointer);
            }
            catch (Throwable throwable) {
                db$iv.reset(this_$iv.pointer.pointer);
                throw throwable;
            }
            boolean bl6 = bl;
            return bl6;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final Integer selectInt() {
        SqlitePreparedStatement this_$iv = this;
        boolean $i$f$executeLifecycle = false;
        SqliteConnection this_$iv$iv = this_$iv.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv$iv);
        lock.lock();
        try {
            Integer n;
            boolean bl = false;
            NativeDB db$iv = SqliteConnection.access$getDb(this_$iv$iv);
            boolean bl2 = false;
            this_$iv.pointer.ensureOpen();
            try {
                void isEmpty;
                boolean isEmpty$iv;
                this_$iv.bindParams(db$iv);
                boolean bl3 = isEmpty$iv = SqliteConnectionKt.step(this_$iv.pointer.pointer, this_$iv.sql, db$iv);
                NativeDB db = db$iv;
                boolean bl4 = false;
                n = isEmpty != false ? null : Integer.valueOf(db.column_int(this.pointer.pointer, 0));
                db$iv.reset(this_$iv.pointer.pointer);
            }
            catch (Throwable throwable) {
                db$iv.reset(this_$iv.pointer.pointer);
                throw throwable;
            }
            Integer n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final int selectNotNullInt() {
        SqlitePreparedStatement this_$iv = this;
        boolean $i$f$executeLifecycle = false;
        SqliteConnection this_$iv$iv = this_$iv.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv$iv);
        lock.lock();
        try {
            int n;
            boolean bl = false;
            NativeDB db$iv = SqliteConnection.access$getDb(this_$iv$iv);
            boolean bl2 = false;
            this_$iv.pointer.ensureOpen();
            try {
                void isEmpty;
                boolean isEmpty$iv;
                this_$iv.bindParams(db$iv);
                boolean bl3 = isEmpty$iv = SqliteConnectionKt.step(this_$iv.pointer.pointer, this_$iv.sql, db$iv);
                NativeDB db = db$iv;
                boolean bl4 = false;
                if (isEmpty != false) {
                    throw new IllegalStateException("Must be not empty");
                }
                n = db.column_int(this.pointer.pointer, 0);
                db$iv.reset(this_$iv.pointer.pointer);
            }
            catch (Throwable throwable) {
                db$iv.reset(this_$iv.pointer.pointer);
                throw throwable;
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final byte[] selectByteArray() {
        SqlitePreparedStatement this_$iv = this;
        boolean $i$f$executeLifecycle = false;
        SqliteConnection this_$iv$iv = this_$iv.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv$iv);
        lock.lock();
        try {
            byte[] byArray;
            boolean bl = false;
            NativeDB db$iv = SqliteConnection.access$getDb(this_$iv$iv);
            boolean bl2 = false;
            this_$iv.pointer.ensureOpen();
            try {
                void isEmpty;
                boolean isEmpty$iv;
                this_$iv.bindParams(db$iv);
                boolean bl3 = isEmpty$iv = SqliteConnectionKt.step(this_$iv.pointer.pointer, this_$iv.sql, db$iv);
                NativeDB db = db$iv;
                boolean bl4 = false;
                byArray = isEmpty != false ? null : db.column_blob(this.pointer.pointer, 0);
                db$iv.reset(this_$iv.pointer.pointer);
            }
            catch (Throwable throwable) {
                db$iv.reset(this_$iv.pointer.pointer);
                throw throwable;
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final <T> T executeLifecycle(Function2<? super NativeDB, ? super Boolean, ? extends T> executor) {
        boolean $i$f$executeLifecycle = false;
        SqliteConnection this_$iv = this.connection;
        boolean $i$f$useDb$intellij_platform_sqlite = false;
        if (SqliteConnection.access$getDbRef$p(this_$iv).get() == null) {
            throw new AlreadyClosedException();
        }
        Lock lock = SqliteConnection.access$getLock$p(this_$iv);
        lock.lock();
        boolean bl = false;
        NativeDB db = SqliteConnection.access$getDb(this_$iv);
        boolean bl2 = false;
        this.pointer.ensureOpen();
        this.bindParams(db);
        boolean isEmpty = SqliteConnectionKt.step(this.pointer.pointer, this.sql, db);
        Object object = executor.invoke((Object)db, (Object)isEmpty);
        InlineMarker.finallyStart((int)1);
        db.reset(this.pointer.pointer);
        InlineMarker.finallyEnd((int)1);
        Object object2 = object;
        InlineMarker.finallyStart((int)3);
        lock.unlock();
        InlineMarker.finallyEnd((int)3);
        return (T)object2;
        {
            catch (Throwable throwable) {
                try {
                    InlineMarker.finallyStart((int)1);
                    db.reset(this.pointer.pointer);
                    InlineMarker.finallyEnd((int)1);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    InlineMarker.finallyStart((int)1);
                    lock.unlock();
                    InlineMarker.finallyEnd((int)1);
                    throw throwable2;
                }
            }
        }
    }

    private final void bindParams(NativeDB db) {
        ((Binder)this.binder).bindParams$intellij_platform_sqlite(this.pointer.pointer, db);
    }

    @NotNull
    public String toString() {
        return this.sql + " \n parameters=" + this.binder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeBatch() {
        if (((Binder)this.binder).getBatchQueryCount() == 0) {
            return;
        }
        try {
            SqliteConnection this_$iv = this.connection;
            boolean $i$f$useDb$intellij_platform_sqlite = false;
            if (SqliteConnection.access$getDbRef$p(this_$iv).get() == null) {
                throw new AlreadyClosedException();
            }
            Lock lock = SqliteConnection.access$getLock$p(this_$iv);
            lock.lock();
            try {
                boolean bl = false;
                NativeDB db = SqliteConnection.access$getDb(this_$iv);
                boolean bl2 = false;
                this.pointer.ensureOpen();
                ((Binder)this.binder).executeBatch$intellij_platform_sqlite(this.pointer.pointer, db);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            ((Binder)this.binder).clearBatch$intellij_platform_sqlite();
        }
    }
}

