/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import java.awt.Dimension;
import java.beans.PropertyChangeSupport;
import java.util.Objects;
import org.intellij.images.options.ZoomOptions;

final class ZoomOptionsImpl
implements ZoomOptions {
    private int prefferedWidth;
    private int prefferedHeight;
    private final PropertyChangeSupport propertyChangeSupport;

    ZoomOptionsImpl(PropertyChangeSupport propertyChangeSupport) {
        this.prefferedWidth = ZoomOptionsImpl.DEFAULT_PREFFERED_SIZE.width;
        this.prefferedHeight = ZoomOptionsImpl.DEFAULT_PREFFERED_SIZE.height;
        this.propertyChangeSupport = propertyChangeSupport;
    }

    @Override
    public Dimension getPrefferedSize() {
        return new Dimension(this.prefferedWidth, this.prefferedHeight);
    }

    void setPrefferedSize(Dimension prefferedSize) {
        if (prefferedSize == null) {
            prefferedSize = DEFAULT_PREFFERED_SIZE;
        }
        this.setPrefferedWidth(prefferedSize.width);
        this.setPrefferedHeight(prefferedSize.height);
    }

    void setPrefferedWidth(int prefferedWidth) {
        int oldValue = this.prefferedWidth;
        if (oldValue != prefferedWidth) {
            this.prefferedWidth = prefferedWidth;
            this.propertyChangeSupport.firePropertyChange("Editor.Zoom.prefferedWidth", oldValue, this.prefferedWidth);
        }
    }

    void setPrefferedHeight(int prefferedHeight) {
        int oldValue = this.prefferedHeight;
        if (oldValue != prefferedHeight) {
            this.prefferedHeight = prefferedHeight;
            this.propertyChangeSupport.firePropertyChange("Editor.Zoom.prefferedHeight", oldValue, this.prefferedHeight);
        }
    }

    @Override
    public void inject(ZoomOptions options) {
        this.setPrefferedSize(options.getPrefferedSize());
    }

    @Override
    public boolean setOption(String name, Object value) {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ZoomOptions)) {
            return false;
        }
        ZoomOptions otherOptions = (ZoomOptions)obj;
        Dimension prefferedSize = otherOptions.getPrefferedSize();
        return prefferedSize != null && this.prefferedHeight == prefferedSize.height && this.prefferedWidth == prefferedSize.width;
    }

    public int hashCode() {
        return Objects.hash(this.prefferedWidth, this.prefferedHeight, this.propertyChangeSupport);
    }
}

