/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.data;

import com.jetbrains.ml.api.feature.ComparableFeature;
import com.jetbrains.ml.api.feature.Feature;
import com.jetbrains.ml.api.feature.FeatureSignature;
import com.jetbrains.ml.api.feature.FeatureValueType;
import com.jetbrains.ml.api.feature.PrimitiveType;
import com.jetbrains.ml.api.feature.UnionType;
import com.jetbrains.ml.api.logs.FusMetadata;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010 \u001a\u00020\u0005H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006$"}, d2={"Lcom/jetbrains/ml/tools/data/ParsedFloatingFeature;", "Lcom/jetbrains/ml/api/feature/ComparableFeature;", "Lcom/jetbrains/ml/api/feature/Feature$Float;", "Lcom/jetbrains/ml/api/feature/Feature$Double;", "name", "", "content", "(Ljava/lang/String;Ljava/lang/String;)V", "doubleValue", "", "getDoubleValue", "()D", "floatValue", "", "getFloatValue", "()F", "floatingAsString", "getFloatingAsString", "()Ljava/lang/String;", "fusMetadata", "Lcom/jetbrains/ml/api/logs/FusMetadata;", "getFusMetadata", "()Lcom/jetbrains/ml/api/logs/FusMetadata;", "getName", "type", "Lcom/jetbrains/ml/api/feature/FeatureValueType;", "getType", "()Lcom/jetbrains/ml/api/feature/FeatureValueType;", "value", "", "getValue", "()Ljava/lang/Object;", "toString", "withName", "Lcom/jetbrains/ml/api/feature/Feature;", "newName", "ml-tools"})
public final class ParsedFloatingFeature
extends ComparableFeature
implements Feature.Float,
Feature.Double {
    @NotNull
    private final String name;
    @NotNull
    private final String content;
    @NotNull
    private final FeatureValueType type;
    @Nullable
    private final FusMetadata fusMetadata;

    public ParsedFloatingFeature(@NotNull String name, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.name = name;
        this.content = content;
        PrimitiveType[] primitiveTypeArray = new PrimitiveType[]{PrimitiveType.Float.INSTANCE, PrimitiveType.Double.INSTANCE};
        this.type = UnionType.Companion.of(primitiveTypeArray);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public FeatureValueType getType() {
        return this.type;
    }

    @Override
    public float getFloatValue() {
        return Float.parseFloat(this.content);
    }

    @Override
    public double getDoubleValue() {
        return Double.parseDouble(this.content);
    }

    @Override
    @Nullable
    public FusMetadata getFusMetadata() {
        return this.fusMetadata;
    }

    @Override
    @NotNull
    public String getFloatingAsString() {
        return this.content;
    }

    @Override
    @NotNull
    public Feature withName(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return new ParsedFloatingFeature(newName, this.content);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getName() + "(floating)='" + this.content + "'";
    }

    @Override
    @Nullable
    protected Object getValue() {
        return "'" + this.content + "'";
    }

    @Override
    @NotNull
    public Feature.Double getAsDoubleFeature() {
        return Feature.Float.DefaultImpls.getAsDoubleFeature(this);
    }

    @Override
    @NotNull
    public Feature.Float getAsFloatFeature() {
        return Feature.Float.DefaultImpls.getAsFloatFeature(this);
    }

    @Override
    @NotNull
    public Feature.Floating getAsFloatingFeature() {
        return Feature.Float.DefaultImpls.getAsFloatingFeature(this);
    }

    @Override
    @NotNull
    public Feature.Int32 getAsInt32Feature() {
        return Feature.Float.DefaultImpls.getAsInt32Feature(this);
    }

    @Override
    @NotNull
    public Feature.Int64 getAsInt64Feature() {
        return Feature.Float.DefaultImpls.getAsInt64Feature(this);
    }

    @Override
    @NotNull
    public Feature.String getAsStringFeature() {
        return Feature.Float.DefaultImpls.getAsStringFeature(this);
    }

    @Override
    @NotNull
    public FeatureSignature getSignature() {
        return Feature.Float.DefaultImpls.getSignature(this);
    }
}

