/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.psi.jupyter;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterLanguage;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.JupyterLangUtilKt;
import org.jetbrains.plugins.notebooks.psi.jupyter.NotebookLanguageProvider;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterTemplateTypes;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0006H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/notebooks/psi/jupyter/JupyterFileViewProvider;", "Lcom/intellij/psi/MultiplePsiFilesPerDocumentFileViewProvider;", "Lcom/intellij/psi/templateLanguages/TemplateLanguageFileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "eventSystemEnabled", "", "<init>", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "getTemplateDataLanguage", "Lcom/intellij/lang/Language;", "getLanguages", "", "getBaseLanguage", "cloneInner", "fileCopy", "createFile", "Lcom/intellij/psi/PsiFile;", "lang", "intellij.jupyter.psi"})
public class JupyterFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    public JupyterFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file, boolean eventSystemEnabled) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(manager, file, eventSystemEnabled);
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        VirtualFile virtualFile = this.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Language language = NotebookLanguageProvider.Companion.getTemplateLanguage(virtualFile, false);
        if (language == null) {
            JupyterFileViewProvider it = this;
            boolean bl = false;
            PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage, (String)"let(...)");
            language = (Language)plainTextLanguage;
        }
        return language;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Object[] objectArray = new Language[3];
        objectArray[0] = this.getBaseLanguage();
        VirtualFile virtualFile = this.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        objectArray[1] = NotebookLanguageProvider.Companion.getTemplateLanguage(virtualFile, true);
        objectArray[2] = JupyterLangUtilKt.getMarkdownLanguage();
        return SetsKt.setOfNotNull((Object[])objectArray);
    }

    @NotNull
    public Language getBaseLanguage() {
        return (Language)JupyterLanguage.INSTANCE;
    }

    @NotNull
    protected JupyterFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        Intrinsics.checkNotNullParameter((Object)fileCopy, (String)"fileCopy");
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"getManager(...)");
        return new JupyterFileViewProvider((PsiManager)psiManagerEx, fileCopy, false);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        LanguageParserDefinitions definitions = LanguageParserDefinitions.INSTANCE;
        ParserDefinition parserDefinition = (ParserDefinition)definitions.forLanguage(lang);
        if (parserDefinition == null && (parserDefinition = (ParserDefinition)definitions.forLanguage((Language)JupyterLanguage.INSTANCE)) == null) {
            return null;
        }
        ParserDefinition parserDefinition2 = parserDefinition;
        if (lang == JupyterLanguage.INSTANCE) {
            psiFile = parserDefinition2.createFile((FileViewProvider)this);
        } else if (lang == JupyterLangUtilKt.getMarkdownLanguage() && !Intrinsics.areEqual((Object)lang, (Object)Language.ANY)) {
            PsiFileImpl psiFileImpl;
            PsiFile psiFile2 = parserDefinition2.createFile((FileViewProvider)this);
            Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            PsiFileImpl $this$createFile_u24lambda_u241 = psiFileImpl = (PsiFileImpl)psiFile2;
            boolean bl = false;
            $this$createFile_u24lambda_u241.setContentElementType((IElementType)JupyterTemplateTypes.MARKDOWN_TEMPLATE);
            psiFile = (PsiFile)psiFileImpl;
        } else if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl psiFileImpl;
            PsiFile psiFile3 = parserDefinition2.createFile((FileViewProvider)this);
            Intrinsics.checkNotNull((Object)psiFile3, (String)"null cannot be cast to non-null type com.intellij.psi.impl.source.PsiFileImpl");
            PsiFileImpl $this$createFile_u24lambda_u242 = psiFileImpl = (PsiFileImpl)psiFile3;
            boolean bl = false;
            $this$createFile_u24lambda_u242.setContentElementType((IElementType)JupyterTemplateTypes.CODE_TEMPLATE);
            psiFile = (PsiFile)psiFileImpl;
        } else {
            psiFile = null;
        }
        return psiFile;
    }
}

