/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.thinclient.terminal;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.codeWithMe.model.RdTerminalSession;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.thinclient.terminal.ThinClientTerminalHost;
import com.jetbrains.thinclient.terminal.ThinClientTerminalInputStream;
import com.jetbrains.thinclient.terminal.ThinClientTerminalOutputStream;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/thinclient/terminal/ThinClientTerminalProcess;", "Ljava/lang/Process;", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "", "shellCommand", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/List;)V", "lifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/codeWithMe/model/RdTerminalSession;", "getModel", "()Lcom/jetbrains/codeWithMe/model/RdTerminalSession;", "outputStream", "Lcom/jetbrains/thinclient/terminal/ThinClientTerminalOutputStream;", "inputStream", "Lcom/jetbrains/thinclient/terminal/ThinClientTerminalInputStream;", "waitFor", "", "destroy", "", "getOutputStream", "getInputStream", "getErrorStream", "Ljava/io/InputStream;", "exitValue", "intellij.terminal.frontend.split"})
public final class ThinClientTerminalProcess
extends Process {
    @NotNull
    private final LifetimeDefinition lifetimeDef;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final RdTerminalSession model;
    @NotNull
    private final ThinClientTerminalOutputStream outputStream;
    @NotNull
    private final ThinClientTerminalInputStream inputStream;

    public ThinClientTerminalProcess(@NotNull Project project, @Nullable String workingDirectory, @Nullable List<String> shellCommand) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.lifetimeDef = ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)project)).createNested();
        this.lifetime = this.lifetimeDef.getLifetime();
        this.model = ThinClientTerminalHost.Companion.getInstance(project).getOrCreate(this.lifetime, workingDirectory, shellCommand);
        this.outputStream = new ThinClientTerminalOutputStream(this.model);
        this.inputStream = new ThinClientTerminalInputStream(this.lifetime, this.model);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final RdTerminalSession getModel() {
        return this.model;
    }

    @Override
    public int waitFor() {
        return 0;
    }

    @Override
    public void destroy() {
        if (RLifetimeKt.isAlive((Lifetime)this.lifetime)) {
            this.model.getClosed().set((Object)true);
        }
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDef, (boolean)false, (int)1, null);
    }

    @Override
    @NotNull
    public ThinClientTerminalOutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    @NotNull
    public ThinClientTerminalInputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    @NotNull
    public InputStream getErrorStream() {
        InputStream inputStream = InputStream.nullInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"nullInputStream(...)");
        return inputStream;
    }

    @Override
    public int exitValue() {
        return -1;
    }
}

