/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

class ContainerFocusOwnerFinder {
    ContainerFocusOwnerFinder() {
    }

    @Nullable
    @RunsInCurrentThread
    Component focusOwnerOf(@Nullable Container c) {
        if (!(c instanceof Window)) {
            return null;
        }
        return this.focusOwnerOf((Window)c);
    }

    @Nullable
    @RunsInCurrentThread
    private Component focusOwnerOf(@Nonnull Window w) {
        if (!w.isShowing()) {
            return null;
        }
        Component focus = w.getFocusOwner();
        if (focus != null) {
            return focus;
        }
        for (Window o : w.getOwnedWindows()) {
            focus = o.getFocusOwner();
            if (focus == null) continue;
            return focus;
        }
        return null;
    }
}

