/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.frontend;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.colors.ColorId;
import com.intellij.ide.ui.colors.ColorIdKt;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ide.vfs.VirtualFileId;
import com.intellij.ide.vfs.VirtualFileIdKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.recentFiles.frontend.SwitcherListItem;
import com.intellij.platform.recentFiles.shared.SwitcherRpcDto;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0005\u0010\rJ\u0012\u0010-\u001a\u0004\u0018\u00010#2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001cH\u0016J\u0013\u00105\u001a\u00020\u001c2\b\u00106\u001a\u0004\u0018\u000107H\u0096\u0002J\b\u00108\u001a\u00020/H\u0016R\u0019\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0013\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0019\u0010\u0015\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u001b\u0010\u0017\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u001b\u0010\u0019\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u0004\u0018\u00010#\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010%R\u0013\u0010(\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001e\u00a8\u00069"}, d2={"Lcom/intellij/platform/recentFiles/frontend/SwitcherVirtualFile;", "Lcom/intellij/platform/recentFiles/frontend/SwitcherListItem;", "Lcom/intellij/ui/BackgroundSupplier;", "rpcModel", "Lcom/intellij/platform/recentFiles/shared/SwitcherRpcDto$File;", "<init>", "(Lcom/intellij/platform/recentFiles/shared/SwitcherRpcDto$File;)V", "localFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "localIcon", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljavax/swing/Icon;Lcom/intellij/openapi/project/Project;)V", "mainText", "", "Lcom/intellij/openapi/util/NlsSafe;", "getMainText", "()Ljava/lang/String;", "statusText", "getStatusText", "pathText", "getPathText", "mnemonic", "getMnemonic", "shortcutText", "getShortcutText", "separatorAbove", "", "getSeparatorAbove", "()Z", "virtualFile", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "backgroundColor", "Ljava/awt/Color;", "getBackgroundColor", "()Ljava/awt/Color;", "foregroundTextColor", "getForegroundTextColor", "icon", "getIcon", "()Ljavax/swing/Icon;", "hasProblems", "getHasProblems", "getElementBackground", "row", "", "prepareMainRenderer", "", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "selected", "equals", "other", "", "hashCode", "intellij.platform.recentFiles.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSwitcherRendering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwitcherRendering.kt\ncom/intellij/platform/recentFiles/frontend/SwitcherVirtualFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
public final class SwitcherVirtualFile
implements SwitcherListItem,
BackgroundSupplier {
    @NotNull
    private final String mainText;
    @NotNull
    private final String statusText;
    @NotNull
    private final String pathText;
    @Nullable
    private final String mnemonic;
    @Nullable
    private final String shortcutText;
    private final boolean separatorAbove;
    @Nullable
    private final VirtualFile virtualFile;
    @Nullable
    private final Color backgroundColor;
    @Nullable
    private final Color foregroundTextColor;
    @Nullable
    private final Icon icon;
    private final boolean hasProblems;

    public SwitcherVirtualFile(@NotNull SwitcherRpcDto.File rpcModel) {
        Intrinsics.checkNotNullParameter((Object)rpcModel, (String)"rpcModel");
        this.mainText = rpcModel.getMainText();
        this.statusText = rpcModel.getStatusText();
        this.pathText = rpcModel.getPathText();
        this.mnemonic = null;
        this.shortcutText = null;
        this.separatorAbove = false;
        this.virtualFile = VirtualFileIdKt.virtualFile((VirtualFileId)rpcModel.getVirtualFileId());
        ColorId colorId = rpcModel.getBackgroundColorId();
        this.backgroundColor = colorId != null ? ColorIdKt.color((ColorId)colorId) : null;
        ColorId colorId2 = rpcModel.getForegroundTextColorId();
        this.foregroundTextColor = colorId2 != null ? ColorIdKt.color((ColorId)colorId2) : null;
        this.icon = IconIdKt.icon((IconId)rpcModel.getIconId());
        this.hasProblems = rpcModel.getHasProblems();
    }

    public SwitcherVirtualFile(@NotNull VirtualFile localFile, @NotNull Icon localIcon, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)localFile, (String)"localFile");
        Intrinsics.checkNotNullParameter((Object)localIcon, (String)"localIcon");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = localFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.mainText = string;
        this.statusText = "";
        this.pathText = "";
        this.mnemonic = null;
        this.shortcutText = null;
        this.separatorAbove = false;
        this.virtualFile = localFile;
        this.backgroundColor = null;
        this.foregroundTextColor = null;
        this.icon = localIcon;
        this.hasProblems = false;
    }

    @Override
    @NotNull
    public String getMainText() {
        return this.mainText;
    }

    @Override
    @NotNull
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    @NotNull
    public String getPathText() {
        return this.pathText;
    }

    @Override
    @Nullable
    public String getMnemonic() {
        return this.mnemonic;
    }

    @Override
    @Nullable
    public String getShortcutText() {
        return this.shortcutText;
    }

    @Override
    public boolean getSeparatorAbove() {
        return this.separatorAbove;
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Nullable
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Nullable
    public final Color getForegroundTextColor() {
        return this.foregroundTextColor;
    }

    @Nullable
    public final Icon getIcon() {
        return this.icon;
    }

    public final boolean getHasProblems() {
        return this.hasProblems;
    }

    @Nullable
    public Color getElementBackground(int row) {
        return this.backgroundColor;
    }

    @Override
    public void prepareMainRenderer(@NotNull SimpleColoredComponent component, boolean selected) {
        block7: {
            int n;
            Icon icon;
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            component.setIconTextGap(JBUI.scale((int)4));
            if (Registry.Companion.is("ide.project.view.change.icon.on.selection", true)) {
                icon = RenderingUtil.getIcon((Icon)this.icon, (boolean)selected);
            } else {
                icon = this.icon;
                if (icon == null) {
                    Icon icon2 = AllIcons.Nodes.EmptyNode;
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"EmptyNode");
                }
            }
            component.setIcon(icon);
            Color foreground = selected ? null : this.foregroundTextColor;
            JBColor effectColor = this.hasProblems ? JBColor.red : null;
            int style = effectColor == null ? 0 : 8;
            component.append(this.getMainText(), new SimpleTextAttributes(style, foreground, (Color)effectColor));
            Font font = component.getFont();
            if (font == null) break block7;
            Font it = font;
            boolean bl = false;
            FontMetrics fontMetrics = component.getFontMetrics(it);
            int mainTextWidth = UIUtil.computeStringWidth((JComponent)((JComponent)component), (FontMetrics)fontMetrics, (String)this.getMainText());
            String string = this.getShortcutText();
            if (string != null) {
                String shortcut = string;
                boolean bl2 = false;
                n = UIUtil.computeStringWidth((JComponent)((JComponent)component), (FontMetrics)fontMetrics, (String)shortcut);
            } else {
                n = 0;
            }
            int shortcutTextWidth = n;
            Icon icon3 = component.getIcon();
            int iconWidth = icon3 != null ? icon3.getIconWidth() : AllIcons.FileTypes.Text.getIconWidth();
            int width = component.getWidth() - mainTextWidth - shortcutTextWidth - component.getIconTextGap() - iconWidth - component.getInsets().left - component.getInsets().right;
            if (width > 0) {
                String string2 = PaintUtil.cutContainerText((String)(" " + this.getPathText()), (int)width, (JComponent)((JComponent)component));
                if (string2 != null) {
                    String fragment = string2;
                    boolean bl3 = false;
                    component.append(fragment, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SwitcherVirtualFile)) {
            return false;
        }
        return this.virtualFile != null && Intrinsics.areEqual((Object)this.virtualFile, (Object)((SwitcherVirtualFile)other).virtualFile);
    }

    public int hashCode() {
        VirtualFile virtualFile = this.virtualFile;
        return virtualFile != null ? virtualFile.hashCode() : Integer.MIN_VALUE;
    }
}

