/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyBaseConvertCollectionLiteralIntention
extends PsiUpdateModCommandAction<PsiElement> {
    private final Class<? extends PySequenceExpression> myTargetCollectionClass;
    private final String myTargetCollectionName;
    private final String myRightBrace;
    private final String myLeftBrace;

    public PyBaseConvertCollectionLiteralIntention(@NotNull Class<? extends PySequenceExpression> targetCollectionClass, @NotNull String targetCollectionName, @NotNull String leftBrace, @NotNull String rightBrace) {
        if (targetCollectionClass == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(0);
        }
        if (targetCollectionName == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(1);
        }
        if (leftBrace == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(2);
        }
        if (rightBrace == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(3);
        }
        super(PsiElement.class);
        this.myTargetCollectionClass = targetCollectionClass;
        this.myTargetCollectionName = targetCollectionName;
        this.myLeftBrace = leftBrace;
        this.myRightBrace = rightBrace;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.NAME.convert.collection.literal", this.myTargetCollectionName);
        if (string == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        if (context == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(6);
        }
        if (!(context.file() instanceof PyFile)) {
            return null;
        }
        PySequenceExpression literal = PyBaseConvertCollectionLiteralIntention.findCollectionLiteralUnderElement(element);
        if (this.myTargetCollectionClass.isInstance(literal)) {
            return null;
        }
        if (literal != null && this.isAvailableForCollection(literal)) {
            if (literal instanceof PyTupleExpression) {
                if (PyTypingTypeProvider.isInsideTypeHint((PsiElement)literal, TypeEvalContext.codeAnalysis(context.project(), context.file()))) {
                    return null;
                }
                return Presentation.of((String)PyPsiBundle.message("INTN.convert.collection.literal", "tuple", this.myTargetCollectionName));
            }
            if (literal instanceof PyListLiteralExpression) {
                return Presentation.of((String)PyPsiBundle.message("INTN.convert.collection.literal", "list", this.myTargetCollectionName));
            }
            if (literal instanceof PySetLiteralExpression) {
                return Presentation.of((String)PyPsiBundle.message("INTN.convert.collection.literal", "set", this.myTargetCollectionName));
            }
        }
        return null;
    }

    protected boolean isAvailableForCollection(@NotNull PySequenceExpression literal) {
        if (literal == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(7);
        }
        return true;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(8);
        }
        if (element == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(9);
        }
        if (updater == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(10);
        }
        PySequenceExpression literal = PyBaseConvertCollectionLiteralIntention.findCollectionLiteralUnderElement(element);
        assert (literal != null);
        PsiElement replacedElement = PyBaseConvertCollectionLiteralIntention.wrapCollection(literal);
        PsiElement copy = this.prepareOriginalElementCopy(replacedElement.copy());
        TextRange contentRange = PyBaseConvertCollectionLiteralIntention.getRangeOfContentWithoutBraces(copy);
        String contentToWrap = contentRange.substring(copy.getText());
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(context.project());
        PyExpression newLiteral = elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)context.file()), this.myLeftBrace + contentToWrap + this.myRightBrace);
        replacedElement.replace((PsiElement)newLiteral);
    }

    @NotNull
    protected PsiElement prepareOriginalElementCopy(@NotNull PsiElement copy) {
        PsiElement next;
        PyExpression[] elements;
        PySequenceExpression sequence;
        if (copy == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(11);
        }
        if ((sequence = PyBaseConvertCollectionLiteralIntention.unwrapCollection(copy)) instanceof PyTupleExpression && (elements = sequence.getElements()).length == 1 && (next = PyPsiUtils.getNextNonCommentSibling((PsiElement)elements[0], true)) != null && next.getNode().getElementType() == PyTokenTypes.COMMA) {
            next.delete();
        }
        PsiElement psiElement = copy;
        if (psiElement == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    @NotNull
    protected static PySequenceExpression unwrapCollection(@NotNull PsiElement literal) {
        PyParenthesizedExpression parenthesizedExpression;
        if (literal == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(13);
        }
        if ((parenthesizedExpression = PyUtil.as(literal, PyParenthesizedExpression.class)) != null) {
            PyExpression containedExpression = parenthesizedExpression.getContainedExpression();
            assert (containedExpression != null);
            PyTupleExpression pyTupleExpression = (PyTupleExpression)containedExpression;
            if (pyTupleExpression == null) {
                PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(14);
            }
            return pyTupleExpression;
        }
        PySequenceExpression pySequenceExpression = (PySequenceExpression)literal;
        if (pySequenceExpression == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(15);
        }
        return pySequenceExpression;
    }

    @NotNull
    protected static PsiElement wrapCollection(@NotNull PySequenceExpression literal) {
        if (literal == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(16);
        }
        if (literal instanceof PyTupleExpression && literal.getParent() instanceof PyParenthesizedExpression) {
            PsiElement psiElement = literal.getParent();
            if (psiElement == null) {
                PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(17);
            }
            return psiElement;
        }
        PySequenceExpression pySequenceExpression = literal;
        if (pySequenceExpression == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(18);
        }
        return pySequenceExpression;
    }

    @NotNull
    private static TextRange getRangeOfContentWithoutBraces(@NotNull PsiElement literal) {
        if (literal == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(19);
        }
        if (literal instanceof PyTupleExpression) {
            TextRange textRange = TextRange.create((int)0, (int)literal.getTextLength());
            if (textRange == null) {
                PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(20);
            }
            return textRange;
        }
        String replacedText = literal.getText();
        PsiElement firstChild = literal.getFirstChild();
        int contentStartOffset = PyTokenTypes.OPEN_BRACES.contains(firstChild.getNode().getElementType()) ? firstChild.getTextLength() : 0;
        PsiElement lastChild = literal.getLastChild();
        int contentEndOffset = PyTokenTypes.CLOSE_BRACES.contains(lastChild.getNode().getElementType()) ? replacedText.length() - lastChild.getTextLength() : replacedText.length();
        TextRange textRange = TextRange.create((int)contentStartOffset, (int)contentEndOffset);
        if (textRange == null) {
            PyBaseConvertCollectionLiteralIntention.$$$reportNull$$$0(21);
        }
        return textRange;
    }

    @Nullable
    private static PySequenceExpression findCollectionLiteralUnderElement(PsiElement curElem) {
        PySequenceExpression seqExpr = (PySequenceExpression)PsiTreeUtil.getParentOfType((PsiElement)curElem, PySequenceExpression.class);
        if (seqExpr != null) {
            return seqExpr;
        }
        PyParenthesizedExpression paren = (PyParenthesizedExpression)PsiTreeUtil.findFirstParent((PsiElement)curElem, element -> {
            PyParenthesizedExpression parenthesizedExpr = PyUtil.as(element, PyParenthesizedExpression.class);
            return parenthesizedExpr != null && parenthesizedExpr.getContainedExpression() instanceof PyTupleExpression;
        });
        return paren != null ? (PyTupleExpression)paren.getContainedExpression() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 12, 14, 15, 17, 18, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCollectionClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCollectionName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftBrace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightBrace";
                break;
            }
            case 4: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyBaseConvertCollectionLiteralIntention";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyBaseConvertCollectionLiteralIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareOriginalElementCopy";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapCollection";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapCollection";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeOfContentWithoutBraces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForCollection";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareOriginalElementCopy";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "unwrapCollection";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "wrapCollection";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRangeOfContentWithoutBraces";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 12, 14, 15, 17, 18, 20, 21 -> new IllegalStateException(string);
        };
    }
}

