/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import com.jetbrains.python.console.PyConsoleOptionsConfigurable;
import com.jetbrains.python.console.actions.CommandQueueForPythonConsoleService;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.run.PythonRunParams;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PyConsoleOptionsProvider", storages={@Storage(value="$WORKSPACE_FILE$")})
public class PyConsoleOptions
implements PersistentStateComponent<State> {
    private final State myState = new State();

    @NotNull
    public PyConsoleSettings getPythonConsoleSettings() {
        PyConsoleSettings pyConsoleSettings = this.myState.myPythonConsoleState;
        if (pyConsoleSettings == null) {
            PyConsoleOptions.$$$reportNull$$$0(0);
        }
        return pyConsoleSettings;
    }

    public boolean isShowDebugConsoleByDefault() {
        return this.myState.myShowDebugConsoleByDefault;
    }

    public void setShowDebugConsoleByDefault(boolean showDebugConsoleByDefault) {
        this.myState.myShowDebugConsoleByDefault = showDebugConsoleByDefault;
    }

    public boolean isShowVariableByDefault() {
        return this.myState.myShowVariablesByDefault;
    }

    public void setShowVariablesByDefault(boolean showVariableByDefault) {
        this.myState.myShowVariablesByDefault = showVariableByDefault;
    }

    public boolean isIpythonEnabled() {
        return this.myState.myIpythonEnabled;
    }

    public void setIpythonEnabled(boolean enabled) {
        this.myState.myIpythonEnabled = enabled;
    }

    public boolean isUseExistingConsole() {
        return this.myState.myUseExistingConsole;
    }

    public void setUseExistingConsole(boolean enabled) {
        this.myState.myUseExistingConsole = enabled;
    }

    public void setCommandQueueEnabled(boolean selected) {
        this.myState.myCommandQueueEnabled = selected;
        if (!selected) {
            ((CommandQueueForPythonConsoleService)ApplicationManager.getApplication().getService(CommandQueueForPythonConsoleService.class)).disableCommandQueue();
        }
    }

    public boolean isCommandQueueEnabled() {
        return this.myState.myCommandQueueEnabled;
    }

    public void setCodeCompletionOption(PyConsoleOptionsConfigurable.CodeCompletionOption selected) {
        this.myState.myCodeCompletionOption = selected;
    }

    public PyConsoleOptionsConfigurable.CodeCompletionOption getCodeCompletionOption() {
        return this.myState.myCodeCompletionOption;
    }

    public boolean isRuntimeCodeCompletion() {
        return this.myState.myCodeCompletionOption == PyConsoleOptionsConfigurable.CodeCompletionOption.RUNTIME;
    }

    public static PyConsoleOptions getInstance(Project project) {
        return (PyConsoleOptions)project.getService(PyConsoleOptions.class);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PyConsoleOptions.$$$reportNull$$$0(1);
        }
        this.myState.myShowDebugConsoleByDefault = state.myShowDebugConsoleByDefault;
        this.myState.myShowVariablesByDefault = state.myShowVariablesByDefault;
        this.myState.myPythonConsoleState = state.myPythonConsoleState;
        this.myState.myIpythonEnabled = state.myIpythonEnabled;
        this.myState.myUseExistingConsole = state.myUseExistingConsole;
        this.myState.myCommandQueueEnabled = state.myCommandQueueEnabled;
        this.myState.myCodeCompletionOption = state.myCodeCompletionOption;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PyConsoleOptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonConsoleSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PyConsoleOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static class State {
        public PyConsoleSettings myPythonConsoleState = new PyConsoleSettings();
        public boolean myShowDebugConsoleByDefault = true;
        public boolean myShowVariablesByDefault = true;
        public boolean myIpythonEnabled = true;
        public boolean myUseExistingConsole = false;
        public boolean myCommandQueueEnabled = PlatformUtils.isDataSpell();
        public PyConsoleOptionsConfigurable.CodeCompletionOption myCodeCompletionOption = PyConsoleOptionsConfigurable.CodeCompletionOption.STATIC;
    }

    @Tag(value="console-settings")
    public static class PyConsoleSettings
    implements PythonRunParams {
        public String myCustomStartScript = "import sys; print('Python %s on %s' % (sys.version, sys.platform))\nsys.path.extend([WORKING_DIR_AND_PYTHON_PATHS])\n";
        public String mySdkHome = null;
        public Sdk mySdk = null;
        public String myInterpreterOptions = "";
        public boolean myUseModuleSdk;
        public String myModuleName = null;
        public Map<String, String> myEnvs = Maps.newHashMap();
        @NotNull
        public List<String> myEnvFiles = Collections.emptyList();
        public boolean myPassParentEnvs = true;
        public String myWorkingDirectory = "";
        public boolean myAddContentRoots = true;
        public boolean myAddSourceRoots = true;
        @NotNull
        private PathMappingSettings myMappings = new PathMappingSettings();
        private boolean myUseSoftWraps = false;

        public PyConsoleSettings() {
        }

        public PyConsoleSettings(String myCustomStartScript) {
            this.myCustomStartScript = myCustomStartScript;
        }

        public void apply(AbstractPythonRunConfigurationParams form) {
            this.mySdkHome = form.getSdkHome();
            this.mySdk = form.getSdk();
            this.myInterpreterOptions = form.getInterpreterOptions();
            this.myEnvs = form.getEnvs();
            this.myEnvFiles = form.getEnvFilePaths();
            this.myPassParentEnvs = form.isPassParentEnvs();
            this.myUseModuleSdk = form.isUseModuleSdk();
            this.myModuleName = form.getModule() == null ? null : form.getModule().getName();
            this.myWorkingDirectory = form.getWorkingDirectory();
            this.myAddContentRoots = form.shouldAddContentRoots();
            this.myAddSourceRoots = form.shouldAddSourceRoots();
            this.myMappings = form.getMappingSettings() == null ? new PathMappingSettings() : form.getMappingSettings();
        }

        public boolean isModified(AbstractPyCommonOptionsForm form) {
            return !ComparatorUtil.equalsNullable((Object)this.mySdkHome, (Object)form.getSdkHome()) || !this.myInterpreterOptions.equals(form.getInterpreterOptions()) || !this.myEnvs.equals(form.getEnvs()) || !this.myEnvFiles.equals(form.getEnvFilePaths()) || this.myPassParentEnvs != form.isPassParentEnvs() || this.myUseModuleSdk != form.isUseModuleSdk() || this.myAddContentRoots != form.shouldAddContentRoots() || this.myAddSourceRoots != form.shouldAddSourceRoots() || !ComparatorUtil.equalsNullable((Object)this.myModuleName, form.getModule() == null ? null : form.getModule().getName()) || !this.myWorkingDirectory.equals(form.getWorkingDirectory()) || !this.myMappings.equals((Object)form.getMappingSettings());
        }

        public void reset(Project project, AbstractPythonRunConfigurationParams form) {
            form.setEnvs(this.myEnvs);
            form.setEnvFilePaths(this.myEnvFiles);
            form.setPassParentEnvs(this.myPassParentEnvs);
            form.setInterpreterOptions(this.myInterpreterOptions);
            form.setSdkHome(this.mySdkHome);
            form.setSdk(this.mySdk);
            form.setUseModuleSdk(this.myUseModuleSdk);
            form.setAddContentRoots(this.myAddContentRoots);
            form.setAddSourceRoots(this.myAddSourceRoots);
            boolean moduleWasAutoselected = false;
            if (form.isUseModuleSdk() != this.myUseModuleSdk) {
                this.myUseModuleSdk = form.isUseModuleSdk();
                moduleWasAutoselected = true;
            }
            if (this.myModuleName != null) {
                form.setModule(ModuleManager.getInstance((Project)project).findModuleByName(this.myModuleName));
            }
            if (moduleWasAutoselected && form.getModule() != null) {
                this.myModuleName = form.getModule().getName();
            }
            form.setWorkingDirectory(this.myWorkingDirectory);
            form.setMappingSettings(this.myMappings);
        }

        @Attribute(value="custom-start-script")
        public String getCustomStartScript() {
            return this.myCustomStartScript;
        }

        @Override
        @Attribute(value="sdk-home")
        public String getSdkHome() {
            return this.mySdkHome;
        }

        @Override
        @Nullable
        public Sdk getSdk() {
            return this.mySdk;
        }

        @Override
        @Attribute(value="module-name")
        public String getModuleName() {
            return this.myModuleName;
        }

        @Override
        @Attribute(value="working-directory")
        public String getWorkingDirectory() {
            return this.myWorkingDirectory;
        }

        @Override
        @Attribute(value="is-module-sdk")
        public boolean isUseModuleSdk() {
            return this.myUseModuleSdk;
        }

        @Override
        @XMap(propertyElementName="envs", entryTagName="env")
        public Map<String, String> getEnvs() {
            return this.myEnvs;
        }

        @Override
        @Attribute(value="add-content-roots")
        public boolean shouldAddContentRoots() {
            return this.myAddContentRoots;
        }

        @Override
        @Attribute(value="add-source-roots")
        public boolean shouldAddSourceRoots() {
            return this.myAddSourceRoots;
        }

        @Override
        @Attribute(value="interpreter-options")
        public String getInterpreterOptions() {
            return this.myInterpreterOptions;
        }

        @XCollection
        @NotNull
        public PathMappingSettings getMappings() {
            PathMappingSettings pathMappingSettings = this.myMappings;
            if (pathMappingSettings == null) {
                PyConsoleSettings.$$$reportNull$$$0(0);
            }
            return pathMappingSettings;
        }

        public void setCustomStartScript(String customStartScript) {
            this.myCustomStartScript = customStartScript;
        }

        @Override
        public void setSdkHome(String sdkHome) {
            this.mySdkHome = sdkHome;
        }

        @Override
        public void setSdk(@Nullable Sdk sdk2) {
            this.mySdk = sdk2;
        }

        @Override
        public void setModule(Module module2) {
            this.setModuleName(module2.getName());
        }

        @Override
        public void setInterpreterOptions(String interpreterOptions) {
            this.myInterpreterOptions = interpreterOptions;
        }

        @Override
        public void setUseModuleSdk(boolean useModuleSdk) {
            this.myUseModuleSdk = useModuleSdk;
        }

        @Override
        @Attribute(value="is-pass-parent-envs")
        public boolean isPassParentEnvs() {
            return this.myPassParentEnvs;
        }

        @Override
        public void setPassParentEnvs(boolean passParentEnvs) {
            this.myPassParentEnvs = passParentEnvs;
        }

        public void setModuleName(String moduleName) {
            this.myModuleName = moduleName;
        }

        @Override
        public void setEnvs(Map<String, String> envs) {
            this.myEnvs = envs;
        }

        @Override
        @Nullable
        public PathMappingSettings getMappingSettings() {
            return this.getMappings();
        }

        @Override
        public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        }

        @Override
        public void setWorkingDirectory(String workingDirectory) {
            this.myWorkingDirectory = workingDirectory;
        }

        @Override
        public void setAddContentRoots(boolean addContentRoots) {
            this.myAddContentRoots = addContentRoots;
        }

        @Override
        public void setAddSourceRoots(boolean addSourceRoots) {
            this.myAddSourceRoots = addSourceRoots;
        }

        public void setMappings(@Nullable PathMappingSettings mappings) {
            this.myMappings = mappings != null ? mappings : new PathMappingSettings();
        }

        public boolean isUseSoftWraps() {
            return this.myUseSoftWraps;
        }

        public void setUseSoftWraps(boolean useSoftWraps) {
            this.myUseSoftWraps = useSoftWraps;
        }

        @NotNull
        public List<String> getEnvFilePaths() {
            List<String> list = this.myEnvFiles;
            if (list == null) {
                PyConsoleSettings.$$$reportNull$$$0(1);
            }
            return list;
        }

        public void setEnvFilePaths(@NotNull List<String> strings) {
            if (strings == null) {
                PyConsoleSettings.$$$reportNull$$$0(2);
            }
            this.myEnvFiles = strings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnvFilePaths";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/console/PyConsoleOptions$PyConsoleSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setEnvFilePaths";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

