/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.jetbrains.python.debugger.QuotingPolicy;
import com.jetbrains.python.debugger.ValuesPolicy;
import com.jetbrains.python.debugger.settings.PyDebuggerSteppingConfigurableUi;
import com.jetbrains.python.debugger.settings.PySteppingFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PyDebuggerSettings
extends XDebuggerSettings<PyDebuggerSettings> {
    private boolean myLibrariesFilterEnabled;
    private boolean mySteppingFiltersEnabled;
    @NotNull
    private List<PySteppingFilter> mySteppingFilters;
    public static final String FILTERS_DIVIDER = ";";
    private boolean myWatchReturnValues = false;
    private boolean mySimplifiedView = true;
    private volatile ValuesPolicy myValuesPolicy = ValuesPolicy.ASYNC;
    private volatile QuotingPolicy myQuotingPolicy = QuotingPolicy.SINGLE;
    private boolean myAlwaysDoSmartStepIntoEnabled = true;

    public PyDebuggerSettings() {
        super("python");
        this.mySteppingFilters = new SmartList();
    }

    public boolean isWatchReturnValues() {
        return this.myWatchReturnValues;
    }

    public void setWatchReturnValues(boolean watchReturnValues) {
        this.myWatchReturnValues = watchReturnValues;
    }

    public boolean isSimplifiedView() {
        return this.mySimplifiedView;
    }

    public void setSimplifiedView(boolean simplifiedView) {
        this.mySimplifiedView = simplifiedView;
    }

    public ValuesPolicy getValuesPolicy() {
        return this.myValuesPolicy;
    }

    public void setValuesPolicy(ValuesPolicy valuesPolicy) {
        this.myValuesPolicy = valuesPolicy;
    }

    public QuotingPolicy getQuotingPolicy() {
        return this.myQuotingPolicy;
    }

    public void setQuotingPolicy(QuotingPolicy copyQuotingPolicy) {
        this.myQuotingPolicy = copyQuotingPolicy;
    }

    public static PyDebuggerSettings getInstance() {
        return (PyDebuggerSettings)PyDebuggerSettings.getInstance(PyDebuggerSettings.class);
    }

    public boolean isLibrariesFilterEnabled() {
        return this.myLibrariesFilterEnabled;
    }

    public void setLibrariesFilterEnabled(boolean librariesFilterEnabled) {
        this.myLibrariesFilterEnabled = librariesFilterEnabled;
    }

    public boolean isSteppingFiltersEnabled() {
        return this.mySteppingFiltersEnabled;
    }

    public void setSteppingFiltersEnabled(boolean steppingFiltersEnabled) {
        this.mySteppingFiltersEnabled = steppingFiltersEnabled;
    }

    public void setAlwaysDoSmartStepIntoEnabled(boolean alwaysDoSmartStepIntoEnabled) {
        this.myAlwaysDoSmartStepIntoEnabled = alwaysDoSmartStepIntoEnabled;
    }

    public boolean isAlwaysDoSmartStepInto() {
        return this.myAlwaysDoSmartStepIntoEnabled;
    }

    @NotNull
    public List<PySteppingFilter> getSteppingFilters() {
        List<PySteppingFilter> list = this.mySteppingFilters;
        if (list == null) {
            PyDebuggerSettings.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public String getSteppingFiltersForProject(@NotNull Project project) {
        if (project == null) {
            PyDebuggerSettings.$$$reportNull$$$0(1);
        }
        StringBuilder sb = new StringBuilder();
        for (PySteppingFilter filter : this.mySteppingFilters) {
            if (!filter.isEnabled()) continue;
            sb.append(filter.getAbsolutePlatformIndependentFilter(project)).append(FILTERS_DIVIDER);
        }
        String string = sb.toString();
        if (string == null) {
            PyDebuggerSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setSteppingFilters(@NotNull List<PySteppingFilter> steppingFilters) {
        if (steppingFilters == null) {
            PyDebuggerSettings.$$$reportNull$$$0(3);
        }
        this.mySteppingFilters = steppingFilters;
    }

    @NotNull
    public PyDebuggerSettings getState() {
        PyDebuggerSettings pyDebuggerSettings = this;
        if (pyDebuggerSettings == null) {
            PyDebuggerSettings.$$$reportNull$$$0(4);
        }
        return pyDebuggerSettings;
    }

    public void loadState(@NotNull PyDebuggerSettings state) {
        if (state == null) {
            PyDebuggerSettings.$$$reportNull$$$0(5);
        }
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    public boolean isTargetedToProduct(@NotNull Configurable configurable) {
        if (configurable == null) {
            PyDebuggerSettings.$$$reportNull$$$0(6);
        }
        return true;
    }

    @NotNull
    public Collection<? extends Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            PyDebuggerSettings.$$$reportNull$$$0(7);
        }
        if (category == DebuggerSettingsCategory.STEPPING) {
            List<SimpleConfigurable> list = Collections.singletonList(SimpleConfigurable.create((String)"python.debug.configurable", (String)"Python", PyDebuggerSteppingConfigurableUi.class, () -> this));
            if (list == null) {
                PyDebuggerSettings.$$$reportNull$$$0(8);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            PyDebuggerSettings.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/settings/PyDebuggerSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "steppingFilters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSteppingFilters";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/settings/PyDebuggerSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSteppingFiltersForProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSteppingFiltersForProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSteppingFilters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTargetedToProduct";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

