/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.quickfix.PyInstallRequirementsFix;
import com.jetbrains.python.inspections.requirement.RunningPackagingTasksListener;
import com.jetbrains.python.packaging.PyPackageInstallUtils;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.statistics.PyPackagesUsageCollector;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\b\u001a\u00070\u0003\u00a2\u0006\u0002\b\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0012\u0010\u0013\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/python/inspections/quickfix/InstallPackageQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "packageName", "", "<init>", "(Ljava/lang/String;)V", "getPackageName", "()Ljava/lang/String;", "getFamilyName", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "startInWriteAction", "", "availableInBatchMode", "onSuccess", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "Companion", "intellij.python.community.impl"})
public class InstallPackageQuickFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String packageName;
    @NotNull
    public static final String CONFIRM_PACKAGE_INSTALLATION_PROPERTY = "python.confirm.package.installation";

    public InstallPackageQuickFix(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.packageName = packageName;
    }

    @NotNull
    public String getPackageName() {
        return this.packageName;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.getPackageName()};
        String string = PyBundle.message("python.unresolved.reference.inspection.install.package", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!PyPackageInstallUtils.INSTANCE.confirmInstall(project, this.getPackageName())) {
            return;
        }
        PsiElement element = descriptor2.getPsiElement();
        boolean bl = false;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module2 == null) {
            return;
        }
        Module module3 = module2;
        Sdk sdk2 = PythonSdkUtil.findPythonSdk(element);
        if (sdk2 == null) {
            return;
        }
        Sdk sdk3 = sdk2;
        PyInstallRequirementsFix pyInstallRequirementsFix = new PyInstallRequirementsFix(this.getFamilyName(), sdk3, CollectionsKt.listOf((Object)PyRequirementsKt.pyRequirement$default(this.getPackageName(), null, 2, null)), null, new RunningPackagingTasksListener(module3, this, descriptor2){
            final /* synthetic */ InstallPackageQuickFix this$0;
            final /* synthetic */ ProblemDescriptor $descriptor;
            {
                this.this$0 = $receiver;
                this.$descriptor = $descriptor;
                super($module);
            }

            public void finished(List<? extends ExecutionException> exceptions) {
                Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
                this.this$0.onSuccess(this.$descriptor);
            }
        }, 8, null);
        Project project2 = module3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        pyInstallRequirementsFix.applyFix(project2, descriptor2);
        PyPackagesUsageCollector.installSingleEvent.log();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean availableInBatchMode() {
        return false;
    }

    public void onSuccess(@Nullable ProblemDescriptor descriptor2) {
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/python/inspections/quickfix/InstallPackageQuickFix$Companion;", "", "<init>", "()V", "CONFIRM_PACKAGE_INSTALLATION_PROPERTY", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

