/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.python.PyStubElementTypes;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.codeInsight.controlflow.CallInstruction;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.PyDataFlow;
import com.jetbrains.python.codeInsight.controlflow.PyFinallyFailExitInstruction;
import com.jetbrains.python.codeInsight.controlflow.PyRaiseInstruction;
import com.jetbrains.python.codeInsight.controlflow.PyWithContextExitInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PsiQuery;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecorator;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeParameterList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.icons.PythonPsiApiIcons;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyDeprecationUtilKt;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.stubs.PyAnnotationOwnerStub;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyDynamicallyEvaluatedType;
import com.jetbrains.python.psi.types.PyFunctionTypeImpl;
import com.jetbrains.python.psi.types.PyNarrowedType;
import com.jetbrains.python.psi.types.PyNeverType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFunctionImpl
extends PyBaseElementImpl<PyFunctionStub>
implements PyFunction {
    private static final Key<CachedValue<List<PyAssignmentStatement>>> ATTRIBUTES_KEY = Key.create((String)"attributes");
    @NotNull
    private final CachedStructuredDocStringProvider myCachedStructuredDocStringProvider = new CachedStructuredDocStringProvider();
    @Nullable
    private volatile Boolean myIsGenerator;

    public PyFunctionImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyFunctionImpl(PyFunctionStub stub) {
        this(stub, (IStubElementType)PyStubElementTypes.FUNCTION_DECLARATION);
    }

    public PyFunctionImpl(PyFunctionStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Nullable
    public String getName() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        return PyFunction.super.getName();
    }

    @NotNull
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            PyFunctionImpl.$$$reportNull$$$0(0);
        }
        ASTNode nameElement = PyUtil.createNewName(this, name2);
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            this.getNode().replaceChild(nameNode, nameElement);
        }
        PyFunctionImpl pyFunctionImpl = this;
        if (pyFunctionImpl == null) {
            PyFunctionImpl.$$$reportNull$$$0(1);
        }
        return pyFunctionImpl;
    }

    public Icon getIcon(int flags) {
        PyPsiUtils.assertValid(this);
        Property property = this.getProperty();
        if (property != null) {
            if (property.getGetter().valueOrNull() == this) {
                return PythonPsiApiIcons.PropertyGetter;
            }
            if (property.getSetter().valueOrNull() == this) {
                return PythonPsiApiIcons.PropertySetter;
            }
            if (property.getDeleter().valueOrNull() == this) {
                return PythonPsiApiIcons.PropertyDeleter;
            }
            return com.intellij.util.PlatformIcons.PROPERTY_ICON;
        }
        IconManager iconManager = IconManager.getInstance();
        if (this.getContainingClass() != null) {
            return iconManager.getPlatformIcon(PlatformIcons.Method);
        }
        return iconManager.getPlatformIcon(PlatformIcons.Function);
    }

    @Override
    @NotNull
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(2);
        }
        List list = Optional.ofNullable(context.getType(this)).filter(PyCallableType.class::isInstance).map(PyCallableType.class::cast).map(callableType -> callableType.getParameters(context)).orElseGet(() -> ContainerUtil.map((Object[])this.getParameterList().getParameters(), PyCallableParameterImpl::psi));
        if (list == null) {
            PyFunctionImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public PyClass getContainingClass() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            StubElement parentStub = stub.getParentStub();
            if (parentStub instanceof PyClassStub) {
                return (PyClass)((PyClassStub)parentStub).getPsi();
            }
            return null;
        }
        return PyFunction.super.getContainingClass();
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(4);
        }
        if (key == null) {
            PyFunctionImpl.$$$reportNull$$$0(5);
        }
        for (PyTypeProvider typeProvider : PyTypeProvider.EP_NAME.getExtensionList()) {
            Ref<PyType> returnTypeRef = typeProvider.getReturnType(this, context);
            if (returnTypeRef == null) continue;
            return PyTypingTypeProvider.removeNarrowedTypeIfNeeded(PyFunctionImpl.derefType(returnTypeRef, typeProvider));
        }
        return this.getInferredReturnType(context);
    }

    @Override
    @Nullable
    public PyType getInferredReturnType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(6);
        }
        PyType inferredType = null;
        if (context.allowReturnTypes(this)) {
            PyType returnType = this.getReturnStatementType(context);
            Pair<PyType, PyType> yieldSendTypePair = this.getYieldExpressionType(context);
            inferredType = yieldSendTypePair != null ? PyTypingTypeProvider.wrapInGeneratorType((PyType)yieldSendTypePair.first, (PyType)yieldSendTypePair.second, returnType, this) : returnType;
        }
        inferredType = PyNeverType.toNoReturnIfNeeded(inferredType);
        return PyTypingTypeProvider.removeNarrowedTypeIfNeeded(PyTypingTypeProvider.toAsyncIfNeeded(this, inferredType));
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(7);
        }
        if (callSite == null) {
            PyFunctionImpl.$$$reportNull$$$0(8);
        }
        for (PyTypeProvider typeProvider : PyTypeProvider.EP_NAME.getExtensionList()) {
            Ref<PyType> typeRef = typeProvider.getCallType(this, callSite, context);
            if (typeRef == null) continue;
            return PyFunctionImpl.derefType(typeRef, typeProvider);
        }
        PyExpression receiver = callSite.getReceiver(this);
        PyCallExpression.PyArgumentsMapping fullMapping = PyCallExpressionHelper.mapArguments(callSite, this, context);
        Map<PyExpression, PyCallableParameter> mappedExplicitParameters = fullMapping.getMappedParameters();
        LinkedHashMap<PyExpression, PyCallableParameter> allMappedParameters = new LinkedHashMap<PyExpression, PyCallableParameter>();
        PyCallableParameter firstImplicit = (PyCallableParameter)ContainerUtil.getFirstItem(fullMapping.getImplicitParameters());
        if (receiver != null && firstImplicit != null) {
            allMappedParameters.put(receiver, firstImplicit);
        }
        allMappedParameters.putAll(mappedExplicitParameters);
        return this.getCallType(receiver, callSite, allMappedParameters, context);
    }

    @Nullable
    private static PyType derefType(@NotNull Ref<PyType> typeRef, @NotNull PyTypeProvider typeProvider) {
        PyType type2;
        if (typeRef == null) {
            PyFunctionImpl.$$$reportNull$$$0(9);
        }
        if (typeProvider == null) {
            PyFunctionImpl.$$$reportNull$$$0(10);
        }
        if ((type2 = (PyType)typeRef.get()) != null) {
            type2.assertValid(typeProvider.toString());
        }
        return type2;
    }

    @Override
    @Nullable
    public PyType getCallType(@Nullable PyExpression receiver, @Nullable PyCallSiteExpression callSiteExpression, @NotNull Map<PyExpression, PyCallableParameter> parameters, @NotNull TypeEvalContext context) {
        if (parameters == null) {
            PyFunctionImpl.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(12);
        }
        return this.analyzeCallType(PyUtil.getReturnTypeToAnalyzeAsCallType(this, context), receiver, callSiteExpression, parameters, context);
    }

    @Nullable
    private PyType analyzeCallType(@Nullable PyType type2, @Nullable PyExpression receiver, @Nullable PyCallSiteExpression callSiteExpression, @NotNull Map<PyExpression, PyCallableParameter> parameters, @NotNull TypeEvalContext context) {
        if (parameters == null) {
            PyFunctionImpl.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(14);
        }
        if (PyTypeChecker.hasGenerics(type2, context)) {
            PyTypeChecker.GenericSubstitutions substitutions = PyTypeChecker.unifyGenericCall(receiver, parameters, context);
            if (substitutions != null) {
                PyTypeChecker.GenericSubstitutions substitutionsWithUnresolvedReturnGenerics = PyTypeChecker.getSubstitutionsWithUnresolvedReturnGenerics(this.getParameters(context), type2, substitutions, context);
                type2 = PyTypeChecker.substitute(type2, substitutionsWithUnresolvedReturnGenerics, context);
            } else {
                type2 = null;
            }
        } else if (receiver != null) {
            type2 = this.replaceSelf(type2, receiver, context);
        }
        if (type2 != null && PyFunctionImpl.isDynamicallyEvaluated(parameters.values(), context)) {
            type2 = PyUnionType.createWeakType(type2);
        }
        return PyNarrowedType.Companion.bindIfNeeded(type2, callSiteExpression);
    }

    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this){

            @Override
            @NotNull
            public String getPresentableText() {
                String string = StringUtil.notNullize((String)PyFunctionImpl.this.getName(), (String)"<unnamed>") + PyFunctionImpl.this.getParameterList().getPresentableText(true);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyFunctionImpl$1", "getPresentableText"));
            }
        };
    }

    @Nullable
    private PyType replaceSelf(@Nullable PyType returnType, @Nullable PyExpression receiver, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(15);
        }
        return this.replaceSelf(returnType, receiver, context, true);
    }

    @Nullable
    private PyType replaceSelf(@Nullable PyType returnType, @Nullable PyExpression receiver, @NotNull TypeEvalContext context, boolean allowCoroutineOrGenerator) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(16);
        }
        if (receiver != null) {
            if (returnType instanceof PyClassType) {
                PyClassType returnClassType = (PyClassType)returnType;
                if (returnClassType.getPyClass() == this.getContainingClass()) {
                    PyClassType receiverClassType;
                    PyType receiverType = context.getType(receiver);
                    if (receiverType instanceof PyClassType && (receiverClassType = (PyClassType)receiverType).getPyClass() != returnClassType.getPyClass() && PyTypeChecker.match((PyType)returnClassType.toClass(), (PyType)receiverClassType.toClass(), context)) {
                        return returnClassType.isDefinition() ? receiverClassType.toClass() : receiverClassType.toInstance();
                    }
                } else if (allowCoroutineOrGenerator && returnType instanceof PyCollectionType && PyTypingTypeProvider.coroutineOrGeneratorElementType(returnType) != null) {
                    List replacedElementTypes = ContainerUtil.map(((PyCollectionType)returnType).getElementTypes(), type2 -> this.replaceSelf((PyType)type2, receiver, context, false));
                    return new PyCollectionTypeImpl(returnClassType.getPyClass(), returnClassType.isDefinition(), replacedElementTypes);
                }
            } else if (returnType instanceof PyUnionType) {
                return ((PyUnionType)returnType).map(type2 -> this.replaceSelf((PyType)type2, receiver, context, true));
            }
        }
        return returnType;
    }

    private static boolean isDynamicallyEvaluated(@NotNull Collection<PyCallableParameter> parameters, @NotNull TypeEvalContext context) {
        if (parameters == null) {
            PyFunctionImpl.$$$reportNull$$$0(17);
        }
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(18);
        }
        for (PyCallableParameter parameter : parameters) {
            PyType type2 = parameter.getType(context);
            if (!(type2 instanceof PyDynamicallyEvaluatedType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Pair<PyType, PyType> getYieldExpressionType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(19);
        }
        PyStatementList statements = this.getStatementList();
        YieldCollector visitor2 = new YieldCollector();
        statements.accept(visitor2);
        List yieldTypes = ContainerUtil.map(visitor2.getYieldExpressions(), it -> it.getYieldType(context));
        List sendTypes = ContainerUtil.map(visitor2.getYieldExpressions(), it -> it.getSendType(context));
        if (!yieldTypes.isEmpty()) {
            return Pair.create((Object)PyUnionType.union(yieldTypes), (Object)PyUnionType.union(sendTypes));
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getReturnStatementType(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(20);
        }
        return (PyType)PyUtil.getNullableParameterizedCachedValue(this, context, it -> this.getReturnStatementTypeNoCache((TypeEvalContext)it));
    }

    @Nullable
    private PyType getReturnStatementTypeNoCache(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(21);
        }
        List<PyStatement> returnPoints = this.getReturnPoints(context);
        ArrayList<PyType> types = new ArrayList<PyType>();
        boolean hasReturn = false;
        for (PyStatement point : returnPoints) {
            if (point instanceof PyReturnStatement) {
                PyReturnStatement returnStatement = (PyReturnStatement)point;
                hasReturn = true;
                PyExpression expr = returnStatement.getExpression();
                types.add(expr != null ? context.getType(expr) : PyBuiltinCache.getInstance(this).getNoneType());
                continue;
            }
            types.add(PyBuiltinCache.getInstance(this).getNoneType());
        }
        if ((this.isGeneratedStub() || PyKnownDecoratorUtil.hasAbstractDecorator(this, context)) && !hasReturn) {
            if (PyUtil.isInitMethod(this)) {
                return PyBuiltinCache.getInstance(this).getNoneType();
            }
            return null;
        }
        return PyUnionType.union(types);
    }

    @Override
    @NotNull
    public List<PyStatement> getReturnPoints(final @NotNull TypeEvalContext context) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(22);
        }
        final Instruction[] flow = ControlFlowCache.getControlFlow(this).getInstructions();
        final PyDataFlow dataFlow = ControlFlowCache.getDataFlow(this, context);
        class ReturnPointCollector {
            final List<PyStatement> returnPoints = new ArrayList<PyStatement>();
            boolean collectImplicitReturn = true;

            ReturnPointCollector() {
            }

            ControlFlowUtil.Operation checkInstruction(@NotNull Instruction instruction) {
                CallInstruction ci;
                if (instruction == null) {
                    ReturnPointCollector.$$$reportNull$$$0(0);
                }
                if (dataFlow.isUnreachable(instruction)) {
                    return ControlFlowUtil.Operation.CONTINUE;
                }
                if (instruction instanceof PyFinallyFailExitInstruction) {
                    PyFinallyFailExitInstruction exitInstruction = (PyFinallyFailExitInstruction)instruction;
                    boolean oldCollectImplicitReturn = this.collectImplicitReturn;
                    this.collectImplicitReturn = false;
                    this.walkCFG(ArrayUtil.indexOf((Object[])flow, (Object)exitInstruction.getBegin()));
                    this.collectImplicitReturn = oldCollectImplicitReturn;
                    return ControlFlowUtil.Operation.CONTINUE;
                }
                if (instruction instanceof CallInstruction && (ci = (CallInstruction)instruction).isNoReturnCall(context)) {
                    return ControlFlowUtil.Operation.CONTINUE;
                }
                if (instruction instanceof PyRaiseInstruction) {
                    return ControlFlowUtil.Operation.CONTINUE;
                }
                if (instruction instanceof PyWithContextExitInstruction) {
                    PyWithContextExitInstruction withExit = (PyWithContextExitInstruction)instruction;
                    if (this.collectImplicitReturn && withExit.isSuppressingExceptions(context)) {
                        this.returnPoints.add((PyStatement)PsiTreeUtil.getParentOfType((PsiElement)withExit.getElement(), PyWithStatement.class));
                    }
                    return ControlFlowUtil.Operation.CONTINUE;
                }
                PsiElement element = instruction.getElement();
                if (!(element instanceof PyStatement)) {
                    return ControlFlowUtil.Operation.NEXT;
                }
                PyStatement statement = (PyStatement)element;
                if (this.collectImplicitReturn || statement instanceof PyReturnStatement) {
                    this.returnPoints.add(statement);
                }
                return ControlFlowUtil.Operation.CONTINUE;
            }

            void walkCFG(int startInstruction) {
                ControlFlowUtil.iteratePrev((int)startInstruction, (Instruction[])flow, this::checkInstruction);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/python/psi/impl/PyFunctionImpl$1ReturnPointCollector", "checkInstruction"));
            }
        }
        ReturnPointCollector collector = new ReturnPointCollector();
        collector.walkCFG(flow.length - 1);
        List<PyStatement> list = collector.returnPoints;
        if (list == null) {
            PyFunctionImpl.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Override
    @Nullable
    public String getDeprecationMessage() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.getDeprecationMessage();
        }
        return this.extractDeprecationMessage();
    }

    @Nullable
    public String extractDeprecationMessage() {
        String deprecationMessageFromDecorator = PyDeprecationUtilKt.extractDeprecationMessageFromDecorator(this);
        if (deprecationMessageFromDecorator != null) {
            return deprecationMessageFromDecorator;
        }
        PyStatementList statementList = this.getStatementList();
        return PyFunction.extractDeprecationMessage(Arrays.asList(statementList.getStatements()));
    }

    @Override
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyFunctionImpl.$$$reportNull$$$0(24);
        }
        if (key == null) {
            PyFunctionImpl.$$$reportNull$$$0(25);
        }
        for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
            PyType type2 = provider.getCallableType(this, context);
            if (type2 == null) continue;
            return type2;
        }
        return PyFunctionTypeImpl.create(this, context);
    }

    public String getDocStringValue() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.getDocString();
        }
        return PyFunction.super.getDocStringValue();
    }

    @Override
    @Nullable
    public StructuredDocString getStructuredDocString() {
        return (StructuredDocString)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)this.myCachedStructuredDocStringProvider);
    }

    private boolean isGeneratedStub() {
        VirtualFile vFile = this.getContainingFile().getVirtualFile();
        return vFile != null && (vFile = vFile.getParent()) != null && (vFile = vFile.getParent()) != null && vFile.getName().equals("python_stubs");
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyFunction(this);
    }

    public int getTextOffset() {
        return PyFunction.super.getTextOffset();
    }

    @Override
    public String toString() {
        return super.toString() + "('" + this.getName() + "')";
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        ControlFlowCache.clear(this);
        this.myIsGenerator = null;
    }

    @Override
    @Nullable
    public Property getProperty() {
        PyClass containingClass = this.getContainingClass();
        if (containingClass != null) {
            return containingClass.findPropertyByCallable(this);
        }
        return null;
    }

    @Nullable
    public String getAnnotationValue() {
        PyAnnotationOwnerStub stub = (PyAnnotationOwnerStub)this.getStub();
        if (stub != null) {
            return stub.getAnnotation();
        }
        return PyFunction.super.getAnnotationValue();
    }

    @Override
    @Nullable
    public String getTypeCommentAnnotation() {
        return PyFunctionImpl.getTypeCommentAnnotationFromStubOrPsi(this);
    }

    @NotNull
    public SearchScope getUseScope() {
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner(this);
        if (scopeOwner instanceof PyFunction) {
            return new LocalSearchScope((PsiElement)scopeOwner);
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            PyFunctionImpl.$$$reportNull$$$0(26);
        }
        return searchScope;
    }

    @Nullable
    public PyAstFunction.Modifier getModifier() {
        PyFunctionStub stub;
        PyKnownDecorator decorator = this.getClassOrStaticMethodDecorator();
        if (decorator != null) {
            if (decorator.isClassMethod()) {
                return PyAstFunction.Modifier.CLASSMETHOD;
            }
            if (decorator.isStaticMethod()) {
                return PyAstFunction.Modifier.STATICMETHOD;
            }
        }
        String funcName = this.getName();
        PyClass cls = this.getContainingClass();
        if (cls != null) {
            if ("__new__".equals(funcName) && cls.isNewStyleClass(null)) {
                return PyAstFunction.Modifier.STATICMETHOD;
            }
            LanguageLevel level = LanguageLevel.forElement((PsiElement)this);
            if ("__init_subclass__".equals(funcName) && level.isAtLeast(LanguageLevel.PYTHON36)) {
                return PyAstFunction.Modifier.CLASSMETHOD;
            }
            if ("__class_getitem__".equals(funcName) && level.isAtLeast(LanguageLevel.PYTHON37)) {
                return PyAstFunction.Modifier.CLASSMETHOD;
            }
        }
        if ((stub = (PyFunctionStub)this.getStub()) != null) {
            return PyFunctionImpl.getModifierFromStub(stub);
        }
        if (funcName != null) {
            PyAssignmentStatement currentAssignment = (PyAssignmentStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)this, PyAssignmentStatement.class);
            while (currentAssignment != null) {
                String modifier = currentAssignment.getTargetsToValuesMapping().stream().filter(pair -> pair.getFirst() instanceof PyTargetExpression && funcName.equals(((PyExpression)pair.getFirst()).getName())).filter(pair -> pair.getSecond() instanceof PyCallExpression).map(pair -> PyCallExpressionHelper.interpretAsModifierWrappingCall((PyCallExpression)pair.getSecond())).filter(interpreted -> interpreted != null && interpreted.getSecond() == this).map(interpreted -> (String)interpreted.getFirst()).filter(wrapperName -> "classmethod".equals(wrapperName) || "staticmethod".equals(wrapperName)).findAny().orElse(null);
                if ("classmethod".equals(modifier)) {
                    return PyAstFunction.Modifier.CLASSMETHOD;
                }
                if ("staticmethod".equals(modifier)) {
                    return PyAstFunction.Modifier.STATICMETHOD;
                }
                currentAssignment = (PyAssignmentStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)currentAssignment, PyAssignmentStatement.class);
            }
        }
        return null;
    }

    @Override
    public boolean isGenerator() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.isGenerator();
        }
        Boolean result2 = this.myIsGenerator;
        if (result2 == null) {
            final Ref containsYield = Ref.create((Object)false);
            this.getStatementList().accept(new PyRecursiveElementVisitor(){

                @Override
                public void visitPyYieldExpression(@NotNull PyYieldExpression node) {
                    if (node == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    containsYield.set((Object)true);
                }

                @Override
                public void visitPyFunction(@NotNull PyFunction node) {
                    if (node == null) {
                        2.$$$reportNull$$$0(1);
                    }
                }

                @Override
                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (!((Boolean)containsYield.get()).booleanValue()) {
                        super.visitElement(element);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/python/psi/impl/PyFunctionImpl$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyYieldExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyFunction";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitElement";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.myIsGenerator = result2 = (Boolean)containsYield.get();
        }
        return result2;
    }

    public boolean isAsync() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.isAsync();
        }
        return PyFunction.super.isAsync();
    }

    public boolean onlyRaisesNotImplementedError() {
        PyFunctionStub stub = (PyFunctionStub)this.getStub();
        if (stub != null) {
            return stub.onlyRaisesNotImplementedError();
        }
        return PyFunction.super.onlyRaisesNotImplementedError();
    }

    @Nullable
    private static PyAstFunction.Modifier getModifierFromStub(@NotNull PyFunctionStub stub) {
        if (stub == null) {
            PyFunctionImpl.$$$reportNull$$$0(27);
        }
        return (PyAstFunction.Modifier)JBIterable.of((Object)stub.getParentStub()).flatMap(element -> element.getChildrenStubs()).skipWhile(siblingStub -> !stub.equals(siblingStub)).transform(nextSiblingStub -> PyUtil.as(nextSiblingStub, PyTargetExpressionStub.class)).filter(Objects::nonNull).filter(nextSiblingStub -> nextSiblingStub.getInitializerType() == PyTargetExpressionStub.InitializerType.CallExpression && Objects.equals(stub.getName(), nextSiblingStub.getName())).transform(PyTargetExpressionStub::getInitializer).transform(initializerName -> {
            if (initializerName == null) {
                return null;
            }
            if (initializerName.matches(new String[]{"classmethod"})) {
                return PyAstFunction.Modifier.CLASSMETHOD;
            }
            if (initializerName.matches(new String[]{"staticmethod"})) {
                return PyAstFunction.Modifier.STATICMETHOD;
            }
            return null;
        }).find(Objects::nonNull);
    }

    @Nullable
    private PyKnownDecorator getClassOrStaticMethodDecorator() {
        PyDecorator[] decos;
        PyDecoratorList decolist = this.getDecoratorList();
        if (decolist != null && (decos = decolist.getDecorators()).length > 0) {
            for (int i = decos.length - 1; i >= 0; --i) {
                PyDecorator deco = decos[i];
                List<PyKnownDecorator> knownDecorators = PyKnownDecoratorUtil.asKnownDecorators(deco, TypeEvalContext.codeInsightFallback(this.getProject()));
                for (PyKnownDecorator decorator : knownDecorators) {
                    if (!decorator.isClassMethod() && !decorator.isStaticMethod()) continue;
                    return decorator;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return QualifiedNameFinder.getQualifiedName(this);
    }

    @Override
    @NotNull
    public List<PyAssignmentStatement> findAttributes() {
        List list = (List)CachedValuesManager.getManager((Project)this.getProject()).getCachedValue((UserDataHolder)this, ATTRIBUTES_KEY, () -> {
            List<PyAssignmentStatement> result2 = PyFunctionImpl.findAttributesStatic(this);
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
        if (list == null) {
            PyFunctionImpl.$$$reportNull$$$0(28);
        }
        return list;
    }

    @Override
    @NotNull
    public PyParameterList getParameterList() {
        PyParameterList pyParameterList = (PyParameterList)this.getRequiredStubOrPsiChild(PyStubElementTypes.PARAMETER_LIST);
        if (pyParameterList == null) {
            PyFunctionImpl.$$$reportNull$$$0(29);
        }
        return pyParameterList;
    }

    @Override
    @Nullable
    public PyTypeParameterList getTypeParameterList() {
        return (PyTypeParameterList)this.getStubOrPsiChild(PyStubElementTypes.TYPE_PARAMETER_LIST);
    }

    @Override
    @Nullable
    public PyDecoratorList getDecoratorList() {
        return (PyDecoratorList)this.getStubOrPsiChild(PyStubElementTypes.DECORATOR_LIST);
    }

    @Override
    @Nullable
    public PyAnnotation getAnnotation() {
        return (PyAnnotation)this.getStubOrPsiChild(PyStubElementTypes.ANNOTATION);
    }

    public static boolean isMethod(PyFunction function) {
        boolean isMethod = ScopeUtil.getScopeOwner(function) instanceof PyClass;
        PyAstFunction.Modifier modifier = function.getModifier();
        return isMethod && modifier == null || modifier == PyAstFunction.Modifier.CLASSMETHOD;
    }

    @NotNull
    private static List<PyAssignmentStatement> findAttributesStatic(@NotNull PsiElement self) {
        if (self == null) {
            PyFunctionImpl.$$$reportNull$$$0(30);
        }
        ArrayList<PyAssignmentStatement> result2 = new ArrayList<PyAssignmentStatement>();
        for (PyAssignmentStatement statement : new PsiQuery<PsiElement>(self).siblings(PyAssignmentStatement.class).getElements()) {
            for (PyQualifiedExpression targetExpression : new PsiQuery<PyExpression[]>(statement.getTargets()).filter(new PsiQuery.PsiFilter<PyQualifiedExpression>(PyQualifiedExpression.class)).getElements()) {
                PsiReference qualifierReference;
                PyExpression qualifier = targetExpression.getQualifier();
                if (qualifier == null || (qualifierReference = qualifier.getReference()) == null || !qualifierReference.isReferenceTo(self)) continue;
                result2.add(statement);
            }
        }
        ArrayList<PyAssignmentStatement> arrayList = result2;
        if (arrayList == null) {
            PyFunctionImpl.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 23, 26, 28, 29, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyFunctionImpl";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRef";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProvider";
                break;
            }
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyFunctionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnPoints";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findAttributes";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "findAttributesStatic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 3: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 31: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInferredReturnType";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "derefType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "analyzeCallType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceSelf";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDynamicallyEvaluated";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getYieldExpressionType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getReturnStatementType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getReturnStatementTypeNoCache";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getReturnPoints";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getModifierFromStub";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findAttributesStatic";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 23, 26, 28, 29, 31 -> new IllegalStateException(string);
        };
    }

    private class CachedStructuredDocStringProvider
    implements CachedValueProvider<StructuredDocString> {
        private CachedStructuredDocStringProvider() {
        }

        @Nullable
        public CachedValueProvider.Result<StructuredDocString> compute() {
            PyFunctionImpl f = PyFunctionImpl.this;
            return CachedValueProvider.Result.create((Object)DocStringUtil.getStructuredDocString(f), (Object[])new Object[]{f});
        }
    }

    public static class YieldCollector
    extends PyRecursiveElementVisitor {
        private final List<PyYieldExpression> myYieldExpressions = new ArrayList<PyYieldExpression>();

        public List<PyYieldExpression> getYieldExpressions() {
            return this.myYieldExpressions;
        }

        @Override
        public void visitPyYieldExpression(@NotNull PyYieldExpression node) {
            if (node == null) {
                YieldCollector.$$$reportNull$$$0(0);
            }
            this.myYieldExpressions.add(node);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                YieldCollector.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void visitPyLambdaExpression(@NotNull PyLambdaExpression node) {
            if (node == null) {
                YieldCollector.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/jetbrains/python/psi/impl/PyFunctionImpl$YieldCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyYieldExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyLambdaExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

