/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.stubs;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Processor;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.stubs.PyExportedModuleAttributeIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyQualifiedNameCompletionMatcher {
    private static final Logger LOG = Logger.getInstance(PyQualifiedNameCompletionMatcher.class);

    private PyQualifiedNameCompletionMatcher() {
    }

    public static void processMatchingExportedNames(@NotNull QualifiedName qualifiedNamePattern, @NotNull PsiFile currentFile, @NotNull GlobalSearchScope scope, @NotNull Processor<? super ExportedName> processor2) {
        if (qualifiedNamePattern == null) {
            PyQualifiedNameCompletionMatcher.$$$reportNull$$$0(0);
        }
        if (currentFile == null) {
            PyQualifiedNameCompletionMatcher.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            PyQualifiedNameCompletionMatcher.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            PyQualifiedNameCompletionMatcher.$$$reportNull$$$0(3);
        }
        if (qualifiedNamePattern.getComponentCount() < 2) {
            return;
        }
        QualifiedNameMatcher matcher = new QualifiedNameMatcher(qualifiedNamePattern);
        StubIndex stubIndex = StubIndex.getInstance();
        Project project = Objects.requireNonNull(scope.getProject());
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        GlobalSearchScope moduleMatchingScope = scope.intersectWith((GlobalSearchScope)new ModuleQualifiedNameMatchingScope(matcher, project));
        HashSet alreadySuggestedAttributes = new HashSet();
        IndexLookupStats stats = new IndexLookupStats();
        try {
            ArrayList matchingAttributeNames = new ArrayList();
            stubIndex.processAllKeys(PyExportedModuleAttributeIndex.KEY, attributeName -> {
                ProgressManager.checkCanceled();
                ++stats.scannedKeys;
                if (!matcher.attributeMatches((String)attributeName)) {
                    return true;
                }
                ++stats.matchingKeys;
                matchingAttributeNames.add(attributeName);
                return true;
            }, moduleMatchingScope);
            for (String attributeName2 : matchingAttributeNames) {
                stubIndex.processElements(PyExportedModuleAttributeIndex.KEY, (Object)attributeName2, project, moduleMatchingScope, null, PyElement.class, element -> {
                    ProgressManager.checkCanceled();
                    VirtualFile vFile = element.getContainingFile().getVirtualFile();
                    QualifiedName moduleQualifiedName = PyQualifiedNameCompletionMatcher.findQualifiedNameInClosestRoot(vFile, project);
                    assert (moduleQualifiedName != null) : vFile;
                    QualifiedName canonicalImportPath = PyQualifiedNameCompletionMatcher.findCanonicalImportPath(element, moduleQualifiedName, currentFile);
                    QualifiedName importPath = canonicalImportPath != null && matcher.qualifierMatches(canonicalImportPath) ? canonicalImportPath : moduleQualifiedName;
                    if (ContainerUtil.exists((Iterable)importPath.getComponents(), c -> c.startsWith("_")) && !psiManager.isInProject((PsiElement)element)) {
                        return true;
                    }
                    QualifiedName attributeQualifiedName = importPath.append(attributeName2);
                    return !alreadySuggestedAttributes.add(attributeQualifiedName) || processor2.process((Object)new ExportedName(attributeQualifiedName, (PyElement)element));
                });
            }
        }
        catch (ProcessCanceledException e) {
            try {
                stats.cancelled = true;
                throw e;
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Index lookup stats for '" + String.valueOf(qualifiedNamePattern) + "':\nScanned keys: " + stats.scannedKeys + "\nMatched keys: " + stats.matchingKeys + "\n" + (stats.cancelled ? "Cancelled in " : "Completed in ") + stats.getDuration() + " ms");
                }
                throw throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Index lookup stats for '" + String.valueOf(qualifiedNamePattern) + "':\nScanned keys: " + stats.scannedKeys + "\nMatched keys: " + stats.matchingKeys + "\n" + (stats.cancelled ? "Cancelled in " : "Completed in ") + stats.getDuration() + " ms");
        }
    }

    @Nullable
    private static QualifiedName findCanonicalImportPath(@NotNull PyElement element, @NotNull QualifiedName moduleQualifiedName, @NotNull PsiFile currentFile) {
        if (element == null) {
            PyQualifiedNameCompletionMatcher.$$$reportNull$$$0(4);
        }
        if (moduleQualifiedName == null) {
            PyQualifiedNameCompletionMatcher.$$$reportNull$$$0(5);
        }
        if (currentFile == null) {
            PyQualifiedNameCompletionMatcher.$$$reportNull$$$0(6);
        }
        QualifiedName canonicalImportPath = moduleQualifiedName.getComponentCount() != 1 ? QualifiedNameFinder.findCanonicalImportPath((PsiElement)element, (PsiElement)currentFile) : QualifiedNameFinder.canonizeQualifiedName((PsiElement)element, moduleQualifiedName, (PsiElement)currentFile);
        return canonicalImportPath;
    }

    @Nullable
    private static QualifiedName findQualifiedNameInClosestRoot(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            PyQualifiedNameCompletionMatcher.$$$reportNull$$$0(7);
        }
        if (project == null) {
            PyQualifiedNameCompletionMatcher.$$$reportNull$$$0(8);
        }
        final Ref result2 = Ref.create();
        new QualifiedNameFinder.QualifiedNameBasedScope(project){

            @Override
            protected boolean containsQualifiedNameInRoot(@NotNull VirtualFile root, @NotNull QualifiedName qName) {
                if (root == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (qName == null) {
                    1.$$$reportNull$$$0(1);
                }
                result2.set((Object)qName);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "root";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "qName";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/psi/stubs/PyQualifiedNameCompletionMatcher$1";
                objectArray[2] = "containsQualifiedNameInRoot";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.contains(file);
        return (QualifiedName)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNamePattern";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleQualifiedName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/stubs/PyQualifiedNameCompletionMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processMatchingExportedNames";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findCanonicalImportPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findQualifiedNameInClosestRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class QualifiedNameMatcher
    extends PrefixMatcher {
        private final PrefixMatcher myQualifierFirstComponentMatcher;
        private final PrefixMatcher myQualifierRemainderMatcher;
        private final PrefixMatcher myLastComponentMatcher;

        public QualifiedNameMatcher(@NotNull QualifiedName qualifiedName) {
            if (qualifiedName == null) {
                QualifiedNameMatcher.$$$reportNull$$$0(0);
            }
            super(qualifiedName.toString());
            if (qualifiedName.getComponentCount() < 2) {
                throw new IllegalArgumentException("Qualified name should have at least two components, but was '" + String.valueOf(qualifiedName) + "'");
            }
            this.myLastComponentMatcher = new CamelHumpMatcher(qualifiedName.getLastComponent(), false);
            QualifiedName qualifier = qualifiedName.removeLastComponent();
            this.myQualifierFirstComponentMatcher = new CamelHumpMatcher(qualifier.getFirstComponent(), false);
            this.myQualifierRemainderMatcher = new CamelHumpMatcher(qualifier.removeHead(1).toString(), false);
        }

        public boolean prefixMatches(@NotNull String name2) {
            QualifiedName qualifiedName;
            if (name2 == null) {
                QualifiedNameMatcher.$$$reportNull$$$0(1);
            }
            if ((qualifiedName = QualifiedName.fromDottedString((String)name2)).getComponentCount() == 0) {
                return false;
            }
            if (!this.attributeMatches(qualifiedName.getLastComponent())) {
                return false;
            }
            return this.qualifierMatches(qualifiedName.removeLastComponent());
        }

        private boolean attributeMatches(@Nullable String attribute) {
            return this.myLastComponentMatcher.isStartMatch(attribute);
        }

        private boolean qualifierMatches(@NotNull QualifiedName qualifier) {
            String remainder;
            String firstComponent;
            if (qualifier == null) {
                QualifiedNameMatcher.$$$reportNull$$$0(2);
            }
            if (!this.myQualifierFirstComponentMatcher.isStartMatch(firstComponent = Objects.requireNonNullElse(qualifier.getFirstComponent(), ""))) {
                return false;
            }
            String string = remainder = qualifier.getComponentCount() == 0 ? "" : qualifier.removeHead(1).toString();
            return this.myQualifierRemainderMatcher.prefixMatches(remainder);
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                QualifiedNameMatcher.$$$reportNull$$$0(3);
            }
            return new QualifiedNameMatcher(QualifiedName.fromDottedString((String)prefix));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/stubs/PyQualifiedNameCompletionMatcher$QualifiedNameMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prefixMatches";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "qualifierMatches";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cloneWithPrefix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ModuleQualifiedNameMatchingScope
    extends QualifiedNameFinder.QualifiedNameBasedScope {
        private final QualifiedNameMatcher myQualifiedNameMatcher;

        ModuleQualifiedNameMatchingScope(@NotNull QualifiedNameMatcher qualifiedNameMatcher, @NotNull Project project) {
            if (qualifiedNameMatcher == null) {
                ModuleQualifiedNameMatchingScope.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ModuleQualifiedNameMatchingScope.$$$reportNull$$$0(1);
            }
            super(project);
            this.myQualifiedNameMatcher = qualifiedNameMatcher;
        }

        @Override
        protected boolean containsQualifiedNameInRoot(@NotNull VirtualFile root, @NotNull QualifiedName qName) {
            if (root == null) {
                ModuleQualifiedNameMatchingScope.$$$reportNull$$$0(2);
            }
            if (qName == null) {
                ModuleQualifiedNameMatchingScope.$$$reportNull$$$0(3);
            }
            return ContainerUtil.all((Collection)qName.getComponents(), PyNames::isIdentifier) && this.myQualifiedNameMatcher.qualifierMatches(qName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedNameMatcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qName";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/stubs/PyQualifiedNameCompletionMatcher$ModuleQualifiedNameMatchingScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsQualifiedNameInRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class IndexLookupStats {
        long startNanoTime = System.nanoTime();
        int scannedKeys;
        int matchingKeys;
        boolean cancelled;

        private IndexLookupStats() {
        }

        long getDuration() {
            return TimeoutUtil.getDurationMillis((long)this.startNanoTime);
        }
    }

    public static final class ExportedName {
        private final QualifiedName myQualifiedName;
        private final PyElement myElement;

        private ExportedName(@NotNull QualifiedName qualifiedName, @NotNull PyElement element) {
            if (qualifiedName == null) {
                ExportedName.$$$reportNull$$$0(0);
            }
            if (element == null) {
                ExportedName.$$$reportNull$$$0(1);
            }
            this.myQualifiedName = qualifiedName;
            this.myElement = element;
        }

        @NotNull
        public QualifiedName getQualifiedName() {
            QualifiedName qualifiedName = this.myQualifiedName;
            if (qualifiedName == null) {
                ExportedName.$$$reportNull$$$0(2);
            }
            return qualifiedName;
        }

        @NotNull
        public PyElement getElement() {
            PyElement pyElement = this.myElement;
            if (pyElement == null) {
                ExportedName.$$$reportNull$$$0(3);
            }
            return pyElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/stubs/PyQualifiedNameCompletionMatcher$ExportedName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/stubs/PyQualifiedNameCompletionMatcher$ExportedName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQualifiedName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

