/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0012\u0012\u0004\u0012\u0002H\u00010\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0003B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015J\u001b\u0010\u0016\u001a\u0004\u0018\u00018\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/textmate/language/TextMateScopeComparatorCore;", "T", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "weigher", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;", "scope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "scopeProvider", "Lkotlin/Function1;", "", "<init>", "(Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;Lkotlin/jvm/functions/Function1;)V", "compare", "", "o1", "o2", "(Ljava/lang/Object;Ljava/lang/Object;)I", "sortAndFilter", "", "objects", "", "max", "(Ljava/util/Collection;)Ljava/lang/Object;", "intellij.textmate.core"})
public final class TextMateScopeComparatorCore<T>
implements Comparator<T> {
    @NotNull
    private final TextMateSelectorWeigher weigher;
    @NotNull
    private final TextMateScope scope;
    @NotNull
    private final Function1<T, CharSequence> scopeProvider;

    public TextMateScopeComparatorCore(@NotNull TextMateSelectorWeigher weigher, @NotNull TextMateScope scope, @NotNull Function1<? super T, ? extends CharSequence> scopeProvider) {
        Intrinsics.checkNotNullParameter((Object)weigher, (String)"weigher");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(scopeProvider, (String)"scopeProvider");
        this.weigher = weigher;
        this.scope = scope;
        this.scopeProvider = scopeProvider;
    }

    @Override
    public int compare(T o1, T o2) {
        return this.weigher.weigh((CharSequence)this.scopeProvider.invoke(o1), this.scope).compareTo(this.weigher.weigh((CharSequence)this.scopeProvider.invoke(o2), this.scope));
    }

    @NotNull
    public final List<T> sortAndFilter(@NotNull Collection<? extends T> objects) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)objects), arg_0 -> TextMateScopeComparatorCore.sortAndFilter$lambda$0(this, arg_0));
        Comparator comparator = this.reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reversed(...)");
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)sequence, comparator));
    }

    @Nullable
    public final T max(@NotNull Collection<? extends T> objects) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        TextMateWeigh max = TextMateWeigh.Companion.getZERO();
        T result = null;
        for (T o : objects) {
            TextMateWeigh weigh = this.weigher.weigh((CharSequence)this.scopeProvider.invoke(o), this.scope);
            if (weigh.getWeigh() <= 0 || weigh.compareTo(max) <= 0) continue;
            max = weigh;
            result = o;
        }
        return result;
    }

    private static final boolean sortAndFilter$lambda$0(TextMateScopeComparatorCore this$0, Object it) {
        return this$0.weigher.weigh((CharSequence)this$0.scopeProvider.invoke(it), this$0.scope).getWeigh() > 0;
    }
}

