/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.websocket;

import com.intellij.station.comms.common.api.Codec;
import com.intellij.station.comms.common.api.TypedWebsocketClient;
import com.intellij.station.comms.common.netty.util.ExtensionsKt;
import com.intellij.station.comms.common.netty.util.SimpleChannelInboundHandlerAdapter;
import com.intellij.station.comms.common.utils.Logging;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.SerializationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 **\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0006:\u0001*B+\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0001H\u0096@\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"H\u0002J\u000e\u0010$\u001a\u00020\u001aH\u0096@\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0005H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/station/comms/common/netty/websocket/WebSocketClientImpl;", "Request", "", "Response", "Lcom/intellij/station/comms/common/netty/util/SimpleChannelInboundHandlerAdapter;", "Lio/netty/handler/codec/http/websocketx/WebSocketFrame;", "Lcom/intellij/station/comms/common/api/TypedWebsocketClient;", "id", "", "nettyChannel", "Lio/netty/channel/Channel;", "codec", "Lcom/intellij/station/comms/common/api/Codec;", "<init>", "(Ljava/lang/String;Lio/netty/channel/Channel;Lcom/intellij/station/comms/common/api/Codec;)V", "connectedStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "isConnected", "Lkotlinx/coroutines/flow/StateFlow;", "()Lkotlinx/coroutines/flow/StateFlow;", "incomingMessages", "Lkotlinx/coroutines/channels/ReceiveChannel;", "getIncomingMessages", "()Lkotlinx/coroutines/channels/ReceiveChannel;", "send", "", "data", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "messagesChannel", "Lkotlinx/coroutines/channels/Channel;", "sentCloseMessage", "Ljava/util/concurrent/atomic/AtomicBoolean;", "closeFuture", "Lio/netty/channel/ChannelFuture;", "kotlin.jvm.PlatformType", "close", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "messageReceived", "context", "Lio/netty/channel/ChannelHandlerContext;", "frame", "Companion", "intellij.station.comms.common"})
@SourceDebugExtension(value={"SMAP\nWebSocketClientImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketClientImpl.kt\ncom/intellij/station/comms/common/netty/websocket/WebSocketClientImpl\n+ 2 Logging.kt\ncom/intellij/station/comms/common/utils/Logging\n*L\n1#1,98:1\n8#2:99\n*S KotlinDebug\n*F\n+ 1 WebSocketClientImpl.kt\ncom/intellij/station/comms/common/netty/websocket/WebSocketClientImpl\n*L\n32#1:99\n*E\n"})
public final class WebSocketClientImpl<Request, Response>
extends SimpleChannelInboundHandlerAdapter<WebSocketFrame>
implements TypedWebsocketClient<Request, Response> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final Channel nettyChannel;
    @NotNull
    private final Codec<Request, Response> codec;
    @NotNull
    private final MutableStateFlow<Boolean> connectedStateFlow;
    @NotNull
    private final kotlinx.coroutines.channels.Channel<Request> messagesChannel;
    @NotNull
    private final AtomicBoolean sentCloseMessage;
    @NotNull
    private static final Logger logger;

    public WebSocketClientImpl(@NotNull String id, @NotNull Channel nettyChannel, @NotNull Codec<Request, Response> codec) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)nettyChannel, (String)"nettyChannel");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        this.id = id;
        this.nettyChannel = nettyChannel;
        this.codec = codec;
        this.connectedStateFlow = StateFlowKt.MutableStateFlow((Object)true);
        this.nettyChannel.closeFuture().addListener(arg_0 -> WebSocketClientImpl._init_$lambda$0(this, arg_0));
        this.messagesChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.sentCloseMessage = new AtomicBoolean();
    }

    @Override
    @NotNull
    public StateFlow<Boolean> isConnected() {
        return (StateFlow)this.connectedStateFlow;
    }

    @Override
    @NotNull
    public ReceiveChannel<Request> getIncomingMessages() {
        return (ReceiveChannel)this.messagesChannel;
    }

    @Override
    @Nullable
    public Object send(@NotNull Response data, @NotNull Continuation<? super Unit> $completion) {
        byte[] encoded = this.codec.encodeResponse(data);
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])encoded));
        ChannelFuture channelFuture = this.nettyChannel.writeAndFlush((Object)frame);
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"writeAndFlush(...)");
        Object object = ExtensionsKt.awaitSuspend(channelFuture, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final ChannelFuture closeFuture() {
        return !this.sentCloseMessage.getAndSet(true) ? this.nettyChannel.writeAndFlush((Object)new CloseWebSocketFrame(WebSocketCloseStatus.NORMAL_CLOSURE)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE) : this.nettyChannel.close();
    }

    @Override
    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        ChannelFuture channelFuture = this.closeFuture();
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"closeFuture(...)");
        Object object = ExtensionsKt.awaitSuspend(channelFuture, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull WebSocketFrame frame) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        WebSocketFrame webSocketFrame = frame;
        if (!(webSocketFrame instanceof PongWebSocketFrame)) {
            if (webSocketFrame instanceof PingWebSocketFrame) {
                context.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content()));
            } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
                ByteBuf byteBuf = frame.content();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"content(...)");
                byte[] data = ExtensionsKt.readAllToArray(byteBuf);
                try {
                    Request parsed = this.codec.decodeRequest(data);
                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, parsed, null){
                        int label;
                        final /* synthetic */ WebSocketClientImpl<Request, Response> this$0;
                        final /* synthetic */ Request $parsed;
                        {
                            this.this$0 = $receiver;
                            this.$parsed = $parsed;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = WebSocketClientImpl.access$getMessagesChannel$p(this.this$0).send(this.$parsed, (Continuation)this);
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                }
                catch (SerializationException ex) {
                    logger.warn("Unable to deserialize data item in websocket connection " + this.id, (Throwable)ex);
                }
            } else if (webSocketFrame instanceof CloseWebSocketFrame) {
                logger.info("Websocket (" + this.id + ") closed: " + ((CloseWebSocketFrame)frame).statusCode() + " " + ((CloseWebSocketFrame)frame).reasonText());
                SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.messagesChannel), null, (int)1, null);
                this.closeFuture();
            } else if (webSocketFrame instanceof TextWebSocketFrame) {
                logger.info("Unexpected text message in station websocket (" + this.id + "): " + ((TextWebSocketFrame)frame).text());
            }
        }
    }

    private static final void _init_$lambda$0(WebSocketClientImpl this$0, Future it) {
        this$0.connectedStateFlow.setValue((Object)false);
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this$0.messagesChannel), null, (int)1, null);
    }

    public static final /* synthetic */ kotlinx.coroutines.channels.Channel access$getMessagesChannel$p(WebSocketClientImpl $this) {
        return $this.messagesChannel;
    }

    static {
        Logging this_$iv = Logging.INSTANCE;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(WebSocketClientImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        WebSocketClientImpl.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/station/comms/common/netty/websocket/WebSocketClientImpl$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "intellij.station.comms.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

