/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.EventQueue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgDeleteModifyPromptHandler;
import org.zmlx.hg4idea.execution.HgPromptChoice;
import org.zmlx.hg4idea.execution.HgPromptHandler;
import org.zmlx.hg4idea.execution.SocketServer;

public class HgPromptCommandExecutor
extends HgCommandExecutor {
    public HgPromptCommandExecutor(@NotNull Project project) {
        if (project == null) {
            HgPromptCommandExecutor.$$$reportNull$$$0(0);
        }
        super(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public HgCommandResult executeInCurrentThread(@Nullable VirtualFile repo, @NotNull String operation, @Nullable List<String> arguments) {
        if (operation == null) {
            HgPromptCommandExecutor.$$$reportNull$$$0(1);
        }
        SocketServer promptServer = new SocketServer(new PromptReceiver(new HgDeleteModifyPromptHandler()));
        try {
            int promptPort = promptServer.start();
            HgCommandResult hgCommandResult = super.executeInCurrentThread(repo, operation, this.prepareArguments(arguments, promptPort));
            return hgCommandResult;
        }
        catch (IOException e) {
            this.showError(e);
            LOG.info("IOException during preparing command", (Throwable)e);
            HgCommandResult hgCommandResult = null;
            return hgCommandResult;
        }
        finally {
            promptServer.stop();
        }
    }

    private List<String> prepareArguments(List<String> arguments, int port) {
        ArrayList<String> cmdArguments = new ArrayList<String>();
        cmdArguments.add("--config");
        cmdArguments.add("extensions.hg4ideapromptextension=" + this.myVcs.getPromptHooksExtensionFile().getAbsolutePath());
        cmdArguments.add("--config");
        cmdArguments.add("hg4ideaprompt.port=" + port);
        if (arguments != null && !arguments.isEmpty()) {
            cmdArguments.addAll(arguments);
        }
        return cmdArguments;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/execution/HgPromptCommandExecutor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInCurrentThread";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PromptReceiver
    extends SocketServer.Protocol {
        @Nullable
        HgPromptHandler myHandler;

        PromptReceiver(@Nullable HgPromptHandler handler) {
            this.myHandler = handler;
        }

        @Override
        public boolean handleConnection(Socket socket) throws IOException {
            DataInputStream dataInput = new DataInputStream(socket.getInputStream());
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            String message = new String(PromptReceiver.readDataBlock(dataInput), StandardCharsets.UTF_8);
            int numOfChoices = dataInput.readInt();
            HgPromptChoice[] choices = new HgPromptChoice[numOfChoices];
            for (int i = 0; i < numOfChoices; ++i) {
                String choice = new String(PromptReceiver.readDataBlock(dataInput), StandardCharsets.UTF_8);
                choices[i] = new HgPromptChoice(i, choice);
            }
            int defaultChoiceInt = dataInput.readInt();
            HgPromptChoice defaultChoice = choices[defaultChoiceInt];
            if (this.myHandler != null && this.myHandler.shouldHandle(message)) {
                int chosen = this.myHandler.promptUser(message, choices, defaultChoice).getChosenIndex();
                PromptReceiver.sendChoiceToHg(out, chosen);
                return true;
            }
            int[] index = new int[]{-1};
            try {
                EventQueue.invokeAndWait(() -> {
                    String[] choicePresentationArray = new String[choices.length];
                    for (int i = 0; i < choices.length; ++i) {
                        choicePresentationArray[i] = choices[i].toString();
                    }
                    index[0] = Messages.showDialog((String)message, (String)HgBundle.message("hg4idea.prompt.message", new Object[0]), (String[])choicePresentationArray, (int)defaultChoice.getChosenIndex(), (Icon)Messages.getQuestionIcon());
                });
                int chosen = index[0];
                PromptReceiver.sendChoiceToHg(out, chosen);
                return true;
            }
            catch (InterruptedException e) {
                return true;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        private static void sendChoiceToHg(@NotNull DataOutputStream outStream, int choice) throws IOException {
            if (outStream == null) {
                PromptReceiver.$$$reportNull$$$0(0);
            }
            if (choice == -1) {
                outStream.writeInt(-1);
            } else {
                outStream.writeInt(choice);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outStream", "org/zmlx/hg4idea/execution/HgPromptCommandExecutor$PromptReceiver", "sendChoiceToHg"));
        }
    }
}

