/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.command.HgShowConfigCommand;

public final class HgConfig {
    @NotNull
    private final Map<String, Map<String, String>> myConfigMap;

    public static HgConfig getInstance(Project project, VirtualFile root) {
        return new HgConfig(project, root);
    }

    private HgConfig(@NotNull Project project, @NotNull VirtualFile repo) {
        if (project == null) {
            HgConfig.$$$reportNull$$$0(0);
        }
        if (repo == null) {
            HgConfig.$$$reportNull$$$0(1);
        }
        this.myConfigMap = new HgShowConfigCommand(project).execute(repo);
    }

    @Nullable
    public String getDefaultPath() {
        return this.getNamedConfig("paths", "default");
    }

    @Nullable
    public String getDefaultPushPath() {
        String path = this.getNamedConfig("paths", "default:pushurl");
        if (path == null) {
            path = this.getNamedConfig("paths", "default-push");
        }
        if (path == null) {
            path = this.getNamedConfig("paths", "default");
        }
        return path;
    }

    @Nullable
    public String getNamedConfig(@NotNull @NonNls String sectionName, @Nullable @NonNls String configName) {
        if (sectionName == null) {
            HgConfig.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)sectionName) || StringUtil.isEmptyOrSpaces((String)configName)) {
            return null;
        }
        Map<String, String> sectionValues = this.myConfigMap.get(sectionName);
        return sectionValues != null ? sectionValues.get(configName) : null;
    }

    @NotNull
    public Collection<String> getPaths() {
        Map<String, String> pathOptions = this.myConfigMap.get("paths");
        Collection<Object> collection = pathOptions != null ? pathOptions.values() : Collections.emptyList();
        if (collection == null) {
            HgConfig.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public boolean isMqUsed() {
        String value = this.getNamedConfig("extensions", "mq");
        return value != null && !value.trim().startsWith("!");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/repo/HgConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/repo/HgConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNamedConfig";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

