/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParametersHolder;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.gpg.SExpression;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPSecretKeyDecryptorWithAAD;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Strings;

public class SExprParser {
    private final PGPDigestCalculatorProvider digestProvider;
    private static final Map<Integer, String[]> rsaLabels = new HashMap<Integer, String[]>(){
        {
            this.put(2, new String[]{"rsa", "n", "e", "protected-at"});
            this.put(1, new String[]{"rsa", "n", "e", "d", "p", "q", "u", "protected-at"});
        }
    };
    private static final Map<Integer, String[]> eccLabels = new HashMap<Integer, String[]>(){
        {
            this.put(2, new String[]{"ecc", "curve", "flags", "q", "protected-at"});
            this.put(1, new String[]{"ecc", "curve", "q", "d", "protected-at"});
        }
    };
    private static final Map<Integer, String[]> dsaLabels = new HashMap<Integer, String[]>(){
        {
            this.put(2, new String[]{"dsa", "p", "q", "g", "y", "protected-at"});
            this.put(1, new String[]{"dsa", "p", "q", "g", "y", "x", "protected-at"});
        }
    };
    private static final Map<Integer, String[]> elgLabels = new HashMap<Integer, String[]>(){
        {
            this.put(2, new String[]{"elg", "p", "q", "g", "y", "protected-at"});
            this.put(1, new String[]{"elg", "p", "q", "g", "y", "x", "protected-at"});
        }
    };
    private static final String[] rsaBigIntegers = new String[]{"n", "e"};
    private static final String[] dsaBigIntegers = new String[]{"p", "q", "g", "y"};
    private static final String[] elgBigIntegers = new String[]{"p", "g", "y"};

    public SExprParser(PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        this.digestProvider = pGPDigestCalculatorProvider;
    }

    public PGPSecretKey parseSecretKey(InputStream inputStream, PBEProtectionRemoverFactory pBEProtectionRemoverFactory, PGPPublicKey pGPPublicKey) throws IOException, PGPException {
        if (pGPPublicKey == null) {
            throw new NullPointerException("Public key cannot be null");
        }
        return this.parse(inputStream, pBEProtectionRemoverFactory, null, pGPPublicKey);
    }

    public PGPSecretKey parseSecretKey(InputStream inputStream, PBEProtectionRemoverFactory pBEProtectionRemoverFactory, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        return this.parse(inputStream, pBEProtectionRemoverFactory, keyFingerPrintCalculator, null);
    }

    private PGPSecretKey parse(InputStream inputStream, PBEProtectionRemoverFactory pBEProtectionRemoverFactory, KeyFingerPrintCalculator keyFingerPrintCalculator, PGPPublicKey pGPPublicKey) throws IOException, PGPException {
        SExpression sExpression = SExpression.parseCanonical(inputStream, 10);
        int n = SExprParser.getProtectionType(sExpression.getString(0));
        if (n == 1 || n == 2 || n == 3) {
            SExpression sExpression2 = sExpression.getExpression(1);
            String string = sExpression2.getString(0);
            PublicKeyAlgorithmTags[] publicKeyAlgorithmTagsArray = SExprParser.getPGPSecretKey(pBEProtectionRemoverFactory, keyFingerPrintCalculator, pGPPublicKey, 10, n, sExpression2, string, this.digestProvider);
            return new PGPSecretKey((SecretKeyPacket)publicKeyAlgorithmTagsArray[0], (PGPPublicKey)publicKeyAlgorithmTagsArray[1]);
        }
        throw new PGPException("unknown key type found");
    }

    public static PublicKeyAlgorithmTags[] getPGPSecretKey(PBEProtectionRemoverFactory pBEProtectionRemoverFactory, KeyFingerPrintCalculator keyFingerPrintCalculator, PGPPublicKey pGPPublicKey, int n, int n2, final SExpression sExpression, String string, PGPDigestCalculatorProvider pGPDigestCalculatorProvider) throws PGPException, IOException {
        SecretKeyPacket secretKeyPacket;
        if (string.equals("ecc")) {
            BCPGKey bCPGKey = SExprParser.getECCBasePublicKey(sExpression);
            if (pGPPublicKey != null) {
                SExprParser.assertEccPublicKeyMath(bCPGKey, pGPPublicKey);
            } else {
                PublicKeyPacket publicKeyPacket = null;
                if (bCPGKey instanceof EdDSAPublicBCPGKey) {
                    publicKeyPacket = new PublicKeyPacket(22, new Date(), bCPGKey);
                } else if (bCPGKey instanceof ECPublicBCPGKey) {
                    publicKeyPacket = new PublicKeyPacket(19, new Date(), bCPGKey);
                }
                pGPPublicKey = new PGPPublicKey(publicKeyPacket, keyFingerPrintCalculator);
            }
            secretKeyPacket = SExprParser.getSecKeyPacket(pGPPublicKey, pBEProtectionRemoverFactory, n, n2, sExpression, pGPDigestCalculatorProvider, eccLabels, new GetSecKeyDataOperation(){

                @Override
                public byte[] getSecKeyData(SExpression sExpression2) {
                    BigInteger bigInteger = BigIntegers.fromUnsignedByteArray(sExpression2.getExpressionWithLabelOrFail("d").getBytes(1));
                    String string = sExpression.getExpressionWithLabel("curve").getString(1);
                    if (string.startsWith("NIST") || string.startsWith("brain")) {
                        return new ECSecretBCPGKey(bigInteger).getEncoded();
                    }
                    return new EdSecretBCPGKey(bigInteger).getEncoded();
                }
            });
        } else if (string.equals("dsa")) {
            pGPPublicKey = SExprParser.getPublicKey(keyFingerPrintCalculator, pGPPublicKey, sExpression, 17, dsaBigIntegers, new getPublicKeyOperation(){

                @Override
                public BCPGKey getBasePublicKey(BigInteger[] bigIntegerArray) {
                    return new DSAPublicBCPGKey(bigIntegerArray[0], bigIntegerArray[1], bigIntegerArray[2], bigIntegerArray[3]);
                }

                @Override
                public void assertPublicKeyMatch(BCPGKey bCPGKey, BCPGKey bCPGKey2) throws PGPException {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)bCPGKey;
                    DSAPublicBCPGKey dSAPublicBCPGKey2 = (DSAPublicBCPGKey)bCPGKey2;
                    if (!(dSAPublicBCPGKey.getP().equals(dSAPublicBCPGKey2.getP()) && dSAPublicBCPGKey.getQ().equals(dSAPublicBCPGKey2.getQ()) && dSAPublicBCPGKey.getG().equals(dSAPublicBCPGKey2.getG()) && dSAPublicBCPGKey.getY().equals(dSAPublicBCPGKey2.getY()))) {
                        throw new PGPException("passed in public key does not match secret key");
                    }
                }
            });
            secretKeyPacket = SExprParser.getSecKeyPacket(pGPPublicKey, pBEProtectionRemoverFactory, n, n2, sExpression, pGPDigestCalculatorProvider, dsaLabels, new GetSecKeyDataOperation(){

                @Override
                public byte[] getSecKeyData(SExpression sExpression) {
                    BigInteger bigInteger = BigIntegers.fromUnsignedByteArray(sExpression.getExpressionWithLabelOrFail("x").getBytes(1));
                    return new DSASecretBCPGKey(bigInteger).getEncoded();
                }
            });
        } else if (string.equals("elg")) {
            pGPPublicKey = SExprParser.getPublicKey(keyFingerPrintCalculator, pGPPublicKey, sExpression, 16, elgBigIntegers, new getPublicKeyOperation(){

                @Override
                public BCPGKey getBasePublicKey(BigInteger[] bigIntegerArray) {
                    return new ElGamalPublicBCPGKey(bigIntegerArray[0], bigIntegerArray[1], bigIntegerArray[2]);
                }

                @Override
                public void assertPublicKeyMatch(BCPGKey bCPGKey, BCPGKey bCPGKey2) throws PGPException {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)bCPGKey;
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey2 = (ElGamalPublicBCPGKey)bCPGKey2;
                    if (!(elGamalPublicBCPGKey.getP().equals(elGamalPublicBCPGKey2.getP()) && elGamalPublicBCPGKey.getG().equals(elGamalPublicBCPGKey2.getG()) && elGamalPublicBCPGKey.getY().equals(elGamalPublicBCPGKey2.getY()))) {
                        throw new PGPException("passed in public key does not match secret key");
                    }
                }
            });
            secretKeyPacket = SExprParser.getSecKeyPacket(pGPPublicKey, pBEProtectionRemoverFactory, n, n2, sExpression, pGPDigestCalculatorProvider, elgLabels, new GetSecKeyDataOperation(){

                @Override
                public byte[] getSecKeyData(SExpression sExpression) {
                    BigInteger bigInteger = BigIntegers.fromUnsignedByteArray(sExpression.getExpressionWithLabelOrFail("x").getBytes(1));
                    return new ElGamalSecretBCPGKey(bigInteger).getEncoded();
                }
            });
        } else if (string.equals("rsa")) {
            pGPPublicKey = SExprParser.getPublicKey(keyFingerPrintCalculator, pGPPublicKey, sExpression, 1, rsaBigIntegers, new getPublicKeyOperation(){

                @Override
                public BCPGKey getBasePublicKey(BigInteger[] bigIntegerArray) {
                    return new RSAPublicBCPGKey(bigIntegerArray[0], bigIntegerArray[1]);
                }

                @Override
                public void assertPublicKeyMatch(BCPGKey bCPGKey, BCPGKey bCPGKey2) throws PGPException {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)bCPGKey;
                    RSAPublicBCPGKey rSAPublicBCPGKey2 = (RSAPublicBCPGKey)bCPGKey2;
                    if (!rSAPublicBCPGKey.getModulus().equals(rSAPublicBCPGKey2.getModulus()) || !rSAPublicBCPGKey.getPublicExponent().equals(rSAPublicBCPGKey2.getPublicExponent())) {
                        throw new PGPException("passed in public key does not match secret key");
                    }
                }
            });
            secretKeyPacket = SExprParser.getSecKeyPacket(pGPPublicKey, pBEProtectionRemoverFactory, n, n2, sExpression, pGPDigestCalculatorProvider, rsaLabels, new GetSecKeyDataOperation(){

                @Override
                public byte[] getSecKeyData(SExpression sExpression) {
                    BigInteger bigInteger = BigIntegers.fromUnsignedByteArray(sExpression.getExpressionWithLabelOrFail("d").getBytes(1));
                    BigInteger bigInteger2 = BigIntegers.fromUnsignedByteArray(sExpression.getExpressionWithLabelOrFail("p").getBytes(1));
                    BigInteger bigInteger3 = BigIntegers.fromUnsignedByteArray(sExpression.getExpressionWithLabelOrFail("q").getBytes(1));
                    return new RSASecretBCPGKey(bigInteger, bigInteger2, bigInteger3).getEncoded();
                }
            });
        } else {
            throw new PGPException("unknown key type: " + string);
        }
        return new PublicKeyAlgorithmTags[]{secretKeyPacket, pGPPublicKey};
    }

    private static PGPPublicKey getPublicKey(KeyFingerPrintCalculator keyFingerPrintCalculator, PGPPublicKey pGPPublicKey, SExpression sExpression, int n, String[] stringArray, getPublicKeyOperation getPublicKeyOperation2) throws PGPException {
        int n2 = 0;
        int n3 = (1 << stringArray.length) - 1;
        BigInteger[] bigIntegerArray = new BigInteger[stringArray.length];
        block0: for (Object object : sExpression.getValues()) {
            if (!(object instanceof SExpression)) continue;
            SExpression sExpression2 = (SExpression)object;
            String string = sExpression2.getString(0);
            for (int i = 0; i < stringArray.length; ++i) {
                if ((n2 & 1 << i) != 0 || !string.equals(stringArray[i])) continue;
                bigIntegerArray[i] = BigIntegers.fromUnsignedByteArray(sExpression2.getBytes(1));
                if ((n2 |= 1 << i) == n3) continue block0;
            }
        }
        if (n2 != n3) {
            throw new IllegalArgumentException("The public key should not be null");
        }
        BCPGKey bCPGKey = getPublicKeyOperation2.getBasePublicKey(bigIntegerArray);
        if (pGPPublicKey != null) {
            getPublicKeyOperation2.assertPublicKeyMatch(bCPGKey, pGPPublicKey.getPublicKeyPacket().getKey());
        } else {
            pGPPublicKey = new PGPPublicKey(new PublicKeyPacket(n, new Date(), bCPGKey), keyFingerPrintCalculator);
        }
        return pGPPublicKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SecretKeyPacket getSecKeyPacket(PGPPublicKey pGPPublicKey, PBEProtectionRemoverFactory pBEProtectionRemoverFactory, int n, int n2, SExpression sExpression, PGPDigestCalculatorProvider pGPDigestCalculatorProvider, Map<Integer, String[]> map, GetSecKeyDataOperation getSecKeyDataOperation) throws PGPException, IOException {
        SExpression sExpression2;
        byte[] byArray = null;
        S2K s2K = null;
        byte[] byArray2 = null;
        if (n2 == 3) return new SecretKeyPacket(pGPPublicKey.getPublicKeyPacket(), 0, s2K, byArray2, byArray);
        if (n2 == 2) {
            SExpression sExpression3 = sExpression.getExpressionWithLabel("protected");
            if (sExpression3 == null) {
                throw new IllegalArgumentException(n2 + " does not have protected block");
            }
            String string = sExpression3.getString(1);
            int n3 = SExprParser.getProtectionMode(string);
            if (n3 != 2 && n3 != 1) throw new PGPException("unsupported protection type " + sExpression3.getString(1));
            SExpression sExpression4 = sExpression3.getExpression(2);
            SExpression sExpression5 = sExpression4.getExpression(0);
            s2K = new S2K(PGPUtil.getDigestIDForName(sExpression5.getString(0)), sExpression5.getBytes(1), sExpression5.getInt(2));
            byArray2 = sExpression4.getBytes(1);
            PBESecretKeyDecryptor pBESecretKeyDecryptor = pBEProtectionRemoverFactory.createDecryptor(string);
            byte[] byArray3 = pBESecretKeyDecryptor.makeKeyFromPassPhrase(7, s2K);
            byte[] byArray4 = sExpression3.getBytes(3);
            if (n3 == 1) {
                byte[] byArray5 = pBESecretKeyDecryptor.recoverKeyData(7, byArray3, byArray2, byArray4, 0, byArray4.length);
                sExpression2 = SExpression.parseCanonical(new ByteArrayInputStream(byArray5), n);
                if (pGPDigestCalculatorProvider != null) {
                    PGPDigestCalculator pGPDigestCalculator = pGPDigestCalculatorProvider.get(2);
                    OutputStream outputStream = pGPDigestCalculator.getOutputStream();
                    byte[] byArray6 = SExpression.buildExpression(sExpression, sExpression2.getExpression(0), map.get(n3)).toCanonicalForm();
                    outputStream.write(byArray6);
                    byte[] byArray7 = pGPDigestCalculator.getDigest();
                    byte[] byArray8 = sExpression2.getExpression(1).getBytes(2);
                    if (!Arrays.constantTimeAreEqual(byArray7, byArray8)) {
                        throw new PGPException("checksum on protected data failed in SExpr");
                    }
                }
                sExpression2 = sExpression2.getExpression(0);
            } else {
                String[] stringArray = map.get(n3);
                if (stringArray == null) {
                    throw new IllegalStateException("no decryption support for protected elgamal keys");
                }
                byte[] byArray9 = SExpression.buildExpression(sExpression, stringArray).toCanonicalForm();
                byte[] byArray10 = ((PGPSecretKeyDecryptorWithAAD)pBESecretKeyDecryptor).recoverKeyData(7, byArray3, byArray2, byArray9, byArray4, 0, byArray4.length);
                sExpression2 = SExpression.parseCanonical(new ByteArrayInputStream(byArray10), n).getExpression(0);
            }
        } else {
            sExpression2 = sExpression;
        }
        byArray = getSecKeyDataOperation.getSecKeyData(sExpression2);
        return new SecretKeyPacket(pGPPublicKey.getPublicKeyPacket(), 0, s2K, byArray2, byArray);
    }

    private static BCPGKey getECCBasePublicKey(SExpression sExpression) {
        Object object;
        Object object2;
        Object object3;
        byte[] byArray = null;
        String string = null;
        int n = 0;
        Object object4 = sExpression.getValues().iterator();
        while (object4.hasNext()) {
            object3 = object4.next();
            if (!(object3 instanceof SExpression)) continue;
            object2 = (SExpression)object3;
            object = ((SExpression)object2).getString(0);
            if (((String)object).equals("curve")) {
                string = ((SExpression)object2).getString(1);
                n |= 1;
            } else if (((String)object).equals("q")) {
                byArray = ((SExpression)object2).getBytes(1);
                n |= 2;
            }
            if (n != 3) continue;
            break;
        }
        if (n != 3) {
            throw new IllegalArgumentException("no curve expression");
        }
        if (string.startsWith("NIST")) {
            string = string.substring("NIST".length()).trim();
        }
        if (((String)(object4 = Strings.toLowerCase(string))).equals("ed25519")) {
            return new EdDSAPublicBCPGKey(EdECObjectIdentifiers.id_Ed25519, new BigInteger(1, byArray));
        }
        if (((String)object4).equals("ed448")) {
            return new EdDSAPublicBCPGKey(EdECObjectIdentifiers.id_Ed448, new BigInteger(1, byArray));
        }
        object3 = ECNamedCurveTable.getOID(string);
        object2 = CustomNamedCurves.getByNameLazy(string);
        if (object2 == null && object3 != null) {
            object2 = TeleTrusTNamedCurves.getByOIDLazy((ASN1ObjectIdentifier)object3);
        }
        if (object2 == null) {
            throw new IllegalStateException("unable to resolve parameters for " + string);
        }
        object = ((X9ECParametersHolder)object2).getCurve().decodePoint(byArray);
        return new ECDSAPublicBCPGKey((ASN1ObjectIdentifier)object3, (ECPoint)object);
    }

    private static void assertEccPublicKeyMath(BCPGKey bCPGKey, PGPPublicKey pGPPublicKey) throws PGPException {
        if (bCPGKey instanceof ECDSAPublicBCPGKey) {
            ECPublicBCPGKey eCPublicBCPGKey = (ECPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
            if (!((ECDSAPublicBCPGKey)bCPGKey).getCurveOID().equals(eCPublicBCPGKey.getCurveOID()) || !((ECDSAPublicBCPGKey)bCPGKey).getEncodedPoint().equals(eCPublicBCPGKey.getEncodedPoint())) {
                throw new PGPException("passed in public key does not match secret key");
            }
        } else if (bCPGKey instanceof EdDSAPublicBCPGKey) {
            EdDSAPublicBCPGKey edDSAPublicBCPGKey = (EdDSAPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
            if (!((EdDSAPublicBCPGKey)bCPGKey).getCurveOID().equals(edDSAPublicBCPGKey.getCurveOID()) || !((EdDSAPublicBCPGKey)bCPGKey).getEncodedPoint().equals(edDSAPublicBCPGKey.getEncodedPoint())) {
                throw new PGPException("passed in public key does not match secret key");
            }
        } else {
            throw new PGPException("unknown key type: " + (bCPGKey != null ? bCPGKey.getClass().getName() : "null"));
        }
    }

    public static int getProtectionType(String string) {
        if (string.equals("private-key")) {
            return 1;
        }
        if (string.equals("protected-private-key")) {
            return 2;
        }
        if (string.equals("shadowed-private-key")) {
            return 3;
        }
        return -1;
    }

    private static int getProtectionMode(String string) {
        if (string.equals("openpgp-s2k3-sha1-aes-cbc")) {
            return 1;
        }
        if (string.equals("openpgp-s2k3-ocb-aes")) {
            return 2;
        }
        return -1;
    }

    private static interface GetSecKeyDataOperation {
        public byte[] getSecKeyData(SExpression var1);
    }

    public static interface ProtectionFormatTypeTags {
        public static final int PRIVATE_KEY = 1;
        public static final int PROTECTED_PRIVATE_KEY = 2;
        public static final int SHADOWED_PRIVATE_KEY = 3;
        public static final int OPENPGP_PRIVATE_KEY = 4;
        public static final int PROTECTED_SHARED_SECRET = 5;
    }

    private static interface ProtectionModeTags {
        public static final int OPENPGP_S2K3_SHA1_AES_CBC = 1;
        public static final int OPENPGP_S2K3_OCB_AES = 2;
        public static final int OPENPGP_NATIVE = 3;
    }

    private static interface getPublicKeyOperation {
        public BCPGKey getBasePublicKey(BigInteger[] var1);

        public void assertPublicKeyMatch(BCPGKey var1, BCPGKey var2) throws PGPException;
    }
}

