/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.blockmap;

import com.jetbrains.rd.platform.codeWithMe.blockmap.Chunk;
import com.jetbrains.rd.platform.codeWithMe.blockmap.ChunkInfo;
import com.jetbrains.rd.platform.codeWithMe.blockmap.DirBlockMap;
import com.jetbrains.rd.platform.codeWithMe.blockmap.FileInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aV\u0010\u0004\u001a>\u0012\u0004\u0012\u00020\u0002\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u00060\u0005j\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0006`\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\u0001\u001a@\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\"\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u00060\u0001\u001aB\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00022\"\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u00060\u0001*\"\u0010\u0000\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0014"}, d2={"Chunks", "", "", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/ChunkInfo;", "createLocalBlockMaps", "Ljava/util/HashMap;", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/Chunks;", "Lkotlin/collections/HashMap;", "localDirs", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/DirBlockMap;", "findRemoteChunks", "", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/Chunk;", "newBlockMap", "fileInfo", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/FileInfo;", "localBlockMaps", "findLocalChunk", "Lkotlin/Pair;", "chunkHash", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nDirMerger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirMerger.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/DirMergerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1208#2,2:161\n1236#2,4:163\n*S KotlinDebug\n*F\n+ 1 DirMerger.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/DirMergerKt\n*L\n133#1:161,2\n133#1:163,4\n*E\n"})
public final class DirMergerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HashMap<String, Map<String, ChunkInfo>> createLocalBlockMaps(@NotNull Map<String, DirBlockMap> localDirs) {
        Intrinsics.checkNotNullParameter(localDirs, (String)"localDirs");
        HashMap<String, Map<String, ChunkInfo>> localBlockMaps = new HashMap<String, Map<String, ChunkInfo>>();
        for (Map.Entry<String, DirBlockMap> entry : localDirs.entrySet()) {
            void $this$associateByTo$iv$iv;
            String path = entry.getKey();
            DirBlockMap blockMap = entry.getValue();
            Map map = localBlockMaps;
            Iterable $this$associateBy$iv = blockMap.getChunks();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                ChunkInfo chunkInfo = (ChunkInfo)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it.getChunk().getHash(), element$iv$iv);
            }
            Map map3 = destination$iv$iv;
            map.put(path, map3);
        }
        return localBlockMaps;
    }

    @NotNull
    public static final List<Chunk> findRemoteChunks(@NotNull DirBlockMap newBlockMap, @NotNull FileInfo fileInfo, @NotNull Map<String, ? extends Map<String, ChunkInfo>> localBlockMaps) {
        Intrinsics.checkNotNullParameter((Object)newBlockMap, (String)"newBlockMap");
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter(localBlockMaps, (String)"localBlockMaps");
        List remoteChunks = new ArrayList();
        int n = fileInfo.getEndChunkIdx();
        for (int chunkId = fileInfo.getStartChunkIdx(); chunkId < n; ++chunkId) {
            Chunk chunk = newBlockMap.getChunks().get(chunkId).getChunk();
            ChunkInfo localChunk = (ChunkInfo)DirMergerKt.findLocalChunk(chunk.getHash(), localBlockMaps).component2();
            if (localChunk != null) continue;
            remoteChunks.add(chunk);
        }
        return remoteChunks;
    }

    @NotNull
    public static final Pair<String, ChunkInfo> findLocalChunk(@NotNull String chunkHash, @NotNull Map<String, ? extends Map<String, ChunkInfo>> localBlockMaps) {
        Intrinsics.checkNotNullParameter((Object)chunkHash, (String)"chunkHash");
        Intrinsics.checkNotNullParameter(localBlockMaps, (String)"localBlockMaps");
        for (Map.Entry<String, ? extends Map<String, ChunkInfo>> entry : localBlockMaps.entrySet()) {
            String path = entry.getKey();
            Map<String, ChunkInfo> chunks = entry.getValue();
            ChunkInfo chunk = chunks.get(chunkHash);
            if (chunk == null) continue;
            return new Pair((Object)path, (Object)chunk);
        }
        return new Pair(null, null);
    }
}

