/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.stringsimilarity;

import info.debatty.java.stringsimilarity.ShingleBased;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringDistance;
import info.debatty.java.stringsimilarity.interfaces.NormalizedStringSimilarity;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class Cosine
extends ShingleBased
implements NormalizedStringDistance,
NormalizedStringSimilarity {
    public Cosine(int k) {
        super(k);
    }

    public Cosine() {
    }

    @Override
    public final double similarity(String s1, String s2) {
        if (s1 == null) {
            throw new NullPointerException("s1 must not be null");
        }
        if (s2 == null) {
            throw new NullPointerException("s2 must not be null");
        }
        if (s1.equals(s2)) {
            return 1.0;
        }
        if (s1.length() < this.getK() || s2.length() < this.getK()) {
            return 0.0;
        }
        Map<String, Integer> profile1 = this.getProfile(s1);
        Map<String, Integer> profile2 = this.getProfile(s2);
        return Cosine.dotProduct(profile1, profile2) / (Cosine.norm(profile1) * Cosine.norm(profile2));
    }

    private static double norm(Map<String, Integer> profile) {
        double agg = 0.0;
        for (Map.Entry<String, Integer> entry : profile.entrySet()) {
            agg += 1.0 * (double)entry.getValue().intValue() * (double)entry.getValue().intValue();
        }
        return Math.sqrt(agg);
    }

    private static double dotProduct(Map<String, Integer> profile1, Map<String, Integer> profile2) {
        Map<String, Integer> small_profile = profile2;
        Map<String, Integer> large_profile = profile1;
        if (profile1.size() < profile2.size()) {
            small_profile = profile1;
            large_profile = profile2;
        }
        double agg = 0.0;
        for (Map.Entry<String, Integer> entry : small_profile.entrySet()) {
            Integer i = large_profile.get(entry.getKey());
            if (i == null) continue;
            agg += 1.0 * (double)entry.getValue().intValue() * (double)i.intValue();
        }
        return agg;
    }

    @Override
    public final double distance(String s1, String s2) {
        return 1.0 - this.similarity(s1, s2);
    }

    public final double similarity(Map<String, Integer> profile1, Map<String, Integer> profile2) {
        return Cosine.dotProduct(profile1, profile2) / (Cosine.norm(profile1) * Cosine.norm(profile2));
    }
}

