/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.broker;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.broker.ResourceDataBroker;

public class DefaultResourceDataBroker
implements ResourceDataBroker {
    private final String resourceDir;
    private final String rulesDir;

    public DefaultResourceDataBroker() {
        this("/org/languagetool/resource", "/org/languagetool/rules");
    }

    public DefaultResourceDataBroker(String resourceDir, String rulesDir) {
        this.resourceDir = resourceDir == null ? "" : resourceDir;
        this.rulesDir = rulesDir == null ? "" : rulesDir;
    }

    @Override
    @NotNull
    public InputStream getFromResourceDirAsStream(String path) {
        String completePath = this.getCompleteResourceUrl(path);
        InputStream resourceAsStream = this.getAsStream(completePath);
        this.assertNotNull(resourceAsStream, path, completePath);
        return resourceAsStream;
    }

    @Override
    @NotNull
    public List<String> getFromResourceDirAsLines(String path) {
        ArrayList<String> lines = new ArrayList<String>();
        try (InputStream stream = this.getFromResourceDirAsStream(path);
             InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return lines;
    }

    @Override
    @Nullable
    public InputStream getAsStream(String path) {
        return ResourceDataBroker.class.getResourceAsStream(path);
    }

    @Override
    @Nullable
    public URL getAsURL(String path) {
        return ResourceDataBroker.class.getResource(path);
    }

    @Override
    @Nullable
    public List<URL> getAsURLs(String path) {
        try {
            return Collections.list(ResourceDataBroker.class.getClassLoader().getResources(path));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public URL getFromResourceDirAsUrl(String path) {
        String completePath = this.getCompleteResourceUrl(path);
        URL resource = this.getAsURL(completePath);
        this.assertNotNull(resource, path, completePath);
        return resource;
    }

    @Override
    @NotNull
    public List<URL> getFromResourceDirAsUrls(String path) {
        String completePath = this.getCompleteResourceUrl(path);
        List<URL> resources = this.getAsURLs(completePath.substring(1));
        this.assertNotNull(resources, path, completePath);
        return resources;
    }

    private String getCompleteResourceUrl(String path) {
        return this.appendPath(this.resourceDir, path);
    }

    @Override
    @NotNull
    public InputStream getFromRulesDirAsStream(String path) {
        String completePath = this.getCompleteRulesUrl(path);
        InputStream resourceAsStream = this.getAsStream(completePath);
        this.assertNotNull(resourceAsStream, path, completePath);
        return resourceAsStream;
    }

    @Override
    @NotNull
    public URL getFromRulesDirAsUrl(String path) {
        String completePath = this.getCompleteRulesUrl(path);
        URL resource = this.getAsURL(completePath);
        this.assertNotNull(resource, path, completePath);
        return resource;
    }

    private void assertNotNull(Object object, String path, String completePath) {
        if (object == null) {
            throw new RuntimeException("Path " + path + " not found in class path at " + completePath);
        }
    }

    private String getCompleteRulesUrl(String path) {
        return this.appendPath(this.rulesDir, path);
    }

    private String appendPath(String baseDir, String path) {
        StringBuilder completePath = new StringBuilder(baseDir);
        if (!this.rulesDir.endsWith("/") && !path.startsWith("/")) {
            completePath.append('/');
        }
        if (this.rulesDir.endsWith("/") && path.startsWith("/") && path.length() > 1) {
            completePath.append(path.substring(1));
        } else {
            completePath.append(path);
        }
        return completePath.toString();
    }

    @Override
    public boolean resourceExists(String path) {
        String completePath = this.getCompleteResourceUrl(path);
        return this.getAsURL(completePath) != null;
    }

    @Override
    public boolean ruleFileExists(String path) {
        String completePath = this.getCompleteRulesUrl(path);
        return this.getAsURL(completePath) != null;
    }

    @Override
    public String getResourceDir() {
        return this.resourceDir;
    }

    @Override
    public String getRulesDir() {
        return this.rulesDir;
    }

    @Override
    public ResourceBundle getResourceBundle(String baseName, Locale locale) {
        return ResourceBundle.getBundle(baseName, locale);
    }
}

