/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

class Substrings {
    final String[] substrings;
    private final int minLength;
    final boolean mustStart;
    final boolean mustEnd;

    Substrings(boolean mustStart, boolean mustEnd, String[] substrings) {
        this(mustStart, mustEnd, substrings, Arrays.stream(substrings).mapToInt(String::length).sum());
    }

    private Substrings(boolean mustStart, boolean mustEnd, String[] substrings, int minLength) {
        this.substrings = substrings;
        this.mustStart = mustStart;
        this.mustEnd = mustEnd;
        this.minLength = minLength;
    }

    @Nullable
    Substrings checkCanReplaceRegex(String regexp) {
        if (this.mustStart || this.mustEnd) {
            String suffix;
            String prefix = this.mustStart ? this.substrings[0] : "";
            String string = suffix = this.mustEnd ? this.substrings[this.substrings.length - 1] : "";
            if (regexp.startsWith(prefix) && regexp.endsWith(suffix) && regexp.length() == prefix.length() + suffix.length() + 2 && regexp.charAt(prefix.length()) == '.') {
                switch (regexp.charAt(prefix.length() + 1)) {
                    case '*': {
                        return this;
                    }
                    case '+': {
                        return new Substrings(this.mustStart, this.mustEnd, this.substrings, this.minLength + 1);
                    }
                }
            }
        }
        if (regexp.equals((this.mustStart ? "" : ".*") + String.join((CharSequence)".*", this.substrings) + (this.mustEnd ? "" : ".*"))) {
            return this;
        }
        return null;
    }

    public String toString() {
        return (this.mustStart ? "[" : "(") + String.join((CharSequence)", ", this.substrings) + (this.mustEnd ? "]" : ")");
    }

    Substrings concat(Substrings another) {
        String[] substrings;
        if (another.substrings.length == 0) {
            substrings = this.substrings;
        } else if (this.substrings.length == 0) {
            substrings = another.substrings;
        } else if (this.mustEnd && another.mustStart) {
            substrings = new String[this.substrings.length + another.substrings.length - 1];
            System.arraycopy(this.substrings, 0, substrings, 0, this.substrings.length - 1);
            substrings[this.substrings.length - 1] = this.substrings[this.substrings.length - 1] + another.substrings[0];
            System.arraycopy(another.substrings, 0, substrings, this.substrings.length, another.substrings.length - 1);
        } else {
            substrings = new String[this.substrings.length + another.substrings.length];
            System.arraycopy(this.substrings, 0, substrings, 0, this.substrings.length);
            System.arraycopy(another.substrings, 0, substrings, this.substrings.length, another.substrings.length);
        }
        return new Substrings(this.mustStart, another.mustEnd, substrings);
    }

    int find(String text, boolean caseSensitive) {
        if (text.length() < this.minLength) {
            return -1;
        }
        int start = Substrings.indexOf(text, this.substrings[0], caseSensitive, 0);
        if (start < 0) {
            return -1;
        }
        if (this.substrings.length > 1 && !this.containsSubstrings(text, caseSensitive, start + this.substrings[0].length(), 1)) {
            return -1;
        }
        return start;
    }

    boolean matches(String text, boolean caseSensitive) {
        if (text.length() < this.minLength) {
            return false;
        }
        if (this.mustStart && !text.regionMatches(!caseSensitive, 0, this.substrings[0], 0, this.substrings[0].length())) {
            return false;
        }
        if (this.mustEnd) {
            String last = this.substrings[this.substrings.length - 1];
            if (!text.regionMatches(!caseSensitive, text.length() - last.length(), last, 0, last.length())) {
                return false;
            }
        }
        if (this.substrings.length == 1 && (this.mustStart || this.mustEnd)) {
            return true;
        }
        return this.containsSubstrings(text, caseSensitive, this.mustStart ? this.substrings[0].length() : 0, this.mustStart ? 1 : 0);
    }

    private boolean containsSubstrings(String text, boolean caseSensitive, int textPos, int firstSubstringIndex) {
        for (int i = firstSubstringIndex; i < this.substrings.length; ++i) {
            if ((textPos = Substrings.indexOf(text, this.substrings[i], caseSensitive, textPos)) < 0) {
                return false;
            }
            textPos += this.substrings[i].length();
        }
        return true;
    }

    private static int indexOf(String text, String substring, boolean caseSensitive, int from) {
        return caseSensitive ? text.indexOf(substring, from) : Substrings.indexOfIgnoreCase(text, substring, from);
    }

    private static int indexOfIgnoreCase(String text, String substring, int from) {
        char first = substring.charAt(0);
        char up = Character.toUpperCase(first);
        char low = Character.toLowerCase(first);
        boolean cased = up != first || low != first;
        while (true) {
            int n = from = cased ? Substrings.findNext(text, from, up, low) : text.indexOf(first, from);
            if (from < 0) {
                return -1;
            }
            if (text.regionMatches(true, from, substring, 0, substring.length())) {
                return from;
            }
            ++from;
        }
    }

    private static int findNext(String text, int from, char up, char low) {
        for (int i = from; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != up && c != low && Character.toUpperCase(c) != up && Character.toLowerCase(c) != low) continue;
            return i;
        }
        return -1;
    }
}

