/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.languagetool.tools.LoggingTools;
import org.languagetool.tools.LtThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LtThreadPoolFactory {
    private static final Logger log = LoggerFactory.getLogger(LtThreadPoolFactory.class);
    public static final String SERVER_POOL = "lt-server-thread";
    public static final String TEXT_CHECKER_POOL = "lt-text-checker-thread";
    public static final String REMOTE_RULE_EXECUTING_POOL = "remote-rule-executing-thread";
    public static final int REMOTE_RULE_POOL_SIZE_FACTOR = 4;
    private static final ConcurrentMap<String, ThreadPoolExecutor> executorServices = new ConcurrentHashMap<String, ThreadPoolExecutor>();
    private static final Counter rejectedTasks = (Counter)((Counter.Builder)Counter.build((String)"languagetool_threadpool_rejected_tasks", (String)"Rejected tasks by threadpool").labelNames(new String[]{"pool"})).register();
    private static final Gauge threadGauge = (Gauge)((Gauge.Builder)Gauge.build((String)"languagetool_threadpool_thread_states", (String)"Threads by states and threadpool").labelNames(new String[]{"pool", "state"})).register();
    private static final LtRejectedExecutionHandler handler;
    static final ThreadPoolExecutor defaultPool;

    private LtThreadPoolFactory() {
    }

    public static ThreadPoolExecutor createFixedThreadPoolExecutor(@NotNull String identifier, int maxThreads, int maxTaskInQueue, boolean isDaemon, @NotNull Thread.UncaughtExceptionHandler exceptionHandler, boolean reuse) {
        return LtThreadPoolFactory.createFixedThreadPoolExecutor(identifier, maxThreads / 2, maxThreads, maxTaskInQueue, 60L, isDaemon, exceptionHandler, reuse);
    }

    public static ThreadPoolExecutor createFixedThreadPoolExecutor(@NotNull String identifier, int corePool, int maxThreads, int maxTaskInQueue, long keepAliveTimeSeconds, boolean isDaemon, @NotNull Thread.UncaughtExceptionHandler exceptionHandler, boolean reuse) {
        if (reuse) {
            return executorServices.computeIfAbsent(identifier, id -> LtThreadPoolFactory.getNewThreadPoolExecutor(identifier, corePool, maxThreads, maxTaskInQueue, keepAliveTimeSeconds, isDaemon, exceptionHandler));
        }
        return LtThreadPoolFactory.getNewThreadPoolExecutor(identifier, corePool, maxThreads, maxTaskInQueue, keepAliveTimeSeconds, isDaemon, exceptionHandler);
    }

    @NotNull
    private static ThreadPoolExecutor getNewThreadPoolExecutor(@NotNull String identifier, int corePool, int maxThreads, int maxTaskInQueue, long keepAliveTimeSeconds, boolean isDaemon, @NotNull Thread.UncaughtExceptionHandler exceptionHandler) {
        log.debug(LoggingTools.SYSTEM, String.format("Create new threadPool with corePool: %d maxThreads: %d maxTaskInQueue: %d identifier: %s daemon: %s exceptionHandler: %s", corePool, maxThreads, maxTaskInQueue, identifier, isDaemon, exceptionHandler));
        AbstractQueue queue = maxTaskInQueue == 0 ? new LinkedBlockingQueue() : (maxTaskInQueue < 0 ? new SynchronousQueue() : new ArrayBlockingQueue(maxTaskInQueue, true));
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(identifier + "-%d").setDaemon(isDaemon).setUncaughtExceptionHandler(exceptionHandler).build();
        LtThreadPoolExecutor newThreadPoolExecutor = new LtThreadPoolExecutor(identifier, corePool, maxThreads, keepAliveTimeSeconds, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)queue), threadFactory, handler);
        return newThreadPoolExecutor;
    }

    public static Optional<ThreadPoolExecutor> getFixedThreadPoolExecutor(@NotNull String identifier) {
        ThreadPoolExecutor value = (ThreadPoolExecutor)executorServices.get(identifier);
        if (value == null) {
            log.debug(LoggingTools.SYSTEM, "Request: " + identifier + " not found, returning default pool");
            return Optional.of(defaultPool);
        }
        return Optional.of(value);
    }

    static {
        Timer timer = new Timer("LtThreadPoolMonitor", true);
        TimerTask timedAction = new TimerTask(){
            final String[] poolNames = new String[]{"lt-server-thread", "lt-text-checker-thread", "remote-rule-executing-thread"};

            @Override
            public void run() {
                Set<Thread> threads = Thread.getAllStackTraces().keySet();
                Arrays.stream(this.poolNames).forEach(name -> {
                    Stream<Thread> blocked = threads.stream().filter(thread -> thread.getName().startsWith((String)name) && thread.getState() == Thread.State.BLOCKED);
                    Stream<Thread> waiting = threads.stream().filter(thread -> thread.getName().startsWith((String)name) && thread.getState() == Thread.State.WAITING);
                    Stream<Thread> waiting_timed = threads.stream().filter(thread -> thread.getName().startsWith((String)name) && thread.getState() == Thread.State.TIMED_WAITING);
                    Stream<Thread> running = threads.stream().filter(thread -> thread.getName().startsWith((String)name) && thread.getState() == Thread.State.RUNNABLE);
                    ((Gauge.Child)threadGauge.labels(new String[]{name, "blocking"})).set((double)blocked.count());
                    ((Gauge.Child)threadGauge.labels(new String[]{name, "waiting"})).set((double)waiting.count());
                    ((Gauge.Child)threadGauge.labels(new String[]{name, "timed-waiting"})).set((double)waiting_timed.count());
                    ((Gauge.Child)threadGauge.labels(new String[]{name, "running"})).set((double)running.count());
                    log.trace(LoggingTools.SYSTEM, "{} blockingThreads: {}", name, (Object)((Gauge.Child)threadGauge.labels(new String[]{name, "blocking"})).get());
                    log.trace(LoggingTools.SYSTEM, "{} waitingThreads: {}", name, (Object)((Gauge.Child)threadGauge.labels(new String[]{name, "waiting"})).get());
                    log.trace(LoggingTools.SYSTEM, "{} timedWaitingThreads: {}", name, (Object)((Gauge.Child)threadGauge.labels(new String[]{name, "timed-waiting"})).get());
                    log.trace(LoggingTools.SYSTEM, "{} runningThreads: {}", name, (Object)((Gauge.Child)threadGauge.labels(new String[]{name, "running"})).get());
                });
            }
        };
        timer.scheduleAtFixedRate(timedAction, 0L, 1000L);
        handler = new LtRejectedExecutionHandler();
        defaultPool = new ThreadPoolExecutor(12, 64, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("default-lt-pool-%d").build(), new ThreadPoolExecutor.AbortPolicy());
    }

    private static class LtRejectedExecutionHandler
    extends ThreadPoolExecutor.AbortPolicy {
        private LtRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            String pool = ((LtThreadPoolExecutor)threadPoolExecutor).getName();
            ((Counter.Child)rejectedTasks.labels(new String[]{pool})).inc();
            log.warn(LoggingTools.SYSTEM, "Task rejected from pool '{}' (queue full, all threads exhausted)", (Object)pool);
            super.rejectedExecution(runnable, threadPoolExecutor);
        }
    }
}

