/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.frontend;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.platform.navbar.frontend.NavBarRootPaneExtensionKt;
import com.intellij.platform.navbar.frontend.NavBarServiceKt;
import com.intellij.platform.navbar.frontend.ui.NavBarBorder;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBThinOverlappingScrollBar;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/navbar/frontend/NavBarContainer;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/wm/impl/status/InfoAndProgressPanel$ScrollableToSelected;", "layout", "Ljava/awt/LayoutManager;", "scrollPane", "Ljavax/swing/JScrollPane;", "navigationBar", "Ljavax/swing/JComponent;", "<init>", "(Ljava/awt/LayoutManager;Ljavax/swing/JScrollPane;Ljavax/swing/JComponent;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "doLayout", "updateUI", "updateAutoscrollLimit", "limit", "Lcom/intellij/openapi/wm/impl/status/InfoAndProgressPanel$AutoscrollLimit;", "intellij.platform.navbar.frontend"})
@SourceDebugExtension(value={"SMAP\nNavBarRootPaneExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavBarRootPaneExtension.kt\ncom/intellij/platform/navbar/frontend/NavBarContainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,449:1\n1#2:450\n*E\n"})
final class NavBarContainer
extends JPanel
implements InfoAndProgressPanel.ScrollableToSelected {
    @NotNull
    private final JScrollPane scrollPane;
    @Nullable
    private final JComponent navigationBar;

    public NavBarContainer(@NotNull LayoutManager layout, @NotNull JScrollPane scrollPane, @Nullable JComponent navigationBar) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)scrollPane, (String)"scrollPane");
        super(layout);
        this.scrollPane = scrollPane;
        this.navigationBar = navigationBar;
        this.updateUI();
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        Rectangle r = this.scrollPane.getBounds();
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(r.x, r.y);
        g2d.dispose();
    }

    @Override
    public void doLayout() {
        JScrollPane jScrollPane;
        int x;
        Insets insets;
        Rectangle r;
        block5: {
            block4: {
                JScrollPane jScrollPane2;
                r = this.getBounds();
                insets = this.getInsets();
                x = insets.left;
                jScrollPane = this.scrollPane;
                if (jScrollPane == null) break block4;
                JScrollPane it = jScrollPane2 = jScrollPane;
                boolean bl = false;
                jScrollPane = it.isVisible() ? jScrollPane2 : null;
                if (jScrollPane != null) break block5;
            }
            return;
        }
        JScrollPane scrollPane = jScrollPane;
        int navBarHeight = scrollPane.getPreferredSize().height;
        if (ExperimentalUI.Companion.isNewNavbar()) {
            navBarHeight = r.height;
        }
        scrollPane.setBounds(x, (r.height - navBarHeight) / 2, r.width - insets.left - insets.right, navBarHeight);
    }

    @Override
    public void updateUI() {
        block7: {
            Border border;
            if (this.scrollPane == null) {
                return;
            }
            super.updateUI();
            UISettings settings = UISettings.Companion.getInstance();
            if (!ExperimentalUI.Companion.isNewUI() || settings.getShowNavigationBar()) {
                v0 = new NavBarBorder();
            } else {
                JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
                Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
                v0 = border = (Border)jBEmptyBorder;
            }
            if (ExperimentalUI.Companion.isNewNavbar()) {
                this.scrollPane.setHorizontalScrollBar((JScrollBar)new JBThinOverlappingScrollBar(0));
                if (this.scrollPane instanceof JBScrollPane) {
                    ((JBScrollPane)this.scrollPane).setOverlappingScrollBar(true);
                }
                this.scrollPane.setHorizontalScrollBarPolicy(30);
                NavBarRootPaneExtensionKt.access$toggleScrollBar(false, this.scrollPane);
            } else {
                this.scrollPane.setHorizontalScrollBar(null);
            }
            this.scrollPane.setVerticalScrollBarPolicy(21);
            this.scrollPane.setBorder(border);
            this.scrollPane.setOpaque(false);
            this.scrollPane.getViewport().setOpaque(false);
            this.scrollPane.setViewportBorder(null);
            if (ExperimentalUI.Companion.isNewUI()) {
                ClientProperty.put((JComponent)this.scrollPane, (Key)JBScrollPane.FORCE_HORIZONTAL_SCROLL, (Object)true);
                this.scrollPane.setVisible(NavBarServiceKt.isNavbarShown(settings));
            }
            JComponent jComponent = this.navigationBar;
            if (jComponent == null) break block7;
            jComponent.setBorder(null);
        }
    }

    public void updateAutoscrollLimit(@NotNull InfoAndProgressPanel.AutoscrollLimit limit) {
        Intrinsics.checkNotNullParameter((Object)limit, (String)"limit");
        JComponent navigationBar = this.navigationBar;
        if (navigationBar instanceof InfoAndProgressPanel.ScrollableToSelected) {
            ((InfoAndProgressPanel.ScrollableToSelected)navigationBar).updateAutoscrollLimit(limit);
        }
    }
}

