/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.editor.action;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.editor.CodeReviewCommentableEditorModel;
import com.intellij.collaboration.ui.codereview.editor.CodeReviewEditorGutterControlsModel;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/collaboration/ui/codereview/editor/action/CodeReviewEditorNewCommentAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getSelectedLinesRange", "Lcom/intellij/diff/util/LineRange;", "Lcom/intellij/openapi/editor/Caret;", "intellij.platform.collaborationTools"})
@SourceDebugExtension(value={"SMAP\nCodeReviewEditorNewCommentAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeReviewEditorNewCommentAction.kt\ncom/intellij/collaboration/ui/codereview/editor/action/CodeReviewEditorNewCommentAction\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n19#2:84\n1#3:85\n*S KotlinDebug\n*F\n+ 1 CodeReviewEditorNewCommentAction.kt\ncom/intellij/collaboration/ui/codereview/editor/action/CodeReviewEditorNewCommentAction\n*L\n22#1:84\n*E\n"})
public final class CodeReviewEditorNewCommentAction
extends DumbAwareAction {
    public CodeReviewEditorNewCommentAction() {
        super(CollaborationToolsBundle.messagePointer("review.editor.action.add.comment.text", new Object[0]), CollaborationToolsBundle.messagePointer("review.editor.action.add.comment.description", new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object $this$asSafely$iv = e.getData(CommonDataKeys.EDITOR);
        boolean $i$f$asSafely = false;
        Object object2 = $this$asSafely$iv;
        if (!(object2 instanceof EditorEx)) {
            object2 = null;
        }
        EditorEx editorEx = (EditorEx)object2;
        if (editorEx == null) {
            CodeReviewEditorNewCommentAction $this$update_u24lambda_u240 = this;
            boolean bl = false;
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        EditorEx editor = editorEx;
        CodeReviewEditorGutterControlsModel codeReviewEditorGutterControlsModel = (CodeReviewEditorGutterControlsModel)editor.getUserData(CodeReviewCommentableEditorModel.Companion.getKEY());
        if (codeReviewEditorGutterControlsModel == null) {
            CodeReviewEditorNewCommentAction $this$update_u24lambda_u241 = this;
            boolean bl = false;
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        CodeReviewEditorGutterControlsModel model = codeReviewEditorGutterControlsModel;
        e.getPresentation().setVisible(true);
        Caret caret = editor.getCaretModel().getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCurrentCaret(...)");
        Caret caret2 = caret;
        if (model instanceof CodeReviewCommentableEditorModel.WithMultilineComments) {
            Object selectedRange;
            object = this.getSelectedLinesRange(caret2);
            LineRange it = object;
            boolean bl = false;
            LineRange lineRange = it;
            Object object3 = selectedRange = (lineRange != null ? !lineRange.isEmpty() : false) ? object : null;
            if (selectedRange != null) {
                e.getPresentation().setText(CollaborationToolsBundle.message("review.editor.action.add.comment.multiline.text", new Object[0]));
                e.getPresentation().setDescription(CollaborationToolsBundle.message("review.editor.action.add.comment.multiline.description", new Object[0]));
                e.getPresentation().setEnabled(((CodeReviewCommentableEditorModel.WithMultilineComments)((Object)model)).canCreateComment((LineRange)selectedRange));
                return;
            }
        }
        object = caret2.getLogicalPosition().line;
        int it = ((Number)object).intValue();
        boolean bl = false;
        Object caretLine = it >= 0 ? object : null;
        e.getPresentation().setText(CollaborationToolsBundle.message("review.editor.action.add.comment.text", new Object[0]));
        e.getPresentation().setDescription(CollaborationToolsBundle.message("review.editor.action.add.comment.description", new Object[0]));
        e.getPresentation().setEnabled(caretLine != null && model.canCreateComment((Integer)caretLine));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getData(CommonDataKeys.EDITOR);
        EditorEx editorEx = object instanceof EditorEx ? (EditorEx)object : null;
        if (editorEx == null) {
            return;
        }
        EditorEx editor = editorEx;
        CodeReviewEditorGutterControlsModel codeReviewEditorGutterControlsModel = (CodeReviewEditorGutterControlsModel)editor.getUserData(CodeReviewCommentableEditorModel.Companion.getKEY());
        if (codeReviewEditorGutterControlsModel == null) {
            return;
        }
        CodeReviewEditorGutterControlsModel model = codeReviewEditorGutterControlsModel;
        Caret caret = editor.getCaretModel().getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCurrentCaret(...)");
        Caret caret2 = caret;
        ScrollingModelEx scrollingModelEx = editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModelEx, (String)"getScrollingModel(...)");
        ScrollingModelEx scrollingModel = scrollingModelEx;
        if (model instanceof CodeReviewCommentableEditorModel.WithMultilineComments) {
            LineRange selectedRange;
            LineRange lineRange;
            LineRange it = lineRange = this.getSelectedLinesRange(caret2);
            boolean bl = false;
            LineRange lineRange2 = it;
            Object object2 = selectedRange = (lineRange2 != null ? !lineRange2.isEmpty() : false) ? lineRange : null;
            if (selectedRange != null) {
                scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
                scrollingModel.runActionOnScrollingFinished(() -> CodeReviewEditorNewCommentAction.actionPerformed$lambda$5(model, selectedRange));
                return;
            }
        }
        Integer n = caret2.getLogicalPosition().line;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it >= 0 ? n : null;
        if (n2 == null) {
            return;
        }
        int caretLine = n2;
        scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        scrollingModel.runActionOnScrollingFinished(() -> CodeReviewEditorNewCommentAction.actionPerformed$lambda$7(model, caretLine));
    }

    private final LineRange getSelectedLinesRange(Caret $this$getSelectedLinesRange) {
        TextRange it = $this$getSelectedLinesRange.getSelectionRange();
        boolean bl = false;
        return it.getLength() == 0 ? null : new LineRange($this$getSelectedLinesRange.getEditor().offsetToLogicalPosition((int)it.getStartOffset()).line, $this$getSelectedLinesRange.getEditor().offsetToLogicalPosition((int)it.getEndOffset()).line);
    }

    private static final void actionPerformed$lambda$5(CodeReviewEditorGutterControlsModel $model, LineRange $selectedRange) {
        ((CodeReviewCommentableEditorModel.WithMultilineComments)((Object)$model)).requestNewComment($selectedRange);
    }

    private static final void actionPerformed$lambda$7(CodeReviewEditorGutterControlsModel $model, int $caretLine) {
        $model.requestNewComment($caretLine);
    }
}

