/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.indexing.shared.download.SharedIndexDownloadInfo;
import com.intellij.indexing.shared.download.SharedIndexDownloadNotificationsKt;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadNotifications;", "", "<init>", "()V", "notifySharedIndexInstalled", "", "project", "Lcom/intellij/openapi/project/Project;", "infos", "", "Lcom/intellij/indexing/shared/download/SharedIndexDownloadInfo;", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexDownloadNotifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexDownloadNotifications.kt\ncom/intellij/indexing/shared/download/SharedIndexDownloadNotifications\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,80:1\n1163#2,3:81\n*S KotlinDebug\n*F\n+ 1 SharedIndexDownloadNotifications.kt\ncom/intellij/indexing/shared/download/SharedIndexDownloadNotifications\n*L\n50#1:81,3\n*E\n"})
public final class SharedIndexDownloadNotifications {
    /*
     * WARNING - void declaration
     */
    public final void notifySharedIndexInstalled(@Nullable Project project, @NotNull List<SharedIndexDownloadInfo> infos) {
        Object object;
        block8: {
            void $this$mapTo$iv;
            block7: {
                String string;
                Intrinsics.checkNotNullParameter(infos, (String)"infos");
                if (infos.isEmpty()) {
                    return;
                }
                object = (SharedIndexDownloadInfo)CollectionsKt.singleOrNull(infos);
                if (object == null) break block7;
                SharedIndexDownloadInfo info = object;
                boolean bl = false;
                SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)CollectionsKt.singleOrNull(info.getSuggestions());
                if (sharedIndexSuggestion != null) {
                    SharedIndexSuggestion suggestion2 = sharedIndexSuggestion;
                    boolean bl2 = false;
                    Object[] objectArray = new Object[]{suggestion2.getSharedIndexDownloadedPresentableText(), StringUtil.formatFileSize((long)info.getDownloadSize()), NlsMessages.formatDurationApproximate((long)info.getDownloadTimeMillis())};
                    string = SharedIndexesBundle.message("eventLog.downloaded.textAndSize", objectArray);
                } else {
                    string = null;
                }
                object = string;
                if (string != null) break block8;
            }
            SharedIndexDownloadNotifications $this$notifySharedIndexInstalled_u24lambda_u246 = this;
            boolean bl = false;
            long totalDownloadSize = SharedIndexDownloadNotificationsKt.access$sumByLong(infos, SharedIndexDownloadNotifications::notifySharedIndexInstalled$lambda$6$lambda$2);
            long totalDownloadTime = SharedIndexDownloadNotificationsKt.access$sumByLong(infos, SharedIndexDownloadNotifications::notifySharedIndexInstalled$lambda$6$lambda$3);
            Sequence sequence = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)infos), SharedIndexDownloadNotifications::notifySharedIndexInstalled$lambda$6$lambda$4);
            Collection destination$iv = new TreeSet();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)item$iv;
                Collection collection = destination$iv;
                boolean bl3 = false;
                collection.add(it.getSharedIndexConsentNotificationKindPresentableText());
            }
            TreeSet kinds = (TreeSet)destination$iv;
            Object[] objectArray = new Object[]{StringUtil.formatFileSize((long)totalDownloadSize), NlsMessages.formatDurationApproximate((long)totalDownloadTime), NlsMessages.formatAndList((Collection)kinds)};
            String string = SharedIndexesBundle.message("eventLog.downloaded.textAndSize.merged", objectArray);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        SharedIndexDownloadInfo messageText = object;
        NotificationGroupManager.getInstance().getNotificationGroup("Shared Indexes Log").createNotification((String)((Object)messageText), NotificationType.INFORMATION).notify(project);
    }

    private static final long notifySharedIndexInstalled$lambda$6$lambda$2(SharedIndexDownloadInfo $this$sumByLong) {
        Intrinsics.checkNotNullParameter((Object)$this$sumByLong, (String)"$this$sumByLong");
        return $this$sumByLong.getDownloadSize();
    }

    private static final long notifySharedIndexInstalled$lambda$6$lambda$3(SharedIndexDownloadInfo $this$sumByLong) {
        Intrinsics.checkNotNullParameter((Object)$this$sumByLong, (String)"$this$sumByLong");
        return $this$sumByLong.getDownloadTimeMillis();
    }

    private static final Iterable notifySharedIndexInstalled$lambda$6$lambda$4(SharedIndexDownloadInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSuggestions();
    }
}

