/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.impl.AttrBasedFileContentHashForwardIndexWithSLRUCache;
import com.intellij.indexing.shared.platform.impl.CompositeInvertedIndex;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndexExtension;
import com.intellij.indexing.shared.platform.impl.HashIndexKey;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfigurationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.ValueLessInputMapExternalizer;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputIndexDataExternalizer;
import com.intellij.util.indexing.impl.ValueContainerInputRemapping;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.MapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.indexing.impl.storage.TransientFileContentIndex;
import com.intellij.util.indexing.impl.storage.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.io.DataExternalizer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class FileContentHashIndex
extends TransientFileContentIndex<Long, Void, VfsAwareMapReduceIndex.IndexerIdHolder> {
    private static final Logger LOG = Logger.getInstance(FileContentHashIndex.class);
    static final boolean USE_VFS_ATTR_BASED_FORWARD_INDEX = SystemProperties.getBooleanProperty((String)"shared.index.use.attr.based.hash.forward.index", (boolean)true);
    private boolean myBufferingEnabled;

    public FileContentHashIndex(@NotNull FileContentHashIndexExtension extension, @NotNull VfsAwareIndexStorageLayout<Long, Void> layout) throws IOException {
        if (extension == null) {
            FileContentHashIndex.$$$reportNull$$$0(0);
        }
        if (layout == null) {
            FileContentHashIndex.$$$reportNull$$$0(1);
        }
        super((FileBasedIndexExtension)extension, layout);
    }

    protected void requestRebuild(@NotNull Throwable ex) {
        if (ex == null) {
            FileContentHashIndex.$$$reportNull$$$0(2);
        }
        FileContentHashIndexExtension extension = this.getExtension();
        FileBasedIndex.getInstance().requestRebuild(extension.getName().getBaseIndexId(), ex);
    }

    @NotNull
    public FileContentHashIndexExtension getExtension() {
        FileContentHashIndexExtension fileContentHashIndexExtension = (FileContentHashIndexExtension)super.getExtension();
        if (fileContentHashIndexExtension == null) {
            FileContentHashIndex.$$$reportNull$$$0(3);
        }
        return fileContentHashIndexExtension;
    }

    public int getAssociatedChunkId(int fileId, VirtualFile file) {
        try {
            return FileContentHashIndexExtension.getChunkId(this.getHashId(fileId));
        }
        catch (StorageException e) {
            LOG.error((Throwable)e);
            FileBasedIndex.getInstance().requestReindex(file);
            return -1;
        }
    }

    public long getHashId(int fileId) throws StorageException {
        Map data = this.getIndexedFileData(fileId);
        if (data.isEmpty()) {
            return FileContentHashIndexExtension.NULL_HASH_ID;
        }
        return (Long)data.keySet().iterator().next();
    }

    @NotNull
    public ValueContainerInputRemapping getHashIdToFileIdsFunction(int chunkId) {
        ValueContainerInputRemapping valueContainerInputRemapping = hash -> {
            try {
                IntArrayList result = new IntArrayList(0);
                this.withData(FileContentHashIndexExtension.getHashId(hash, chunkId), data -> {
                    if (data.size() == 0) {
                        return true;
                    }
                    ValueContainer.ValueIterator iterator = data.getValueIterator();
                    iterator.next();
                    ValueContainer.IntIterator valueIdsIterator = iterator.getInputIdsIterator();
                    while (valueIdsIterator.hasNext()) {
                        result.add(valueIdsIterator.next());
                    }
                    return true;
                });
                return result.toIntArray();
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        };
        if (valueContainerInputRemapping == null) {
            FileContentHashIndex.$$$reportNull$$$0(4);
        }
        return valueContainerInputRemapping;
    }

    public void dispose() {
        FileContentHashIndexExtension extension = this.getExtension();
        HashIndexKey key = extension.getName();
        try {
            super.dispose();
        }
        finally {
            ID.unloadId((ID)key);
        }
    }

    private static int[] collect(@NotNull ValueContainer.IntIterator intIterator) {
        if (intIterator == null) {
            FileContentHashIndex.$$$reportNull$$$0(5);
        }
        int[] result = new int[intIterator.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = intIterator.next();
        }
        return result;
    }

    @NotNull
    public static FileContentHashIndex getFileContentHashIndex(@NotNull ID<?, ?> indexId) {
        FileBasedIndexImpl fileBasedIndex;
        UpdatableIndex index;
        if (indexId == null) {
            FileContentHashIndex.$$$reportNull$$$0(6);
        }
        if (indexId instanceof StubIndexKey) {
            indexId = StubUpdatingIndex.INDEX_ID;
        }
        if (!((index = (fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance()).getIndex(indexId)) instanceof CompositeInvertedIndex)) {
            throw new IllegalArgumentException(indexId.getName() + " is not supported by shared index. Actual index type: " + String.valueOf(index.getClass()));
        }
        FileContentHashIndex fileContentHashIndex = ((CompositeInvertedIndex)index).getHashIndex();
        if (fileContentHashIndex == null) {
            FileContentHashIndex.$$$reportNull$$$0(7);
        }
        return fileContentHashIndex;
    }

    public void setBufferingEnabled(boolean enabled) {
        if (this.myBufferingEnabled == enabled) {
            return;
        }
        this.myBufferingEnabled = enabled;
        super.setBufferingEnabled(enabled);
    }

    @NotNull
    static Path getFileContentHashIndexDir(@NotNull HashIndexKey indexId) {
        if (indexId == null) {
            FileContentHashIndex.$$$reportNull$$$0(8);
        }
        Path sharedIndexRoot = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot();
        String name = indexId.getName();
        Path path = sharedIndexRoot.resolve(name);
        if (path == null) {
            FileContentHashIndex.$$$reportNull$$$0(9);
        }
        return path;
    }

    @NotNull
    static FileContentHashIndex createFileContentHashIndex(@NotNull ID<?, ?> index) throws IOException {
        if (index == null) {
            FileContentHashIndex.$$$reportNull$$$0(10);
        }
        final FileContentHashIndexExtension extension = new FileContentHashIndexExtension(index);
        final HashIndexKey sharedIndexKey = extension.getName();
        final String name = sharedIndexKey.getName();
        final Path indexDir = FileContentHashIndex.getFileContentHashIndexDir(sharedIndexKey);
        if (!Files.exists(indexDir, new LinkOption[0]) && USE_VFS_ATTR_BASED_FORWARD_INDEX) {
            AttrBasedFileContentHashForwardIndexWithSLRUCache.bumpForwardIndexVersion(sharedIndexKey);
        }
        try {
            return new FileContentHashIndex(extension, new VfsAwareIndexStorageLayout<Long, Void>(){

                public void clearIndexData() {
                    if (USE_VFS_ATTR_BASED_FORWARD_INDEX) {
                        AttrBasedFileContentHashForwardIndexWithSLRUCache.bumpForwardIndexVersion(sharedIndexKey);
                    }
                    FileUtil.deleteWithRenaming((File)indexDir.toFile());
                }

                @NotNull
                public IndexStorage<Long, Void> openIndexStorage() throws IOException {
                    Path storagePath = indexDir.resolve(name + "_storage");
                    return new VfsAwareMapIndexStorage(storagePath, extension.getKeyDescriptor(), extension.getValueExternalizer(), extension.getCacheSize(), extension.keyIsUniqueForIndexedFile(), extension.traceKeyHashToVirtualFileMapping(), extension.enableWal());
                }

                @NotNull
                public ForwardIndex openForwardIndex() throws IOException {
                    if (USE_VFS_ATTR_BASED_FORWARD_INDEX) {
                        return new AttrBasedFileContentHashForwardIndexWithSLRUCache(sharedIndexKey);
                    }
                    Path storagePath = indexDir.resolve(name + "_inputs");
                    return new PersistentMapBasedForwardIndex(storagePath, false);
                }

                @NotNull
                public ForwardIndexAccessor<Long, Void> getForwardIndexAccessor() {
                    SingletonHashIdMapDataExternalizer mapExternalizer = USE_VFS_ATTR_BASED_FORWARD_INDEX ? new SingletonHashIdMapDataExternalizer() : new ValueLessInputMapExternalizer((DataExternalizer)new InputIndexDataExternalizer(extension.getKeyDescriptor(), (IndexId)extension.getName()));
                    return new MapForwardIndexAccessor((DataExternalizer)mapExternalizer);
                }
            });
        }
        catch (IOException e) {
            try {
                FileUtil.delete((Path)indexDir);
            }
            catch (IOException e1) {
                LOG.error((Throwable)e1);
            }
            throw e;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indexing/shared/platform/impl/FileContentHashIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intIterator";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indexing/shared/platform/impl/FileContentHashIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashIdToFileIdsFunction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileContentHashIndex";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileContentHashIndexDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileContentHashIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFileContentHashIndexDir";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFileContentHashIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 9 -> new IllegalStateException(string);
        };
    }

    private static class SingletonHashIdMapDataExternalizer
    implements DataExternalizer<Map<Long, Void>> {
        private SingletonHashIdMapDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, Map<Long, Void> value) throws IOException {
            if (out == null) {
                SingletonHashIdMapDataExternalizer.$$$reportNull$$$0(0);
            }
            FileContentHashIndexExtension.HASH_ID_DESCRIPTOR.save(out, (Object)value.keySet().iterator().next());
        }

        public Map<Long, Void> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                SingletonHashIdMapDataExternalizer.$$$reportNull$$$0(1);
            }
            return Collections.singletonMap((Long)FileContentHashIndexExtension.HASH_ID_DESCRIPTOR.read(in), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/indexing/shared/platform/impl/FileContentHashIndex$SingletonHashIdMapDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

