/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.rng;

import com.thaiopensource.relaxng.edit.AbstractRefPattern;
import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnnotationChild;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Comment;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementAnnotation;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.ExternalRefPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameClassVisitor;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OpenNameClass;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Param;
import com.thaiopensource.relaxng.edit.ParentRefPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.TextAnnotation;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.common.XmlWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class Output
implements PatternVisitor,
NameClassVisitor,
ComponentVisitor {
    private final String sourceUri;
    private final OutputDirectory od;
    private final XmlWriter xw;
    private final String datatypeLibrary;
    private final Map prefixMap;

    public static void output(Pattern pattern, String string, String string2, OutputDirectory outputDirectory, String string3, Map map) throws IOException {
        try {
            Output output = new Output(string2, string, outputDirectory, string3, map);
            pattern.accept(output);
            output.xw.close();
        }
        catch (XmlWriter.WrappedException wrappedException) {
            throw wrappedException.getIOException();
        }
    }

    private Output(String string, String string2, OutputDirectory outputDirectory, String string3, Map map) throws IOException {
        this.sourceUri = string;
        this.od = outputDirectory;
        this.datatypeLibrary = string3;
        this.prefixMap = map;
        OutputDirectory.Stream stream = outputDirectory.open(string, string2);
        this.xw = new XmlWriter(stream.getWriter(), stream.getEncoding(), stream.getCharRepertoire(), outputDirectory.getLineSeparator(), outputDirectory.getIndent(), this.getTopLevelAttributes());
    }

    private String[] getTopLevelAttributes() {
        int n = this.prefixMap.size();
        if (this.datatypeLibrary != null) {
            ++n;
        }
        String[] stringArray = new String[n * 2];
        int n2 = 0;
        Iterator iterator = this.prefixMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (string.equals("xml")) continue;
            stringArray[n2++] = string.equals("") ? "ns" : "xmlns:" + string;
            stringArray[n2++] = (String)entry.getValue();
        }
        stringArray[n2++] = "xmlns";
        stringArray[n2++] = "http://relaxng.org/ns/structure/1.0";
        if (this.datatypeLibrary != null) {
            stringArray[n2++] = "datatypeLibrary";
            stringArray[n2++] = this.datatypeLibrary;
        }
        return stringArray;
    }

    public Object visitElement(ElementPattern elementPattern) {
        this.leadingAnnotations(elementPattern);
        this.xw.startElement("element");
        boolean bl = this.tryNameAttribute(elementPattern.getNameClass(), false);
        this.innerAnnotations(elementPattern);
        if (!bl) {
            elementPattern.getNameClass().accept(this);
        }
        this.implicitGroup(elementPattern.getChild());
        this.end(elementPattern);
        return null;
    }

    public Object visitAttribute(AttributePattern attributePattern) {
        Pattern pattern;
        this.leadingAnnotations(attributePattern);
        this.xw.startElement("attribute");
        boolean bl = this.tryNameAttribute(attributePattern.getNameClass(), true);
        this.innerAnnotations(attributePattern);
        if (!bl) {
            attributePattern.getNameClass().accept(this);
        }
        if (!((pattern = attributePattern.getChild()) instanceof TextPattern) || Output.hasAnnotations(pattern)) {
            pattern.accept(this);
        }
        this.end(attributePattern);
        return null;
    }

    private boolean tryNameAttribute(NameClass nameClass, boolean bl) {
        if (Output.hasAnnotations(nameClass)) {
            return false;
        }
        if (!(nameClass instanceof NameNameClass)) {
            return false;
        }
        NameNameClass nameNameClass = (NameNameClass)nameClass;
        String string = nameNameClass.getNamespaceUri();
        if (string == NameClass.INHERIT_NS) {
            if (bl) {
                return false;
            }
            this.xw.attribute("name", nameNameClass.getLocalName());
            return true;
        }
        if (string.length() == 0) {
            if (!bl && !"".equals(this.prefixMap.get(""))) {
                return false;
            }
            this.xw.attribute("name", nameNameClass.getLocalName());
            return true;
        }
        String string2 = nameNameClass.getPrefix();
        if (string2 == null) {
            if (!string.equals(this.prefixMap.get(""))) {
                return false;
            }
            this.xw.attribute("name", nameNameClass.getLocalName());
        } else {
            if (!string.equals(this.prefixMap.get(string2))) {
                this.xw.attribute("xmlns:" + string2, string);
            }
            this.xw.attribute("name", string2 + ":" + nameNameClass.getLocalName());
        }
        return true;
    }

    public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
        return this.visitUnary("oneOrMore", oneOrMorePattern);
    }

    public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
        return this.visitUnary("zeroOrMore", zeroOrMorePattern);
    }

    public Object visitOptional(OptionalPattern optionalPattern) {
        return this.visitUnary("optional", optionalPattern);
    }

    public Object visitInterleave(InterleavePattern interleavePattern) {
        return this.visitComposite("interleave", interleavePattern);
    }

    public Object visitGroup(GroupPattern groupPattern) {
        return this.visitComposite("group", groupPattern);
    }

    public Object visitChoice(ChoicePattern choicePattern) {
        return this.visitComposite("choice", choicePattern);
    }

    public Object visitGrammar(GrammarPattern grammarPattern) {
        this.leadingAnnotations(grammarPattern);
        this.xw.startElement("grammar");
        this.finishContainer(grammarPattern, grammarPattern);
        return null;
    }

    public Object visitExternalRef(ExternalRefPattern externalRefPattern) {
        this.leadingAnnotations(externalRefPattern);
        this.xw.startElement("externalRef");
        this.xw.attribute("href", this.od.reference(this.sourceUri, externalRefPattern.getHref()));
        if (externalRefPattern.getNs() != NameClass.INHERIT_NS && !externalRefPattern.getNs().equals(this.prefixMap.get(""))) {
            this.xw.attribute("ns", externalRefPattern.getNs());
        }
        this.innerAnnotations(externalRefPattern);
        this.end(externalRefPattern);
        return null;
    }

    public Object visitRef(RefPattern refPattern) {
        return this.visitAbstractRef("ref", refPattern);
    }

    public Object visitParentRef(ParentRefPattern parentRefPattern) {
        return this.visitAbstractRef("parentRef", parentRefPattern);
    }

    private Object visitAbstractRef(String string, AbstractRefPattern abstractRefPattern) {
        this.leadingAnnotations(abstractRefPattern);
        this.xw.startElement(string);
        this.xw.attribute("name", abstractRefPattern.getName());
        this.innerAnnotations(abstractRefPattern);
        this.end(abstractRefPattern);
        return null;
    }

    public Object visitValue(ValuePattern valuePattern) {
        this.leadingAnnotations(valuePattern);
        this.xw.startElement("value");
        if (!valuePattern.getType().equals("token") || !valuePattern.getDatatypeLibrary().equals("")) {
            this.xw.attribute("type", valuePattern.getType());
            if (!valuePattern.getDatatypeLibrary().equals(this.datatypeLibrary)) {
                this.xw.attribute("datatypeLibrary", valuePattern.getDatatypeLibrary());
            }
            Iterator iterator = valuePattern.getPrefixMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (string2 == NameClass.INHERIT_NS || string2.equals(this.prefixMap.get(string))) continue;
                this.xw.attribute(string.length() == 0 ? "ns" : "xmlns:" + string, string2);
            }
        }
        this.innerAnnotations(valuePattern);
        this.xw.text(valuePattern.getValue());
        this.end(valuePattern);
        return null;
    }

    public Object visitData(DataPattern dataPattern) {
        Annotated annotated;
        this.leadingAnnotations(dataPattern);
        this.xw.startElement("data");
        this.xw.attribute("type", dataPattern.getType());
        if (!dataPattern.getDatatypeLibrary().equals(this.datatypeLibrary)) {
            this.xw.attribute("datatypeLibrary", dataPattern.getDatatypeLibrary());
        }
        this.innerAnnotations(dataPattern);
        List list = dataPattern.getParams();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            annotated = (Param)list.get(n);
            this.leadingAnnotations(annotated);
            this.xw.startElement("param");
            this.xw.attribute("name", ((Param)annotated).getName());
            this.innerAnnotations(annotated);
            this.xw.text(((Param)annotated).getValue());
            this.end(annotated);
            ++n;
        }
        annotated = dataPattern.getExcept();
        if (annotated != null) {
            this.xw.startElement("except");
            this.implicitChoice((Pattern)annotated);
            this.xw.endElement();
        }
        this.end(dataPattern);
        return null;
    }

    public Object visitMixed(MixedPattern mixedPattern) {
        return this.visitUnary("mixed", mixedPattern);
    }

    public Object visitList(ListPattern listPattern) {
        return this.visitUnary("list", listPattern);
    }

    public Object visitText(TextPattern textPattern) {
        return this.visitNullary("text", textPattern);
    }

    public Object visitEmpty(EmptyPattern emptyPattern) {
        return this.visitNullary("empty", emptyPattern);
    }

    public Object visitNotAllowed(NotAllowedPattern notAllowedPattern) {
        return this.visitNullary("notAllowed", notAllowedPattern);
    }

    private Object visitNullary(String string, Pattern pattern) {
        this.leadingAnnotations(pattern);
        this.xw.startElement(string);
        this.innerAnnotations(pattern);
        this.end(pattern);
        return null;
    }

    private Object visitUnary(String string, UnaryPattern unaryPattern) {
        this.leadingAnnotations(unaryPattern);
        this.xw.startElement(string);
        this.innerAnnotations(unaryPattern);
        this.implicitGroup(unaryPattern.getChild());
        this.end(unaryPattern);
        return null;
    }

    private Object visitComposite(String string, CompositePattern compositePattern) {
        this.leadingAnnotations(compositePattern);
        this.xw.startElement(string);
        this.innerAnnotations(compositePattern);
        List list = compositePattern.getChildren();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            ((Pattern)list.get(n)).accept(this);
            ++n;
        }
        this.end(compositePattern);
        return null;
    }

    public Object visitChoice(ChoiceNameClass choiceNameClass) {
        this.leadingAnnotations(choiceNameClass);
        this.xw.startElement("choice");
        this.innerAnnotations(choiceNameClass);
        List list = choiceNameClass.getChildren();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            ((NameClass)list.get(n)).accept(this);
            ++n;
        }
        this.end(choiceNameClass);
        return null;
    }

    public Object visitAnyName(AnyNameNameClass anyNameNameClass) {
        this.leadingAnnotations(anyNameNameClass);
        this.xw.startElement("anyName");
        this.innerAnnotations(anyNameNameClass);
        this.visitExcept(anyNameNameClass);
        this.end(anyNameNameClass);
        return null;
    }

    public Object visitNsName(NsNameNameClass nsNameNameClass) {
        this.leadingAnnotations(nsNameNameClass);
        this.xw.startElement("nsName");
        if (nsNameNameClass.getNs() != NameClass.INHERIT_NS && !nsNameNameClass.getNs().equals(this.prefixMap.get(""))) {
            this.xw.attribute("ns", nsNameNameClass.getNs());
        }
        this.innerAnnotations(nsNameNameClass);
        this.visitExcept(nsNameNameClass);
        this.end(nsNameNameClass);
        return null;
    }

    private void visitExcept(OpenNameClass openNameClass) {
        NameClass nameClass = openNameClass.getExcept();
        if (nameClass == null) {
            return;
        }
        this.xw.startElement("except");
        this.implicitChoice(nameClass);
        this.xw.endElement();
    }

    public Object visitName(NameNameClass nameNameClass) {
        this.leadingAnnotations(nameNameClass);
        this.xw.startElement("name");
        String string = nameNameClass.getNamespaceUri();
        if (string == NameClass.INHERIT_NS) {
            this.innerAnnotations(nameNameClass);
            this.xw.text(nameNameClass.getLocalName());
        } else {
            String string2 = nameNameClass.getPrefix();
            if (string2 == null || string.length() == 0) {
                if (!string.equals(this.prefixMap.get(""))) {
                    this.xw.attribute("ns", string);
                }
                this.innerAnnotations(nameNameClass);
                this.xw.text(nameNameClass.getLocalName());
            } else {
                if (!string.equals(this.prefixMap.get(string2))) {
                    this.xw.attribute("xmlns:" + string2, string);
                }
                this.innerAnnotations(nameNameClass);
                this.xw.text(string2 + ":" + nameNameClass.getLocalName());
            }
        }
        this.end(nameNameClass);
        return null;
    }

    public Object visitDefine(DefineComponent defineComponent) {
        this.leadingAnnotations(defineComponent);
        String string = defineComponent.getName();
        if (string == DefineComponent.START) {
            this.xw.startElement("start");
        } else {
            this.xw.startElement("define");
            this.xw.attribute("name", string);
        }
        if (defineComponent.getCombine() != null) {
            this.xw.attribute("combine", defineComponent.getCombine().toString());
        }
        this.innerAnnotations(defineComponent);
        this.implicitGroup(defineComponent.getBody());
        this.end(defineComponent);
        return null;
    }

    public Object visitDiv(DivComponent divComponent) {
        this.leadingAnnotations(divComponent);
        this.xw.startElement("div");
        this.finishContainer(divComponent, divComponent);
        return null;
    }

    public Object visitInclude(IncludeComponent includeComponent) {
        this.leadingAnnotations(includeComponent);
        this.xw.startElement("include");
        this.xw.attribute("href", this.od.reference(this.sourceUri, includeComponent.getHref()));
        this.finishContainer(includeComponent, includeComponent);
        return null;
    }

    private void finishContainer(Annotated annotated, Container container) {
        this.innerAnnotations(annotated);
        List list = container.getComponents();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            ((Component)list.get(n)).accept(this);
            ++n;
        }
        this.end(annotated);
    }

    private void leadingAnnotations(Annotated annotated) {
        this.annotationChildren(annotated.getLeadingComments(), true);
    }

    private void innerAnnotations(Annotated annotated) {
        this.annotationAttributes(annotated.getAttributeAnnotations());
        this.annotationChildren(annotated.getChildElementAnnotations(), true);
    }

    private void outerAnnotations(Annotated annotated) {
        this.annotationChildren(annotated.getFollowingElementAnnotations(), true);
    }

    private void annotationAttributes(List list) {
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            AttributeAnnotation attributeAnnotation = (AttributeAnnotation)list.get(n);
            String string = attributeAnnotation.getLocalName();
            String string2 = attributeAnnotation.getPrefix();
            this.xw.attribute(string2 == null ? string : string2 + ":" + string, attributeAnnotation.getValue());
            ++n;
        }
    }

    private void annotationChildren(List list, boolean bl) {
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            AnnotationChild annotationChild = (AnnotationChild)list.get(n);
            if (annotationChild instanceof ElementAnnotation) {
                ElementAnnotation elementAnnotation = (ElementAnnotation)annotationChild;
                String string = elementAnnotation.getLocalName();
                String string2 = elementAnnotation.getPrefix();
                if (string2 == null) {
                    this.xw.startElement(string);
                    if (bl) {
                        this.xw.attribute("xmlns", "");
                        bl = false;
                    }
                } else {
                    this.xw.startElement(string2 + ":" + string);
                }
                this.annotationAttributes(elementAnnotation.getAttributes());
                this.annotationChildren(elementAnnotation.getChildren(), bl);
                this.xw.endElement();
            } else if (annotationChild instanceof TextAnnotation) {
                this.xw.text(((TextAnnotation)annotationChild).getValue());
            } else if (annotationChild instanceof Comment) {
                this.xw.comment(Output.fixupComment(((Comment)annotationChild).getValue()));
            }
            ++n;
        }
    }

    private static String fixupComment(String string) {
        int n;
        int n2 = 0;
        while ((n = string.indexOf(45, n2)) >= 0) {
            if (n == string.length() - 1) {
                return string + " ";
            }
            if (string.charAt(n + 1) == '-') {
                return string.substring(0, n) + "- " + Output.fixupComment(string.substring(n + 1));
            }
            n2 = n + 1;
        }
        return string;
    }

    private void end(Annotated annotated) {
        this.xw.endElement();
        this.outerAnnotations(annotated);
    }

    private void implicitGroup(Pattern pattern) {
        if (!Output.hasAnnotations(pattern) && pattern instanceof GroupPattern) {
            List list = ((GroupPattern)pattern).getChildren();
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                ((Pattern)list.get(n)).accept(this);
                ++n;
            }
        } else {
            pattern.accept(this);
        }
    }

    private void implicitChoice(Pattern pattern) {
        if (!Output.hasAnnotations(pattern) && pattern instanceof ChoicePattern) {
            List list = ((ChoicePattern)pattern).getChildren();
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                ((Pattern)list.get(n)).accept(this);
                ++n;
            }
        } else {
            pattern.accept(this);
        }
    }

    private void implicitChoice(NameClass nameClass) {
        if (!Output.hasAnnotations(nameClass) && nameClass instanceof ChoiceNameClass) {
            List list = ((ChoiceNameClass)nameClass).getChildren();
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                ((NameClass)list.get(n)).accept(this);
                ++n;
            }
        } else {
            nameClass.accept(this);
        }
    }

    private static boolean hasAnnotations(Annotated annotated) {
        return !annotated.getLeadingComments().isEmpty() || !annotated.getAttributeAnnotations().isEmpty() || !annotated.getChildElementAnnotations().isEmpty() || !annotated.getFollowingElementAnnotations().isEmpty();
    }
}

