/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonDialectsTokenSetContributor;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

@Service
public final class PythonDialectsTokenSetProvider
implements Disposable {
    @NotNull
    private final ConcurrentHashMap<String, TokenSet> myCache = new ConcurrentHashMap(7);

    public PythonDialectsTokenSetProvider() {
        PythonDialectsTokenSetContributor.EP_NAME.addChangeListener(this.myCache::clear, (Disposable)this);
    }

    @NotNull
    public static PythonDialectsTokenSetProvider getInstance() {
        PythonDialectsTokenSetProvider pythonDialectsTokenSetProvider = (PythonDialectsTokenSetProvider)ApplicationManager.getApplication().getService(PythonDialectsTokenSetProvider.class);
        if (pythonDialectsTokenSetProvider == null) {
            PythonDialectsTokenSetProvider.$$$reportNull$$$0(0);
        }
        return pythonDialectsTokenSetProvider;
    }

    public TokenSet getStatementTokens() {
        return this.getTokenSet("statement", (Function<? super PythonDialectsTokenSetContributor, ? extends TokenSet>)((Function)PythonDialectsTokenSetContributor::getStatementTokens));
    }

    public TokenSet getExpressionTokens() {
        return this.getTokenSet("expression", (Function<? super PythonDialectsTokenSetContributor, ? extends TokenSet>)((Function)PythonDialectsTokenSetContributor::getExpressionTokens));
    }

    public TokenSet getKeywordTokens() {
        return this.getTokenSet("keyword", (Function<? super PythonDialectsTokenSetContributor, ? extends TokenSet>)((Function)PythonDialectsTokenSetContributor::getKeywordTokens));
    }

    public TokenSet getParameterTokens() {
        return this.getTokenSet("parameter", (Function<? super PythonDialectsTokenSetContributor, ? extends TokenSet>)((Function)PythonDialectsTokenSetContributor::getParameterTokens));
    }

    public TokenSet getFunctionDeclarationTokens() {
        return this.getTokenSet("functionDeclaration", (Function<? super PythonDialectsTokenSetContributor, ? extends TokenSet>)((Function)PythonDialectsTokenSetContributor::getFunctionDeclarationTokens));
    }

    public TokenSet getUnbalancedBracesRecoveryTokens() {
        return this.getTokenSet("unbalancedBracesRecovery", (Function<? super PythonDialectsTokenSetContributor, ? extends TokenSet>)((Function)PythonDialectsTokenSetContributor::getUnbalancedBracesRecoveryTokens));
    }

    public TokenSet getReferenceExpressionTokens() {
        return this.getTokenSet("referenceExpression", (Function<? super PythonDialectsTokenSetContributor, ? extends TokenSet>)((Function)PythonDialectsTokenSetContributor::getReferenceExpressionTokens));
    }

    public void dispose() {
        this.myCache.clear();
    }

    @NotNull
    private TokenSet getTokenSet(@NotNull String key, @NotNull Function<? super PythonDialectsTokenSetContributor, ? extends TokenSet> getter) {
        if (key == null) {
            PythonDialectsTokenSetProvider.$$$reportNull$$$0(1);
        }
        if (getter == null) {
            PythonDialectsTokenSetProvider.$$$reportNull$$$0(2);
        }
        TokenSet tokenSet = this.myCache.computeIfAbsent(key, __ -> PythonDialectsTokenSetProvider.orSets(getter));
        if (tokenSet == null) {
            PythonDialectsTokenSetProvider.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    private static TokenSet orSets(@NotNull Function<? super PythonDialectsTokenSetContributor, ? extends TokenSet> getter) {
        if (getter == null) {
            PythonDialectsTokenSetProvider.$$$reportNull$$$0(4);
        }
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])((TokenSet[])ContainerUtil.map2Array((Collection)PythonDialectsTokenSetContributor.EP_NAME.getExtensionList(), TokenSet.class, getter)));
        if (tokenSet == null) {
            PythonDialectsTokenSetProvider.$$$reportNull$$$0(5);
        }
        return tokenSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PythonDialectsTokenSetProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PythonDialectsTokenSetProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "orSets";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTokenSet";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "orSets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4 -> new IllegalArgumentException(string);
        };
    }
}

