/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.extend.ReplacedElement;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.pdfboxout.PdfBoxLinkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxReplacedElement;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.swing.ImageMapParser;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Map;
import org.w3c.dom.Element;

public class PdfBoxImageElement
implements PdfBoxReplacedElement,
PdfBoxLinkManager.IPdfBoxElementWithShapedLinks {
    private final FSImage _image;
    private final boolean interpolate;
    private Point _location = new Point(0, 0);
    private final Map<Shape, String> imageMap;

    public PdfBoxImageElement(Element e, FSImage image, SharedContext c, boolean interpolate) {
        this._image = image;
        this.interpolate = interpolate;
        this.imageMap = ImageMapParser.findAndParseMap(e, c);
    }

    @Override
    public int getIntrinsicWidth() {
        return this._image.getWidth();
    }

    @Override
    public int getIntrinsicHeight() {
        return this._image.getHeight();
    }

    @Override
    public Point getLocation() {
        return this._location;
    }

    @Override
    public void setLocation(int x, int y) {
        this._location = new Point(x, y);
    }

    public FSImage getImage() {
        return this._image;
    }

    @Override
    public Map<Shape, String> getLinkMap() {
        return this.imageMap;
    }

    @Override
    public void detach(LayoutContext c) {
    }

    @Override
    public boolean isRequiresInteractivePaint() {
        return false;
    }

    @Override
    public void paint(RenderingContext c, PdfBoxOutputDevice outputDevice, BlockBox box) {
        Rectangle contentBounds = box.getContentAreaEdge(box.getAbsX(), box.getAbsY(), c);
        ReplacedElement element = box.getReplacedElement();
        FSImage img = ((PdfBoxImageElement)element).getImage();
        img.scale(contentBounds.width, contentBounds.height);
        outputDevice.drawImage(img, contentBounds.x, contentBounds.y, this.interpolate);
    }

    @Override
    public int getBaseline() {
        return 0;
    }

    @Override
    public boolean hasBaseline() {
        return false;
    }
}

