/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.data;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKeyBase;
import com.vladsch.flexmark.util.data.DataValueFactory;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutableScopedDataSet
extends MutableDataSet {
    protected final DataHolder parent;

    public MutableScopedDataSet(DataHolder parent) {
        this.parent = parent;
    }

    public MutableScopedDataSet(DataHolder parent, MutableDataHolder other) {
        super(other);
        this.parent = parent;
    }

    public DataHolder getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Map<? extends DataKeyBase<?>, Object> getAll() {
        if (this.parent != null) {
            HashMap all = new HashMap(super.getAll());
            for (DataKeyBase<?> key : this.parent.getKeys()) {
                if (this.contains(key)) continue;
                all.put(key, key.get(this.parent));
            }
            return all;
        }
        return super.getAll();
    }

    @Override
    @NotNull
    public Collection<? extends DataKeyBase<?>> getKeys() {
        if (this.parent != null) {
            ArrayList all = new ArrayList(super.getKeys());
            for (DataKeyBase<?> key : this.parent.getKeys()) {
                if (this.contains(key)) continue;
                all.add(key);
            }
            return all;
        }
        return super.getKeys();
    }

    @Override
    public boolean contains(@NotNull DataKeyBase<?> key) {
        return super.contains(key) || this.parent != null && this.parent.contains(key);
    }

    @Override
    @Nullable
    public Object getOrCompute(@NotNull DataKeyBase<?> key, @NotNull DataValueFactory<?> factory) {
        if (this.parent == null || super.contains(key) || !this.parent.contains(key)) {
            return super.getOrCompute(key, factory);
        }
        return this.parent.getOrCompute(key, factory);
    }
}

