/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSetter;
import com.vladsch.flexmark.util.data.NullableDataKey;
import com.vladsch.flexmark.util.format.CharWidthProvider;
import com.vladsch.flexmark.util.format.TableManipulator;
import com.vladsch.flexmark.util.format.options.DiscretionaryText;
import com.vladsch.flexmark.util.format.options.TableCaptionHandling;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import org.jetbrains.annotations.NotNull;

public class TableFormatOptions
implements MutableDataSetter {
    public static final char INTELLIJ_DUMMY_IDENTIFIER_CHAR = '\u001f';
    public static final String INTELLIJ_DUMMY_IDENTIFIER = SequenceUtils.US_CHARS;
    public static final CharPredicate INTELLIJ_DUMMY_IDENTIFIER_SET = value -> value == 31;
    public static final DataKey<Boolean> FORMAT_TABLE_LEAD_TRAIL_PIPES = new DataKey<Boolean>("FORMAT_TABLE_LEAD_TRAIL_PIPES", true);
    public static final DataKey<Boolean> FORMAT_TABLE_SPACE_AROUND_PIPES = new DataKey<Boolean>("FORMAT_TABLE_SPACE_AROUND_PIPES", true);
    public static final DataKey<Boolean> FORMAT_TABLE_ADJUST_COLUMN_WIDTH = new DataKey<Boolean>("FORMAT_TABLE_ADJUST_COLUMN_WIDTH", true);
    public static final DataKey<Boolean> FORMAT_TABLE_APPLY_COLUMN_ALIGNMENT = new DataKey<Boolean>("FORMAT_TABLE_APPLY_COLUMN_ALIGNMENT", true);
    public static final DataKey<Boolean> FORMAT_TABLE_FILL_MISSING_COLUMNS = new DataKey<Boolean>("FORMAT_TABLE_FILL_MISSING_COLUMNS", false);
    public static final NullableDataKey<Integer> FORMAT_TABLE_FILL_MISSING_MIN_COLUMN = new NullableDataKey<Integer>("FORMAT_TABLE_FILL_MISSING_MIN_COLUMN", (Integer)null);
    public static final DataKey<DiscretionaryText> FORMAT_TABLE_LEFT_ALIGN_MARKER = new DataKey<DiscretionaryText>("FORMAT_TABLE_LEFT_ALIGN_MARKER", DiscretionaryText.AS_IS);
    public static final DataKey<Integer> FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH = new DataKey<Integer>("FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH", 3);
    public static final DataKey<Integer> FORMAT_TABLE_MIN_SEPARATOR_DASHES = new DataKey<Integer>("FORMAT_TABLE_MIN_SEPARATOR_DASHES", 1);
    public static final DataKey<Boolean> FORMAT_TABLE_TRIM_CELL_WHITESPACE = new DataKey<Boolean>("FORMAT_TABLE_TRIM_CELL_WHITESPACE", true);
    public static final DataKey<TableCaptionHandling> FORMAT_TABLE_CAPTION = new DataKey<TableCaptionHandling>("FORMAT_TABLE_CAPTION", TableCaptionHandling.AS_IS);
    public static final DataKey<DiscretionaryText> FORMAT_TABLE_CAPTION_SPACES = new DataKey<DiscretionaryText>("FORMAT_TABLE_CAPTION_SPACES", DiscretionaryText.AS_IS);
    public static final DataKey<String> FORMAT_TABLE_INDENT_PREFIX = new DataKey<String>("FORMAT_TABLE_INDENT_PREFIX", "");
    public static final DataKey<TableManipulator> FORMAT_TABLE_MANIPULATOR = new DataKey<TableManipulator>("FORMAT_TABLE_MANIPULATOR", TableManipulator.NULL);
    public static final DataKey<CharWidthProvider> FORMAT_CHAR_WIDTH_PROVIDER = new DataKey<CharWidthProvider>("FORMAT_CHAR_WIDTH_PROVIDER", CharWidthProvider.NULL);
    public static final DataKey<Boolean> FORMAT_TABLE_DUMP_TRACKING_OFFSETS = new DataKey<Boolean>("FORMAT_TABLE_DUMP_TRACKING_OFFSETS", false);
    public final boolean leadTrailPipes;
    public final boolean spaceAroundPipes;
    public final boolean adjustColumnWidth;
    public final boolean applyColumnAlignment;
    public final boolean fillMissingColumns;
    public final Integer formatTableFillMissingMinColumn;
    public final boolean trimCellWhitespace;
    public final boolean dumpIntellijOffsets;
    public final DiscretionaryText leftAlignMarker;
    public final TableCaptionHandling formatTableCaption;
    public final DiscretionaryText formatTableCaptionSpaces;
    public final int minSeparatorColumnWidth;
    public final int minSeparatorDashes;
    public final CharWidthProvider charWidthProvider;
    public final String formatTableIndentPrefix;
    public final TableManipulator tableManipulator;
    public final int spaceWidth;
    public final int spacePad;
    public final int pipeWidth;
    public final int colonWidth;
    public final int dashWidth;

    public TableFormatOptions() {
        this(null);
    }

    public TableFormatOptions(DataHolder options) {
        this.leadTrailPipes = FORMAT_TABLE_LEAD_TRAIL_PIPES.get(options);
        this.spaceAroundPipes = FORMAT_TABLE_SPACE_AROUND_PIPES.get(options);
        this.adjustColumnWidth = FORMAT_TABLE_ADJUST_COLUMN_WIDTH.get(options);
        this.applyColumnAlignment = FORMAT_TABLE_APPLY_COLUMN_ALIGNMENT.get(options);
        this.fillMissingColumns = FORMAT_TABLE_FILL_MISSING_COLUMNS.get(options);
        this.formatTableFillMissingMinColumn = FORMAT_TABLE_FILL_MISSING_MIN_COLUMN.get(options);
        this.leftAlignMarker = FORMAT_TABLE_LEFT_ALIGN_MARKER.get(options);
        this.minSeparatorColumnWidth = FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH.get(options);
        this.minSeparatorDashes = FORMAT_TABLE_MIN_SEPARATOR_DASHES.get(options);
        this.charWidthProvider = FORMAT_CHAR_WIDTH_PROVIDER.get(options);
        this.formatTableCaption = FORMAT_TABLE_CAPTION.get(options);
        this.formatTableCaptionSpaces = FORMAT_TABLE_CAPTION_SPACES.get(options);
        this.formatTableIndentPrefix = FORMAT_TABLE_INDENT_PREFIX.get(options);
        this.trimCellWhitespace = FORMAT_TABLE_TRIM_CELL_WHITESPACE.get(options);
        this.tableManipulator = FORMAT_TABLE_MANIPULATOR.get(options);
        this.dumpIntellijOffsets = FORMAT_TABLE_DUMP_TRACKING_OFFSETS.get(options);
        this.spaceWidth = this.charWidthProvider.getSpaceWidth();
        this.spacePad = this.spaceAroundPipes ? 2 * this.spaceWidth : 0;
        this.pipeWidth = this.charWidthProvider.getCharWidth('|');
        this.colonWidth = this.charWidthProvider.getCharWidth(':');
        this.dashWidth = this.charWidthProvider.getCharWidth('-');
    }

    @Override
    @NotNull
    public MutableDataHolder setIn(@NotNull MutableDataHolder dataHolder) {
        dataHolder.set(FORMAT_TABLE_LEAD_TRAIL_PIPES, Boolean.valueOf(this.leadTrailPipes));
        dataHolder.set(FORMAT_TABLE_SPACE_AROUND_PIPES, Boolean.valueOf(this.spaceAroundPipes));
        dataHolder.set(FORMAT_TABLE_ADJUST_COLUMN_WIDTH, Boolean.valueOf(this.adjustColumnWidth));
        dataHolder.set(FORMAT_TABLE_APPLY_COLUMN_ALIGNMENT, Boolean.valueOf(this.applyColumnAlignment));
        dataHolder.set(FORMAT_TABLE_FILL_MISSING_COLUMNS, Boolean.valueOf(this.fillMissingColumns));
        dataHolder.set(FORMAT_TABLE_FILL_MISSING_MIN_COLUMN, this.formatTableFillMissingMinColumn);
        dataHolder.set(FORMAT_TABLE_LEFT_ALIGN_MARKER, this.leftAlignMarker);
        dataHolder.set(FORMAT_TABLE_MIN_SEPARATOR_COLUMN_WIDTH, Integer.valueOf(this.minSeparatorColumnWidth));
        dataHolder.set(FORMAT_TABLE_MIN_SEPARATOR_DASHES, Integer.valueOf(this.minSeparatorDashes));
        dataHolder.set(FORMAT_CHAR_WIDTH_PROVIDER, this.charWidthProvider);
        dataHolder.set(FORMAT_TABLE_CAPTION, this.formatTableCaption);
        dataHolder.set(FORMAT_TABLE_CAPTION_SPACES, this.formatTableCaptionSpaces);
        dataHolder.set(FORMAT_TABLE_INDENT_PREFIX, this.formatTableIndentPrefix);
        dataHolder.set(FORMAT_TABLE_TRIM_CELL_WHITESPACE, Boolean.valueOf(this.trimCellWhitespace));
        dataHolder.set(FORMAT_TABLE_MANIPULATOR, this.tableManipulator);
        dataHolder.set(FORMAT_TABLE_DUMP_TRACKING_OFFSETS, Boolean.valueOf(this.dumpIntellijOffsets));
        return dataHolder;
    }
}

