/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence.builder.tree;

import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.builder.Seg;
import org.jetbrains.annotations.NotNull;

public abstract class Segment {
    static final int TYPE_MASK = 224;
    static final int TYPE_NO_SIZE_BYTES = 16;
    static final int TYPE_START_BYTES = 3;
    static final int TYPE_LENGTH_BYTES = 12;
    static final int TYPE_ANCHOR = 0;
    static final int TYPE_BASE = 32;
    static final int TYPE_TEXT = 64;
    static final int TYPE_REPEATED_TEXT = 96;
    static final int TYPE_TEXT_ASCII = 128;
    static final int TYPE_REPEATED_ASCII = 160;
    static final int TYPE_REPEATED_SPACE = 192;
    static final int TYPE_REPEATED_EOL = 224;
    static final int TYPE_HAS_OFFSET = 256;
    static final int TYPE_HAS_LENGTH = 512;
    static final int TYPE_HAS_BOTH = 768;
    static final int TYPE_HAS_CHAR = 1024;
    static final int TYPE_HAS_CHARS = 2048;
    static final int TYPE_HAS_BYTE = 4096;
    static final int TYPE_HAS_BYTES = 8192;
    protected final int pos;
    protected final byte[] bytes;
    protected final int byteOffset;
    protected final int startIndex;

    public boolean hasAll(int flags, int mask) {
        return (flags & mask) == mask;
    }

    public Segment(int pos, byte[] bytes, int byteOffset, int startIndex) {
        this.pos = pos;
        this.bytes = bytes;
        this.byteOffset = byteOffset;
        this.startIndex = startIndex;
    }

    public int getPos() {
        return this.pos;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public final int getByteOffset() {
        return this.byteOffset;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    public final int getEndIndex() {
        return this.startIndex + this.length();
    }

    public boolean notInSegment(int index) {
        return index < this.startIndex || index >= this.startIndex + this.length();
    }

    public boolean offsetNotInSegment(int offset) {
        return offset < this.getStartOffset() || offset >= this.getEndOffset();
    }

    public final SegType getType() {
        return SegType.fromTypeMask(this.bytes[this.byteOffset]);
    }

    public final int getByteLength() {
        return Segment.getSegByteLength(this.getType(), this.getStartOffset(), this.length());
    }

    public abstract int length();

    public abstract boolean isBase();

    public abstract boolean isAnchor();

    public abstract boolean isText();

    public abstract boolean isFirst256Start();

    public abstract boolean isRepeatedTextEnd();

    public abstract int getStartOffset();

    public abstract int getEndOffset();

    public abstract CharSequence getCharSequence();

    public abstract char charAt(int var1);

    public String toString() {
        String chars;
        if (this.isBase()) {
            if (this.isAnchor()) {
                return "[" + this.getStartOffset() + ")";
            }
            return "[" + this.getStartOffset() + ", " + this.getEndOffset() + ")";
        }
        CharSequence charSequence = this.getCharSequence();
        if (this.isRepeatedTextEnd() && this.length() > 1) {
            if (this.isFirst256Start()) {
                return "a:" + this.length() + "x'" + Utils.escapeJavaString(charSequence.subSequence(0, 1)) + "'";
            }
            return this.length() + "x'" + Utils.escapeJavaString(charSequence.subSequence(0, 1)) + "'";
        }
        int length = charSequence.length();
        String string = chars = length <= 20 ? charSequence.toString() : charSequence.subSequence(0, 10).toString() + "\u2026" + charSequence.subSequence(length - 10, length).toString();
        if (this.isFirst256Start()) {
            return "a:'" + Utils.escapeJavaString(chars) + "'";
        }
        return "'" + Utils.escapeJavaString(chars) + "'";
    }

    public static Segment getSegment(byte[] bytes, int byteOffset, int pos, int indexOffset, @NotNull BasedSequence basedSequence) {
        int type = bytes[byteOffset] & 0xE0;
        switch (type) {
            case 0: 
            case 32: {
                return new Base(pos, bytes, byteOffset, indexOffset, basedSequence);
            }
            case 64: 
            case 96: 
            case 128: 
            case 160: 
            case 192: 
            case 224: {
                return new Text(pos, bytes, byteOffset, indexOffset);
            }
        }
        throw new IllegalStateException("Invalid text type " + type);
    }

    public static SegType getSegType(@NotNull Seg seg, @NotNull CharSequence textChars) {
        if (seg.isBase()) {
            return seg.isAnchor() ? SegType.ANCHOR : SegType.BASE;
        }
        if (seg.isText()) {
            boolean first256Start = seg.isFirst256Start();
            boolean repeatedTextEnd = seg.isRepeatedTextEnd();
            if (first256Start) {
                if (repeatedTextEnd) {
                    char c = textChars.charAt(seg.getTextStart());
                    if (c == ' ') {
                        return SegType.REPEATED_SPACE;
                    }
                    if (c == '\n') {
                        return SegType.REPEATED_EOL;
                    }
                    return SegType.REPEATED_ASCII;
                }
                return SegType.TEXT_ASCII;
            }
            return repeatedTextEnd ? SegType.REPEATED_TEXT : SegType.TEXT;
        }
        throw new IllegalStateException("Unknown seg type " + seg);
    }

    public static int getOffsetBytes(int offset) {
        return offset < 16 ? 0 : (offset < 256 ? 1 : (offset < 65536 ? 2 : (offset < 0x1000000 ? 3 : 4)));
    }

    public static int getLengthBytes(int length) {
        return length < 16 ? 0 : (length < 256 ? 1 : (length < 65536 ? 2 : (length < 0x1000000 ? 3 : 4)));
    }

    public static int getIntBytes(int length) {
        return length < 256 ? 1 : (length < 65536 ? 2 : (length < 0x1000000 ? 3 : 4));
    }

    public static int getSegByteLength(@NotNull SegType segType, int segStart, int segLength) {
        int length = 1;
        if (segType.hasBoth()) {
            length += Segment.getIntBytes(segStart) + Segment.getIntBytes(segLength);
        } else if (segType.hasOffset()) {
            length += Segment.getOffsetBytes(segStart);
        } else if (segType.hasLength()) {
            length += Segment.getLengthBytes(segLength);
        }
        if (segType.hasChar()) {
            length += 2;
        } else if (segType.hasChars()) {
            length += 2 * segLength;
        } else if (segType.hasByte()) {
            ++length;
        } else if (segType.hasBytes()) {
            length += segLength;
        }
        return length;
    }

    public static int getSegByteLength(@NotNull Seg seg, @NotNull CharSequence textChars) {
        SegType segType = Segment.getSegType(seg, textChars);
        return Segment.getSegByteLength(segType, seg.getSegStart(), seg.length());
    }

    public static int addIntBytes(byte[] bytes, int offset, int value, int count) {
        switch (count) {
            case 4: {
                bytes[offset++] = (byte)((value & 0xFF000000) >> 24);
            }
            case 3: {
                bytes[offset++] = (byte)((value & 0xFF0000) >> 16);
            }
            case 2: {
                bytes[offset++] = (byte)((value & 0xFF00) >> 8);
            }
            case 1: {
                bytes[offset++] = (byte)(value & 0xFF);
            }
        }
        return offset;
    }

    public static int getInt(byte[] bytes, int offset, int count) {
        int value = 0;
        switch (count) {
            case 4: {
                value |= (0xFF & bytes[offset++]) << 24;
            }
            case 3: {
                value |= (0xFF & bytes[offset++]) << 16;
            }
            case 2: {
                value |= (0xFF & bytes[offset++]) << 8;
            }
            case 1: {
                value |= 0xFF & bytes[offset];
            }
        }
        return value;
    }

    public static int addChar(byte[] bytes, int offset, char c) {
        bytes[offset++] = (byte)((c & 0xFF00) >> 8);
        bytes[offset++] = (byte)(c & 0xFF);
        return offset;
    }

    public static char getChar(byte[] bytes, int offset) {
        char c = (char)((0xFF & bytes[offset++]) << 8);
        c = (char)(c | 0xFF & bytes[offset]);
        return c;
    }

    public static int addChars(byte[] bytes, int offset, @NotNull CharSequence chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = chars.charAt(i);
            bytes[offset++] = (byte)((c & 0xFF00) >> 8);
            bytes[offset++] = (byte)(c & 0xFF);
        }
        return offset;
    }

    public static int addCharAscii(byte[] bytes, int offset, char c) {
        assert (c < '\u0100');
        bytes[offset++] = (byte)(c & 0xFF);
        return offset;
    }

    public static int addCharsAscii(byte[] bytes, int offset, @NotNull CharSequence chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = chars.charAt(i);
            assert (c < '\u0100');
            bytes[offset++] = (byte)(c & 0xFF);
        }
        return offset;
    }

    public static char getCharAscii(byte[] bytes, int offset) {
        return (char)(0xFF & bytes[offset]);
    }

    public static int addSegBytes(byte[] bytes, int offset, @NotNull Seg seg, @NotNull CharSequence textChars) {
        SegType segType = Segment.getSegType(seg, textChars);
        int segLength = seg.length();
        if (segType.hasOffset()) {
            int segStart = seg.getStart();
            if (segType.hasLength()) {
                int offsetBytes = Segment.getIntBytes(segStart);
                int intBytes = Segment.getIntBytes(segLength);
                bytes[offset++] = (byte)(segType.flags | offsetBytes - 1 | intBytes - 1 << 2);
                offset = Segment.addIntBytes(bytes, offset, segStart, offsetBytes);
                offset = Segment.addIntBytes(bytes, offset, segLength, intBytes);
            } else {
                int offsetBytes = Segment.getOffsetBytes(segStart);
                if (offsetBytes == 0) {
                    assert (segStart < 16);
                    bytes[offset++] = (byte)(segType.flags | 0x10 | segStart);
                } else {
                    bytes[offset++] = (byte)(segType.flags | offsetBytes - 1);
                    offset = Segment.addIntBytes(bytes, offset, segStart, offsetBytes);
                }
            }
        } else if (segType.hasLength()) {
            int lengthBytes = Segment.getLengthBytes(segLength);
            if (lengthBytes == 0) {
                assert (segLength < 16);
                bytes[offset++] = (byte)(segType.flags | 0x10 | segLength);
            } else {
                bytes[offset++] = (byte)(segType.flags | lengthBytes - 1 << 2);
                offset = Segment.addIntBytes(bytes, offset, segLength, lengthBytes);
            }
        }
        if (segType.hasChar()) {
            offset = Segment.addChar(bytes, offset, textChars.charAt(seg.getTextStart()));
        } else if (segType.hasChars()) {
            offset = Segment.addChars(bytes, offset, textChars, seg.getTextStart(), seg.getTextEnd());
        } else if (segType.hasByte()) {
            offset = Segment.addCharAscii(bytes, offset, textChars.charAt(seg.getTextStart()));
        } else if (segType.hasBytes()) {
            offset = Segment.addCharsAscii(bytes, offset, textChars, seg.getTextStart(), seg.getTextEnd());
        }
        return offset;
    }

    static class Text
    extends Segment {
        @NotNull
        protected final CharSequence chars;

        public Text(int pos, byte[] bytes, int byteOffset, int indexOffset) {
            super(pos, bytes, byteOffset, indexOffset);
            int length;
            int type = bytes[byteOffset++] & 0xFF;
            int segTypeMask = type & 0xE0;
            if (this.hasAll(type, 16)) {
                length = type & 0xF;
            } else {
                int lengthBytes = (type & 0xC) >> 2;
                length = Text.getInt(bytes, byteOffset, lengthBytes + 1);
                byteOffset += lengthBytes + 1;
            }
            switch (segTypeMask) {
                case 64: {
                    this.chars = new TextCharSequence(bytes, byteOffset, 0, length);
                    break;
                }
                case 128: {
                    this.chars = new TextAsciiCharSequence(bytes, byteOffset, 0, length);
                    break;
                }
                case 96: {
                    this.chars = new TextRepeatedSequence(Text.getChar(bytes, byteOffset), length);
                    break;
                }
                case 160: {
                    this.chars = new TextRepeatedSequence((char)(0xFF & bytes[byteOffset]), length);
                    break;
                }
                case 192: {
                    this.chars = new TextRepeatedSequence(' ', length);
                    break;
                }
                case 224: {
                    this.chars = new TextRepeatedSequence('\n', length);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid text type " + segTypeMask);
                }
            }
        }

        @Override
        public int length() {
            return this.chars.length();
        }

        @Override
        public char charAt(int index) {
            if (index < this.startIndex || index - this.startIndex >= this.chars.length()) {
                throw new IndexOutOfBoundsException("index " + index + " out of bounds [" + this.startIndex + ", " + this.startIndex + this.chars.length() + ")");
            }
            return this.chars.charAt(index - this.startIndex);
        }

        @Override
        public boolean isBase() {
            return false;
        }

        @Override
        public boolean isAnchor() {
            return false;
        }

        @Override
        public boolean isText() {
            return true;
        }

        int textType() {
            return this.bytes[this.byteOffset] & 0xE0;
        }

        @Override
        public boolean isFirst256Start() {
            int textType = this.textType();
            return textType == 128 || textType == 160 || textType == 192 || textType == 224;
        }

        @Override
        public boolean isRepeatedTextEnd() {
            int textType = this.textType();
            return textType == 96 || textType == 160 || textType == 192 || textType == 224;
        }

        @Override
        public int getStartOffset() {
            return -1;
        }

        @Override
        public int getEndOffset() {
            return -1;
        }

        @Override
        @NotNull
        public CharSequence getCharSequence() {
            return this.chars;
        }
    }

    static class TextRepeatedSequence
    implements CharSequence {
        protected final char c;
        protected final int length;

        public TextRepeatedSequence(char c, int length) {
            this.c = c;
            this.length = length;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            if (index < 0 || index >= this.length) {
                throw new IndexOutOfBoundsException("index " + index + " out of bounds [0, " + this.length + ")");
            }
            return this.c;
        }

        @Override
        public CharSequence subSequence(int startIndex, int endIndex) {
            if (startIndex < 0 || startIndex > endIndex || endIndex > this.length) {
                throw new IndexOutOfBoundsException("Invalid index range [" + startIndex + ", " + endIndex + "] out of bounds [0, " + this.length() + ")");
            }
            return new TextRepeatedSequence(this.c, endIndex - startIndex);
        }

        @Override
        @NotNull
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.length; ++i) {
                sb.append(this.c);
            }
            return sb.toString();
        }
    }

    static class TextAsciiCharSequence
    extends TextCharSequenceBase {
        public TextAsciiCharSequence(byte[] bytes, int byteOffset, int startOffset, int length) {
            super(bytes, byteOffset, startOffset, length);
        }

        @Override
        public char charAt(int index) {
            if (index < 0 || index >= this.length) {
                throw new IndexOutOfBoundsException("index " + index + " out of bounds [0, " + this.length + ")");
            }
            return (char)(0xFF & this.bytes[this.byteOffset + this.startOffset + index]);
        }

        @Override
        CharSequence create(int startOffset, int length) {
            return new TextAsciiCharSequence(this.bytes, this.byteOffset, startOffset, length);
        }
    }

    static class TextCharSequence
    extends TextCharSequenceBase {
        public TextCharSequence(byte[] bytes, int byteOffset, int startOffset, int length) {
            super(bytes, byteOffset, startOffset, length);
        }

        @Override
        public char charAt(int index) {
            if (index < 0 || index >= this.length) {
                throw new IndexOutOfBoundsException("index " + index + " out of bounds [0, " + this.length + ")");
            }
            return Segment.getChar(this.bytes, this.byteOffset + (this.startOffset + index) * 2);
        }

        @Override
        CharSequence create(int startOffset, int length) {
            return new TextCharSequence(this.bytes, this.byteOffset, startOffset, length);
        }
    }

    static abstract class TextCharSequenceBase
    implements CharSequence {
        protected final byte[] bytes;
        protected final int byteOffset;
        protected final int startOffset;
        protected final int length;

        public TextCharSequenceBase(byte[] bytes, int byteOffset, int startOffset, int length) {
            this.bytes = bytes;
            this.byteOffset = byteOffset;
            this.startOffset = startOffset;
            this.length = length;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public abstract char charAt(int var1);

        abstract CharSequence create(int var1, int var2);

        @Override
        public CharSequence subSequence(int startIndex, int endIndex) {
            if (startIndex < 0 || startIndex > endIndex || endIndex > this.length) {
                throw new IndexOutOfBoundsException("Invalid index range [" + startIndex + ", " + endIndex + "] out of bounds [0, " + this.length() + ")");
            }
            return this.create(this.startOffset + startIndex, endIndex - startIndex);
        }

        @Override
        @NotNull
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.length; ++i) {
                sb.append(this.charAt(i));
            }
            return sb.toString();
        }
    }

    static class Base
    extends Segment {
        protected final int startOffset;
        protected final int endOffset;
        @NotNull
        protected final BasedSequence baseSeq;

        public Base(int pos, byte[] bytes, int byteOffset, int indexOffset, @NotNull BasedSequence basedSequence) {
            super(pos, bytes, byteOffset, indexOffset);
            this.baseSeq = basedSequence;
            int type = bytes[byteOffset++] & 0xFF;
            if ((type & 0xE0) == 0) {
                if (this.hasAll(type, 16)) {
                    this.endOffset = this.startOffset = type & 0xF;
                } else {
                    int intBytes = type & 3;
                    this.endOffset = this.startOffset = Base.getInt(bytes, byteOffset, intBytes + 1);
                }
            } else {
                assert (!this.hasAll(type, 16));
                int intBytes = type & 3;
                this.startOffset = Base.getInt(bytes, byteOffset, intBytes + 1);
                int lengthBytes = (type & 0xC) >> 2;
                this.endOffset = this.startOffset + Base.getInt(bytes, byteOffset += intBytes + 1, lengthBytes + 1);
            }
        }

        @Override
        public int length() {
            return this.endOffset - this.startOffset;
        }

        @Override
        public boolean isBase() {
            return true;
        }

        @Override
        public boolean isAnchor() {
            return this.startOffset == this.endOffset;
        }

        @Override
        public boolean isText() {
            return false;
        }

        @Override
        public boolean isFirst256Start() {
            return false;
        }

        @Override
        public boolean isRepeatedTextEnd() {
            return false;
        }

        @Override
        public int getStartOffset() {
            return this.startOffset;
        }

        @Override
        public int getEndOffset() {
            return this.endOffset;
        }

        @Override
        public char charAt(int index) {
            if (index < this.startIndex || index - this.startIndex >= this.length()) {
                throw new IndexOutOfBoundsException("index " + index + " out of bounds [" + this.startIndex + ", " + this.startIndex + this.length() + ")");
            }
            return this.baseSeq.charAt(this.startOffset + index - this.startIndex);
        }

        @Override
        public CharSequence getCharSequence() {
            return this.baseSeq.subSequence(this.startOffset, this.endOffset);
        }
    }

    public static enum SegType {
        ANCHOR(256),
        BASE(800),
        TEXT(2624),
        REPEATED_TEXT(1632),
        TEXT_ASCII(8832),
        REPEATED_ASCII(4768),
        REPEATED_SPACE(704),
        REPEATED_EOL(736);

        public final int flags;

        private SegType(int flags) {
            this.flags = flags;
        }

        public boolean hasAll(int flags) {
            return (this.flags & flags) == flags;
        }

        public boolean hasLength() {
            return this.hasAll(512);
        }

        public boolean hasOffset() {
            return this.hasAll(256);
        }

        public boolean hasBoth() {
            return this.hasAll(768);
        }

        public boolean hasChar() {
            return this.hasAll(1024);
        }

        public boolean hasChars() {
            return this.hasAll(2048);
        }

        public boolean hasByte() {
            return this.hasAll(4096);
        }

        public boolean hasBytes() {
            return this.hasAll(8192);
        }

        public static SegType fromTypeMask(int segTypeMask) {
            switch (segTypeMask & 0xE0) {
                case 0: {
                    return ANCHOR;
                }
                case 32: {
                    return BASE;
                }
                case 64: {
                    return TEXT;
                }
                case 128: {
                    return TEXT_ASCII;
                }
                case 96: {
                    return REPEATED_TEXT;
                }
                case 160: {
                    return REPEATED_ASCII;
                }
                case 192: {
                    return REPEATED_SPACE;
                }
                case 224: {
                    return REPEATED_EOL;
                }
            }
            throw new IllegalStateException(String.format("Invalid text type %02x", segTypeMask));
        }
    }
}

