/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.vfs.fragment.CsvTableDataFragmentFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridDataHookUpManager {
    private final Project myProject;
    private final Set<HookUpReference> myHookUps;
    private final Object myLock;

    public GridDataHookUpManager(@NotNull Project project) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myHookUps = new HashSet<HookUpReference>();
        this.myLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GridDataHookUp<GridRow, GridColumn>> getHookUps() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myHookUps.stream().filter(h -> h.myReferenceCount > 0).map(h -> h.myHookUp).collect(Collectors.toList());
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(1);
        }
        return project;
    }

    public static GridDataHookUpManager getInstance(@NotNull Project project) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(2);
        }
        return (GridDataHookUpManager)project.getService(GridDataHookUpManager.class);
    }

    @NotNull
    public CsvDocumentDataHookUp getHookUp(@NotNull CsvTableDataFragmentFile file, @NotNull Disposable parent) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(4);
        }
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.getOrCreateHookUp(file, f -> new CsvDocumentDataHookUp(this.myProject, f.getFormat(), GridDataHookUpManager.getDocument(f.getOriginalFile()), f.getRange()), parent);
        if (csvDocumentDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(5);
        }
        return csvDocumentDataHookUp;
    }

    @NotNull
    public CsvDocumentDataHookUp getHookUp(@NotNull VirtualFile file, @NotNull CsvFormat format, @NotNull Disposable parent) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(6);
        }
        if (format == null) {
            GridDataHookUpManager.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(8);
        }
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> new CsvDocumentDataHookUp(this.myProject, format, GridDataHookUpManager.getDocument(file1), null), parent);
        if (csvDocumentDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(9);
        }
        return csvDocumentDataHookUp;
    }

    @NotNull
    public static Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(10);
        }
        Document document = Objects.requireNonNull(FileDocumentManager.getInstance().getDocument(file));
        if (document == null) {
            GridDataHookUpManager.$$$reportNull$$$0(11);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridDataHookUp<GridRow, GridColumn> acquire(@NotNull HookUpHandle handle, @NotNull Disposable parent) {
        if (handle == null) {
            GridDataHookUpManager.$$$reportNull$$$0(12);
        }
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(13);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (handle.myRef == null || handle.myRef.myReferenceCount <= 0) {
                return null;
            }
            Disposer.register((Disposable)parent, (Disposable)this.createHookUpReferenceDisposable(handle.myRef));
            return handle.myRef.myHookUp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public HookUpHandle getHandle(@NotNull GridDataHookUp<GridRow, GridColumn> hookUp) {
        if (hookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(14);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        HookUpReference res = null;
        for (HookUpReference ref : this.myHookUps) {
            if (ref.myHookUp != hookUp) continue;
            res = ref;
            break;
        }
        HookUpHandle hookUpHandle = new HookUpHandle(res);
        // MONITOREXIT : object
        if (hookUpHandle != null) return hookUpHandle;
        GridDataHookUpManager.$$$reportNull$$$0(15);
        return hookUpHandle;
    }

    private Disposable createHookUpReferenceDisposable(final @NotNull HookUpReference ref) {
        if (ref == null) {
            GridDataHookUpManager.$$$reportNull$$$0(16);
        }
        if (!GridDataHookUpManager.isClosingToReopen(ref)) {
            ++ref.myReferenceCount;
        }
        return new Disposable(){
            private final AtomicBoolean myDisposed = new AtomicBoolean(false);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                if (!this.myDisposed.compareAndSet(false, true)) {
                    return;
                }
                if (GridDataHookUpManager.isClosingToReopen(ref)) {
                    return;
                }
                Object object = GridDataHookUpManager.this.myLock;
                synchronized (object) {
                    if (--ref.myReferenceCount <= 0) {
                        Disposer.dispose((Disposable)ref);
                        GridDataHookUpManager.this.myHookUps.remove(ref);
                    }
                }
            }
        };
    }

    private static boolean isClosingToReopen(@NotNull HookUpReference ref) {
        VirtualFile file;
        if (ref == null) {
            GridDataHookUpManager.$$$reportNull$$$0(17);
        }
        return (file = GridUtil.getVirtualFile(ref.myHookUp)) != null && file.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN) == Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <F extends VirtualFile, H extends GridDataHookUp<GridRow, GridColumn>> H getOrCreateHookUp(@NotNull F file, @NotNull Function<F, H> hookUpFactory, @NotNull Disposable parent) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(18);
        }
        if (hookUpFactory == null) {
            GridDataHookUpManager.$$$reportNull$$$0(19);
        }
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(20);
        }
        Object object = this.myLock;
        synchronized (object) {
            GridDataHookUp hookUp = (GridDataHookUp)hookUpFactory.fun(file);
            HookUpReference ref = new HookUpReference((GridDataHookUp<GridRow, GridColumn>)hookUp);
            this.myHookUps.add(ref);
            Disposer.register((Disposable)parent, (Disposable)this.createHookUpReferenceDisposable(ref));
            return (H)ref.myHookUp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends GridDataHookUp<GridRow, GridColumn>> T registerHookUp(T hookUp, @NotNull Disposable parent) {
        if (parent == null) {
            GridDataHookUpManager.$$$reportNull$$$0(21);
        }
        Object object = this.myLock;
        synchronized (object) {
            HookUpReference ref = new HookUpReference(hookUp);
            this.myHookUps.add(ref);
            Disposer.register((Disposable)parent, (Disposable)this.createHookUpReferenceDisposable(ref));
            return hookUp;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 9, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridDataHookUpManager";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: 
            case 13: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handle";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUpFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridDataHookUpManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHookUp";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHookUp";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "acquire";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getHandle";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createHookUpReferenceDisposable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isClosingToReopen";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateHookUp";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerHookUp";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 9, 11, 15 -> new IllegalStateException(string);
        };
    }

    public static final class HookUpHandle {
        private final HookUpReference myRef;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HookUpHandle handle = (HookUpHandle)o;
            return Objects.equals(this.myRef, handle.myRef);
        }

        public int hashCode() {
            return this.myRef != null ? this.myRef.hashCode() : 0;
        }

        private HookUpHandle(@Nullable HookUpReference ref) {
            this.myRef = ref;
        }
    }

    private static class HookUpReference
    implements Disposable {
        private final GridDataHookUp<GridRow, GridColumn> myHookUp;
        private int myReferenceCount = 0;

        private HookUpReference(GridDataHookUp<GridRow, GridColumn> hookUp) {
            this.myHookUp = hookUp;
            if (this.myHookUp instanceof Disposable) {
                Disposer.register((Disposable)this, (Disposable)((Disposable)this.myHookUp));
            }
        }

        public void dispose() {
        }
    }
}

