/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.actions.DumpSourceNameProvider;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DumpSource<T> {
    @NotNull
    public JBIterable<T> getSources();

    @NotNull
    public DumpSourceNameProvider<T> getNameProvider();

    default public int estimateSize() {
        JBIterable<T> sources = this.getSources();
        return sources.isEmpty() ? 0 : (sources.skip(1).isEmpty() ? 1 : 2);
    }

    public static int getSize(@Nullable DumpSource<?> object) {
        return object == null ? 1 : object.estimateSize();
    }

    public static class DataGridSource
    implements DumpSource<DataGrid> {
        private final DataGrid myGrid;

        public DataGridSource(DataGrid grid) {
            this.myGrid = grid;
        }

        @NotNull
        public DataGrid getGrid() {
            DataGrid dataGrid = this.myGrid;
            if (dataGrid == null) {
                DataGridSource.$$$reportNull$$$0(0);
            }
            return dataGrid;
        }

        @Override
        @NotNull
        public JBIterable<DataGrid> getSources() {
            JBIterable jBIterable = JBIterable.of((Object)this.myGrid);
            if (jBIterable == null) {
                DataGridSource.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public DumpSourceNameProvider<DataGrid> getNameProvider() {
            DumpSourceNameProvider.DataGridSourceNameProvider dataGridSourceNameProvider = DumpSourceNameProvider.DataGridSourceNameProvider.INSTANCE;
            if (dataGridSourceNameProvider == null) {
                DataGridSource.$$$reportNull$$$0(2);
            }
            return dataGridSourceNameProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/run/actions/DumpSource$DataGridSource";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGrid";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSources";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameProvider";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

