/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.openapi.util.Key;
import com.intellij.util.Function;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GridCellEditorFactoryProvider {
    public static final Key<GridCellEditorFactoryProvider> FACTORY_PROVIDER_KEY = new Key("FACTORY_PROVIDER_KEY");

    @Nullable
    public GridCellEditorFactory getEditorFactory(@NotNull DataGrid var1, @NotNull ModelIndex<GridRow> var2, @NotNull ModelIndex<GridColumn> var3);

    public static void set(@NotNull DataGrid grid, @Nullable GridCellEditorFactoryProvider provider) {
        if (grid == null) {
            GridCellEditorFactoryProvider.$$$reportNull$$$0(0);
        }
        grid.putUserData(FACTORY_PROVIDER_KEY, provider);
    }

    @Nullable
    public static GridCellEditorFactoryProvider get(@NotNull DataGrid grid) {
        if (grid == null) {
            GridCellEditorFactoryProvider.$$$reportNull$$$0(1);
        }
        return (GridCellEditorFactoryProvider)grid.getUserData(FACTORY_PROVIDER_KEY);
    }

    public static <T> T getEditorFactory(@NotNull List<? extends GridCellEditorFactory> factories, @NotNull Function<T, Integer> suitabilityCheck, Class<T> clazz) {
        if (factories == null) {
            GridCellEditorFactoryProvider.$$$reportNull$$$0(2);
        }
        if (suitabilityCheck == null) {
            GridCellEditorFactoryProvider.$$$reportNull$$$0(3);
        }
        int maxSuitability = 0;
        GridCellEditorFactory bestMatchingFactory = null;
        for (GridCellEditorFactory gridCellEditorFactory : factories) {
            GridCellEditorFactory f;
            int suitability;
            if (!clazz.isAssignableFrom(gridCellEditorFactory.getClass()) || (suitability = ((Integer)suitabilityCheck.fun((Object)(f = gridCellEditorFactory))).intValue()) <= maxSuitability) continue;
            maxSuitability = suitability;
            bestMatchingFactory = f;
        }
        return (T)bestMatchingFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factories";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suitabilityCheck";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorFactoryProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorFactory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

