/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.remote.providers.commands;

import com.intellij.jupyter.core.jupyter.JupyterRemoteBundle;
import com.intellij.jupyter.core.jupyter.remote.providers.commands.PasteCommand;
import com.intellij.jupyter.core.jupyter.remote.providers.strategy.LocalToRemoteCopyStrategy;
import com.intellij.notebooks.core.remote.JupyterRemotePath;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0015\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f0\u0005\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/providers/commands/SingleLocalFileToRemoteDirCommand;", "Lcom/intellij/jupyter/core/jupyter/remote/providers/commands/PasteCommand;", "project", "Lcom/intellij/openapi/project/Project;", "newName", "", "sourcePsiItem", "Lcom/intellij/psi/PsiFileSystemItem;", "targetDirectory", "Lcom/intellij/notebooks/core/remote/JupyterRemotePath;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/psi/PsiFileSystemItem;Lcom/intellij/notebooks/core/remote/JupyterRemotePath;)V", "sourcePath", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "targetPath", "taskTitle", "getTaskTitle", "()Ljava/lang/String;", "strategy", "Lcom/intellij/jupyter/core/jupyter/remote/providers/strategy/LocalToRemoteCopyStrategy;", "doExecute", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.jupyter.core"})
public final class SingleLocalFileToRemoteDirCommand
extends PasteCommand {
    @NotNull
    private final String newName;
    @NotNull
    private final PsiFileSystemItem sourcePsiItem;
    @NotNull
    private final JupyterRemotePath targetDirectory;
    @NotNull
    private final String sourcePath;
    @NotNull
    private final String targetPath;
    @NotNull
    private final String taskTitle;
    @NotNull
    private final LocalToRemoteCopyStrategy strategy;

    public SingleLocalFileToRemoteDirCommand(@NotNull Project project, @NotNull String newName, @NotNull PsiFileSystemItem sourcePsiItem, @NotNull JupyterRemotePath targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)sourcePsiItem, (String)"sourcePsiItem");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        super(project, null);
        this.newName = newName;
        this.sourcePsiItem = sourcePsiItem;
        this.targetDirectory = targetDirectory;
        String string = this.sourcePsiItem.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.sourcePath = string;
        Object[] objectArray = new String[]{this.newName};
        this.targetPath = this.targetDirectory.resolve((String[])objectArray).getFullPath();
        objectArray = new Object[]{this.sourcePath, this.targetPath};
        this.taskTitle = JupyterRemoteBundle.message("Jupyter.remote.copying", objectArray);
        this.strategy = new LocalToRemoteCopyStrategy(this);
    }

    @Override
    @NotNull
    public String getTaskTitle() {
        return this.taskTitle;
    }

    @Override
    @Nullable
    public Object doExecute(@NotNull Continuation<? super Unit> $completion) {
        if (this.sourcePsiItem instanceof PsiDirectory) {
            Path path = ((PsiDirectory)this.sourcePsiItem).getVirtualFile().toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            Object object = this.strategy.copyDirectory(path, this.newName, this.targetDirectory, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Path path = this.sourcePsiItem.getVirtualFile().toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        Object object = this.strategy.copyFile(path, this.newName, this.targetDirectory, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

