/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.view;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.internal.view.NoopAttributesProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AttributesProcessor {
    AttributesProcessor() {
    }

    public abstract Attributes process(Attributes var1, Context var2);

    public abstract boolean usesContext();

    public AttributesProcessor then(AttributesProcessor other) {
        if (other == NoopAttributesProcessor.NOOP) {
            return this;
        }
        if (this == NoopAttributesProcessor.NOOP) {
            return other;
        }
        if (other instanceof JoinedAttributesProcessor) {
            return ((JoinedAttributesProcessor)other).prepend(this);
        }
        return new JoinedAttributesProcessor(Arrays.asList(this, other));
    }

    public static AttributesProcessor noop() {
        return NoopAttributesProcessor.NOOP;
    }

    public static AttributesProcessor filterByKeyName(Predicate<String> nameFilter) {
        return new AttributeKeyFilteringProcessor(nameFilter);
    }

    public static AttributesProcessor appendBaggageByKeyName(Predicate<String> nameFilter) {
        return new BaggageAppendingAttributesProcessor(nameFilter);
    }

    public static AttributesProcessor append(Attributes attributes) {
        return new AppendingAttributesProcessor(attributes);
    }

    public static Predicate<String> setIncludes(Set<String> set) {
        return new SetIncludesPredicate(set);
    }

    @Immutable
    private static final class JoinedAttributesProcessor
    extends AttributesProcessor {
        private final Collection<AttributesProcessor> processors;
        private final boolean usesContextCache;

        JoinedAttributesProcessor(Collection<AttributesProcessor> processors) {
            this.processors = processors;
            this.usesContextCache = processors.stream().map(AttributesProcessor::usesContext).reduce(false, (l, r) -> l != false || r != false);
        }

        @Override
        public Attributes process(Attributes incoming, Context context) {
            Attributes result = incoming;
            for (AttributesProcessor processor : this.processors) {
                result = processor.process(result, context);
            }
            return result;
        }

        @Override
        public boolean usesContext() {
            return this.usesContextCache;
        }

        @Override
        public AttributesProcessor then(AttributesProcessor other) {
            ArrayList<AttributesProcessor> newList = new ArrayList<AttributesProcessor>(this.processors);
            if (other instanceof JoinedAttributesProcessor) {
                newList.addAll(((JoinedAttributesProcessor)other).processors);
            } else {
                newList.add(other);
            }
            return new JoinedAttributesProcessor(newList);
        }

        AttributesProcessor prepend(AttributesProcessor other) {
            ArrayList<AttributesProcessor> newList = new ArrayList<AttributesProcessor>(this.processors.size() + 1);
            newList.add(other);
            newList.addAll(this.processors);
            return new JoinedAttributesProcessor(newList);
        }

        public String toString() {
            return "JoinedAttributesProcessor{processors=" + this.processors + "}";
        }
    }

    private static class AttributeKeyFilteringProcessor
    extends AttributesProcessor {
        private final Predicate<String> nameFilter;

        private AttributeKeyFilteringProcessor(Predicate<String> nameFilter) {
            this.nameFilter = nameFilter;
        }

        @Override
        public Attributes process(Attributes incoming, Context context) {
            return incoming.toBuilder().removeIf(attributeKey -> !this.nameFilter.test(attributeKey.getKey())).build();
        }

        @Override
        public boolean usesContext() {
            return false;
        }

        public String toString() {
            return "AttributeKeyFilteringProcessor{nameFilter=" + this.nameFilter + "}";
        }
    }

    private static final class BaggageAppendingAttributesProcessor
    extends AttributesProcessor {
        private final Predicate<String> nameFilter;

        private BaggageAppendingAttributesProcessor(Predicate<String> nameFilter) {
            this.nameFilter = nameFilter;
        }

        @Override
        public Attributes process(Attributes incoming, Context context) {
            AttributesBuilder result = Attributes.builder();
            Baggage.fromContext(context).forEach((k, v) -> {
                if (this.nameFilter.test((String)k)) {
                    result.put((String)k, v.getValue());
                }
            });
            result.putAll(incoming);
            return result.build();
        }

        @Override
        public boolean usesContext() {
            return true;
        }

        public String toString() {
            return "BaggageAppendingAttributesProcessor{nameFilter=" + this.nameFilter + "}";
        }
    }

    private static class AppendingAttributesProcessor
    extends AttributesProcessor {
        private final Attributes additionalAttributes;

        private AppendingAttributesProcessor(Attributes additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
        }

        @Override
        public Attributes process(Attributes incoming, Context context) {
            return this.additionalAttributes.toBuilder().putAll(incoming).build();
        }

        @Override
        public boolean usesContext() {
            return false;
        }

        public String toString() {
            return "AppendingAttributesProcessor{additionalAttributes=" + this.additionalAttributes + "}";
        }
    }

    private static class SetIncludesPredicate
    implements Predicate<String> {
        private final Set<String> set;

        private SetIncludesPredicate(Set<String> set) {
            this.set = set;
        }

        @Override
        public boolean test(String s) {
            return this.set.contains(s);
        }

        public String toString() {
            return "SetIncludesPredicate{set=" + this.set + "}";
        }
    }
}

