/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandlerKt;
import com.intellij.vcs.commit.AmendCommitAware;
import com.intellij.vcs.commit.AmendCommitHandler;
import com.intellij.vcs.commit.AmendCommitModeListener;
import com.intellij.vcs.commit.CommitOption;
import com.intellij.vcs.commit.CommitSessionCollector;
import java.awt.event.ActionEvent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/commit/ToggleAmendCommitOption;", "Lcom/intellij/ui/components/JBCheckBox;", "commitPanel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "parent", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/vcs/CheckinProjectPanel;Lcom/intellij/openapi/Disposable;)V", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "amendCommitHandler", "Lcom/intellij/vcs/commit/AmendCommitHandler;", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class ToggleAmendCommitOption
extends JBCheckBox {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AmendCommitHandler amendCommitHandler;

    public ToggleAmendCommitOption(@NotNull CheckinProjectPanel commitPanel, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)commitPanel, (String)"commitPanel");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(VcsBundle.message((String)"commit.amend.commit", (Object[])new Object[0]));
        Project project = commitPanel.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.amendCommitHandler = commitPanel.getCommitWorkflowHandler().getAmendCommitHandler();
        this.setMnemonic(77);
        this.setToolTipText(VcsBundle.message((String)"commit.tooltip.merge.this.commit.with.the.previous.one", (Object[])new Object[0]));
        this.addActionListener(arg_0 -> ToggleAmendCommitOption._init_$lambda$0(this, arg_0));
        this.amendCommitHandler.addAmendCommitModeListener(new AmendCommitModeListener(){

            public void amendCommitModeToggled() {
                this.setSelected(amendCommitHandler.isAmendCommitMode());
            }
        }, parent);
    }

    private static final void _init_$lambda$0(ToggleAmendCommitOption this$0, ActionEvent it) {
        this$0.amendCommitHandler.setAmendCommitMode(this$0.isSelected());
        CommitSessionCollector.Companion.getInstance(this$0.project).logCommitOptionToggled(CommitOption.AMEND, this$0.isSelected());
    }

    @JvmStatic
    public static final boolean isAmendCommitOptionSupported(@NotNull CheckinProjectPanel commitPanel, @NotNull AmendCommitAware amendAware) {
        return Companion.isAmendCommitOptionSupported(commitPanel, amendAware);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/commit/ToggleAmendCommitOption$Companion;", "", "<init>", "()V", "isAmendCommitOptionSupported", "", "commitPanel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "amendAware", "Lcom/intellij/vcs/commit/AmendCommitAware;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isAmendCommitOptionSupported(@NotNull CheckinProjectPanel commitPanel, @NotNull AmendCommitAware amendAware) {
            Intrinsics.checkNotNullParameter((Object)commitPanel, (String)"commitPanel");
            Intrinsics.checkNotNullParameter((Object)amendAware, (String)"amendAware");
            return !AbstractCommitWorkflowHandlerKt.isNonModalCommit(commitPanel) && amendAware.isAmendCommitSupported();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

