/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.project.Project;
import java.awt.Point;
import javax.swing.JComponent;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.settings.MarkdownSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownPreviewFileEditor;
import org.jetbrains.annotations.NotNull;

public final class MarkdownEditorWithPreview
extends TextEditorWithPreview {
    private boolean autoScrollPreview;

    public MarkdownEditorWithPreview(@NotNull TextEditor editor2, @NotNull MarkdownPreviewFileEditor preview, @NotNull Project project) {
        if (editor2 == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(0);
        }
        if (preview == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(1);
        }
        if (project == null) {
            MarkdownEditorWithPreview.$$$reportNull$$$0(2);
        }
        super(editor2, (FileEditor)preview, MarkdownBundle.message("markdown.editor.name", new Object[0]), TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW, !MarkdownSettings.getInstance(project).isVerticalSplit());
        editor2.getEditor().getContentComponent().putClientProperty(ActionUtil.ALLOW_ACTION_PERFORM_WHEN_HIDDEN, true);
        preview.setMainEditor(editor2.getEditor());
        final MarkdownSettings settings = MarkdownSettings.getInstance(project);
        this.autoScrollPreview = settings.isAutoScrollEnabled();
        project.getMessageBus().connect((Disposable)this).subscribe(MarkdownSettings.ChangeListener.TOPIC, (Object)new MarkdownSettings.ChangeListener(){
            private boolean wasVerticalSplitBefore;
            {
                this.wasVerticalSplitBefore = settings.isVerticalSplit();
            }

            @Override
            public void beforeSettingsChanged(@NotNull MarkdownSettings settings1) {
                if (settings1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.wasVerticalSplitBefore = settings1.isVerticalSplit();
            }

            @Override
            public void settingsChanged(@NotNull MarkdownSettings settings1) {
                if (settings1 == null) {
                    1.$$$reportNull$$$0(1);
                }
                MarkdownEditorWithPreview.this.setAutoScrollPreview(settings1.isAutoScrollEnabled());
                if (this.wasVerticalSplitBefore != settings1.isVerticalSplit()) {
                    MarkdownEditorWithPreview.this.handleLayoutChange(!settings1.isVerticalSplit());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings1";
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeSettingsChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "settingsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        editor2.getEditor().getScrollingModel().addVisibleAreaListener((VisibleAreaListener)new MyVisibleAreaListener(), (Disposable)this);
    }

    protected void onLayoutChange(TextEditorWithPreview.Layout oldValue, TextEditorWithPreview.Layout newValue) {
        super.onLayoutChange(oldValue, newValue);
        if (newValue == TextEditorWithPreview.Layout.SHOW_PREVIEW) {
            this.requestFocusForPreview();
        }
    }

    private void requestFocusForPreview() {
        JComponent preferredComponent = this.myPreview.getPreferredFocusedComponent();
        if (preferredComponent != null) {
            preferredComponent.requestFocus();
            return;
        }
        this.myPreview.getComponent().requestFocus();
    }

    public boolean isAutoScrollPreview() {
        return this.autoScrollPreview;
    }

    public void setAutoScrollPreview(boolean autoScrollPreview) {
        this.autoScrollPreview = autoScrollPreview;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "preview";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "org/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyVisibleAreaListener
    implements VisibleAreaListener {
        private int previousLine = 0;

        private MyVisibleAreaListener() {
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent event) {
            int currentLine;
            if (event == null) {
                MyVisibleAreaListener.$$$reportNull$$$0(0);
            }
            if (!MarkdownEditorWithPreview.this.isAutoScrollPreview()) {
                return;
            }
            Editor editor2 = event.getEditor();
            int y = editor2.getScrollingModel().getVerticalScrollOffset();
            int n = currentLine = editor2 instanceof EditorImpl ? editor2.xyToLogicalPosition(new Point(0, y)).getLine() : y / editor2.getLineHeight();
            if (currentLine == this.previousLine) {
                return;
            }
            this.previousLine = currentLine;
            ((MarkdownPreviewFileEditor)MarkdownEditorWithPreview.this.myPreview).scrollToLine(editor2, currentLine);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/plugins/markdown/ui/preview/MarkdownEditorWithPreview$MyVisibleAreaListener", "visibleAreaChanged"));
        }
    }
}

