/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.icons.AllIcons;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TipsOfTheDayUsagesCollector;
import com.intellij.ide.ui.text.StyledTextPane;
import com.intellij.ide.ui.text.paragraph.TextParagraph;
import com.intellij.ide.ui.text.parts.IllustrationTextPart;
import com.intellij.ide.ui.text.parts.RegularTextPart;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipAndTrickPromotionFactory;
import com.intellij.ide.util.TipUiSettings;
import com.intellij.ide.util.TipUtils;
import com.intellij.ide.util.TipsFeedback;
import com.intellij.ide.util.TipsSortingResult;
import com.intellij.ide.util.TipsUsageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TipPanel
extends JPanel
implements DoNotAskOption {
    public static final Key<String> CURRENT_TIP_KEY = Key.create((String)"CURRENT_TIP");
    private static final Logger LOG = Logger.getInstance(TipPanel.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final JLabel mySubSystemLabel;
    private final StyledTextPane myTextPane;
    final AbstractAction myPreviousTipAction;
    final AbstractAction myNextTipAction;
    @NotNull
    private String myAlgorithm;
    @Nullable
    private String myAlgorithmVersion;
    private List<TipAndTrickBean> myTips;
    private TipAndTrickBean myCurrentTip;
    private JPanel myCurrentPromotion;
    private ActionToolbarImpl myFeedbackToolbar;
    private final Map<String, Boolean> myTipIdToLikenessState;
    private Boolean myCurrentLikenessState;

    TipPanel(@Nullable Project project, @NotNull TipsSortingResult sortingResult, @NotNull Disposable parentDisposable) {
        if (sortingResult == null) {
            TipPanel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            TipPanel.$$$reportNull$$$0(1);
        }
        this.myAlgorithm = "unknown";
        this.myAlgorithmVersion = null;
        this.myTips = Collections.emptyList();
        this.myCurrentTip = null;
        this.myCurrentPromotion = null;
        this.myFeedbackToolbar = null;
        this.myTipIdToLikenessState = new LinkedHashMap<String, Boolean>();
        this.myCurrentLikenessState = null;
        this.setLayout(new BorderLayout());
        this.myProject = project;
        @NotNull JPanel contentPanel = new JPanel();
        contentPanel.setBackground(TipUiSettings.getPanelBackground());
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        this.mySubSystemLabel = new JLabel(){

            @Override
            public void updateUI() {
                super.updateUI();
                this.setFont((Font)JBFont.label().lessOn(1.0f));
            }
        };
        this.mySubSystemLabel.setForeground(UIUtil.getLabelInfoForeground());
        this.mySubSystemLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)4));
        this.mySubSystemLabel.setAlignmentX(0.0f);
        contentPanel.add(this.mySubSystemLabel);
        this.myTextPane = new MyTextPane();
        this.myTextPane.putClientProperty((Object)"caretWidth", (Object)0);
        this.myTextPane.setBackground(TipUiSettings.getPanelBackground());
        this.myTextPane.setMargin((Insets)JBInsets.emptyInsets());
        this.myTextPane.setAlignmentX(0.0f);
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myTextPane);
        contentPanel.add((Component)this.myTextPane);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        Border insideBorder = TipUiSettings.getTipPanelBorder();
        Border outsideBorder = JBUI.Borders.customLine((Color)TipUiSettings.getImageBorderColor(), (int)0, (int)0, (int)1, (int)0);
        centerPanel.setBorder(JBUI.Borders.compound((Border)outsideBorder, (Border)insideBorder));
        centerPanel.setBackground(TipUiSettings.getPanelBackground());
        JBScrollPane scrollPane = new JBScrollPane((Component)contentPanel, 20, 31);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        centerPanel.add((Component)scrollPane);
        centerPanel.add(Box.createRigidArea((Dimension)new JBDimension(0, TipUiSettings.getFeedbackPanelTopIndent())));
        JPanel feedbackPanel = this.createFeedbackPanel();
        centerPanel.add(feedbackPanel);
        this.add((Component)centerPanel, "Center");
        this.myPreviousTipAction = new PreviousTipAction();
        this.myNextTipAction = new NextTipAction();
        this.setTips(sortingResult);
    }

    private JPanel createFeedbackPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBackground(TipUiSettings.getPanelBackground());
        panel.add(Box.createHorizontalGlue());
        JLabel label = new JLabel(IdeBundle.message((String)"tip.of.the.day.feedback.question", (Object[])new Object[0]));
        panel.add(label);
        panel.add(Box.createRigidArea((Dimension)new JBDimension(8, 0)));
        this.myFeedbackToolbar = this.createFeedbackActionsToolbar();
        panel.add((Component)this.myFeedbackToolbar);
        return panel;
    }

    private ActionToolbarImpl createFeedbackActionsToolbar() {
        AnAction likeAction = this.createFeedbackAction(IdeBundle.message((String)"tip.of.the.day.feedback.like", (Object[])new Object[0]), AllIcons.Ide.LikeDimmed, AllIcons.Ide.Like, AllIcons.Ide.LikeSelected, true);
        AnAction dislikeAction = this.createFeedbackAction(IdeBundle.message((String)"tip.of.the.day.feedback.dislike", (Object[])new Object[0]), AllIcons.Ide.DislikeDimmed, AllIcons.Ide.Dislike, AllIcons.Ide.DislikeSelected, false);
        final AnAction[] actions = new AnAction[]{likeAction, dislikeAction};
        ActionToolbarImpl toolbar = new ActionToolbarImpl("TipsAndTricksDialog", (ActionGroup)new DefaultActionGroup(actions), true){

            @NotNull
            protected ActionButton createToolbarButton(@NotNull AnAction action, ActionButtonLook look, @NotNull String place, @NotNull Presentation presentation, @NotNull @NotNull Supplier<? extends @NotNull Dimension> minimumSize) {
                if (action == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (place == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (presentation == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (minimumSize == null) {
                    2.$$$reportNull$$$0(3);
                }
                ActionButton button = new ActionButton(action, presentation, place, TipPanel.getFeedbackButtonSize()){

                    protected void paintButtonLook(Graphics g) {
                        this.getButtonLook().paintIcon(g, (ActionButtonComponent)this, this.getIcon());
                    }

                    public Dimension getPreferredSize() {
                        return TipPanel.getFeedbackButtonSize();
                    }

                    public Dimension getMaximumSize() {
                        return TipPanel.getFeedbackButtonSize();
                    }
                };
                int iconIndent = TipUiSettings.getFeedbackIconIndent();
                button.setBorder(BorderFactory.createEmptyBorder(iconIndent, iconIndent, iconIndent, iconIndent));
                button.setCursor(Cursor.getPredefinedCursor(12));
                ActionButton actionButton = button;
                if (actionButton == null) {
                    2.$$$reportNull$$$0(4);
                }
                return actionButton;
            }

            @NotNull
            public Dimension getPreferredSize() {
                Dimension size = TipPanel.getFeedbackButtonSize();
                int buttonsCount = actions.length;
                return new Dimension(size.width * buttonsCount, size.height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "place";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "minimumSize";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/util/TipPanel$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/util/TipPanel$2";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createToolbarButton";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createToolbarButton";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 4 -> new IllegalStateException(string);
                };
            }
        };
        toolbar.setBackground(TipUiSettings.getPanelBackground());
        toolbar.setBorder((Border)JBUI.Borders.empty());
        toolbar.setTargetComponent((JComponent)this);
        return toolbar;
    }

    private static Dimension getFeedbackButtonSize() {
        int dim = AllIcons.Ide.Like.getIconWidth() + 2 * TipUiSettings.getFeedbackIconIndent();
        return new Dimension(dim, dim);
    }

    private AnAction createFeedbackAction(@NlsActions.ActionText String text, final Icon icon, final Icon hoveredIcon, final Icon selectedIcon, final boolean isLike) {
        return new DumbAwareAction(text, null, icon){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                TipPanel.this.myCurrentLikenessState = this.isSelected() ? null : Boolean.valueOf(isLike);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                boolean selected = this.isSelected();
                Presentation presentation = e.getPresentation();
                presentation.setIcon(selected ? selectedIcon : icon);
                presentation.setHoveredIcon(selected ? selectedIcon : hoveredIcon);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private boolean isSelected() {
                return TipPanel.this.myCurrentLikenessState != null && TipPanel.this.myCurrentLikenessState == isLike;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/util/TipPanel$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/util/TipPanel$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    void setTips(@NotNull TipsSortingResult sortingResult) {
        if (sortingResult == null) {
            TipPanel.$$$reportNull$$$0(2);
        }
        this.myTips = sortingResult.getTips();
        this.myAlgorithm = sortingResult.getAlgorithm();
        this.myAlgorithmVersion = sortingResult.getVersion();
        this.showNext(true);
    }

    private void showNext(boolean forward) {
        int index;
        if (this.myTips.isEmpty()) {
            this.setTipsNotFoundText();
            return;
        }
        int n = index = this.myCurrentTip != null ? this.myTips.indexOf(this.myCurrentTip) : -1;
        if (forward) {
            if (index < this.myTips.size() - 1) {
                this.setTip(this.myTips.get(index + 1));
            }
        } else if (index > 0) {
            this.setTip(this.myTips.get(index - 1));
        }
    }

    private void setTip(@NotNull TipAndTrickBean tip) {
        TipPanel contextComponent;
        if (tip == null) {
            TipPanel.$$$reportNull$$$0(3);
        }
        IdeFrame projectFrame = this.myProject != null ? WindowManager.getInstance().getIdeFrame(this.myProject) : null;
        IdeFrame welcomeFrame = WelcomeFrame.getInstance();
        JComponent jComponent = this.isShowing() ? this : (projectFrame != null ? projectFrame.getComponent() : (contextComponent = welcomeFrame != null ? welcomeFrame.getComponent() : null));
        if (contextComponent == null) {
            LOG.warn("Not found context component");
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<TextParagraph> tipContent = TipUtils.loadAndParseTip(tip, contextComponent);
            ApplicationManager.getApplication().invokeLater(() -> this.doSetTip(tip, tipContent), ModalityState.stateForComponent((Component)this));
        });
    }

    private void doSetTip(@NotNull TipAndTrickBean tip, @NotNull List<? extends TextParagraph> tipContent) {
        if (tip == null) {
            TipPanel.$$$reportNull$$$0(4);
        }
        if (tipContent == null) {
            TipPanel.$$$reportNull$$$0(5);
        }
        this.saveCurrentTipLikenessState();
        this.myCurrentLikenessState = this.getLikenessState(tip);
        this.myFeedbackToolbar.updateActionsAsync();
        this.myCurrentTip = tip;
        if (Registry.is((String)"tips.of.the.day.show.group.label", (boolean)false)) {
            String groupName = TipUtils.getGroupDisplayNameForTip(tip);
            this.mySubSystemLabel.setText((String)ObjectUtils.notNull((Object)groupName, (Object)""));
            this.mySubSystemLabel.setVisible(groupName != null);
        } else {
            this.mySubSystemLabel.setVisible(false);
        }
        this.myTextPane.setParagraphs(tipContent);
        this.adjustTextPaneBorder(tipContent);
        this.setPromotionForCurrentTip();
        this.setTopBorder();
        this.revalidate();
        this.repaint();
        TipsOfTheDayUsagesCollector.triggerTipShown(tip, this.myAlgorithm, this.myAlgorithmVersion);
        TipsUsageManager.getInstance().fireTipShown(this.myCurrentTip);
        this.myPreviousTipAction.setEnabled(this.myTips.indexOf(this.myCurrentTip) > 0);
        this.myNextTipAction.setEnabled(this.myTips.indexOf(this.myCurrentTip) < this.myTips.size() - 1);
        ClientProperty.put((JComponent)this, CURRENT_TIP_KEY, (Object)this.myCurrentTip.fileName);
    }

    private void adjustTextPaneBorder(List<? extends TextParagraph> tipContent) {
        if (tipContent.isEmpty()) {
            return;
        }
        TextParagraph last = tipContent.get(tipContent.size() - 1);
        List parts = last.getTextParts();
        JBEmptyBorder border = parts.size() == 1 && parts.get(0) instanceof IllustrationTextPart ? null : JBUI.Borders.emptyBottom((int)12);
        this.myTextPane.setBorder((Border)border);
    }

    private void setPromotionForCurrentTip() {
        List promotions;
        if (this.myProject == null || this.myProject.isDisposed()) {
            return;
        }
        if (this.myCurrentPromotion != null) {
            this.remove(this.myCurrentPromotion);
            this.myCurrentPromotion = null;
        }
        if (!(promotions = ContainerUtil.mapNotNull((Collection)TipAndTrickPromotionFactory.getEP_NAME().getExtensionList(), factory -> factory.createPromotionPanel(this.myProject, this.myCurrentTip))).isEmpty()) {
            if (promotions.size() > 1) {
                LOG.warn("Found more than one promotion for tip " + String.valueOf(this.myCurrentTip));
            }
            this.myCurrentPromotion = (JPanel)promotions.get(0);
            this.add((Component)this.myCurrentPromotion, "North");
        }
    }

    private void setTopBorder() {
        if (this.myCurrentPromotion == null && (SystemInfo.isWin10OrNewer || SystemInfo.isMac)) {
            this.setBorder(JBUI.Borders.customLine((Color)TipUiSettings.getImageBorderColor(), (int)1, (int)0, (int)0, (int)0));
        } else {
            this.setBorder(null);
        }
    }

    private void setTipsNotFoundText() {
        String text = IdeBundle.message((String)"error.tips.not.found", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        List<RegularTextPart> parts = List.of(new RegularTextPart(text, false));
        this.myTextPane.setParagraphs(List.of(new TextParagraph(parts)));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension baseSize = super.getPreferredSize();
        int height = Math.min(baseSize.height, TipUiSettings.getTipPanelMaxHeight());
        return new Dimension(TipPanel.getDefaultWidth(), height);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension baseSize = super.getMinimumSize();
        int height = Math.max(baseSize.height, TipUiSettings.getTipPanelMinHeight());
        return new Dimension(TipPanel.getDefaultWidth(), height);
    }

    private static int getDefaultWidth() {
        return TipUiSettings.getImageMaxWidth() + TipUiSettings.getTipPanelLeftIndent() + TipUiSettings.getTipPanelRightIndent();
    }

    Map<String, Boolean> getTipIdToLikenessStateMap() {
        this.saveCurrentTipLikenessState();
        return this.myTipIdToLikenessState;
    }

    private void saveCurrentTipLikenessState() {
        if (this.myCurrentTip != null && this.myCurrentLikenessState != this.getLikenessState(this.myCurrentTip)) {
            this.myTipIdToLikenessState.put(this.myCurrentTip.getId(), this.myCurrentLikenessState);
        }
    }

    private Boolean getLikenessState(@NotNull TipAndTrickBean tip) {
        String tipId;
        if (tip == null) {
            TipPanel.$$$reportNull$$$0(6);
        }
        if (this.myTipIdToLikenessState.containsKey(tipId = tip.getId())) {
            return this.myTipIdToLikenessState.get(tipId);
        }
        return TipsFeedback.getInstance().getLikenessState(tipId);
    }

    public boolean canBeHidden() {
        return true;
    }

    public boolean shouldSaveOptionsOnCancel() {
        return true;
    }

    public boolean isToBeShown() {
        return GeneralSettings.getInstance().isShowTipsOnStartup();
    }

    public void setToBeShown(boolean toBeShown, int exitCode) {
        GeneralSettings.getInstance().setShowTipsOnStartup(toBeShown);
    }

    @NotNull
    public String getDoNotShowMessage() {
        String string = IdeBundle.message((String)"checkbox.show.tips.on.startup", (Object[])new Object[0]);
        if (string == null) {
            TipPanel.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortingResult";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tip";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tipContent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/TipPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/TipPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDoNotShowMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTips";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTip";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doSetTip";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLikenessState";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private static class MyTextPane
    extends StyledTextPane {
        private MyTextPane() {
        }

        public void redraw() {
            super.redraw();
            View root = this.getRootView();
            int width = TipUiSettings.getImageMaxWidth() - JBUI.scale((int)14);
            root.setSize(width, root.getPreferredSpan(1));
        }

        public Dimension getPreferredSize() {
            View root = this.getRootView();
            Dimension dim = new Dimension((int)root.getPreferredSpan(0), (int)root.getPreferredSpan(1));
            JBInsets.addTo((Dimension)dim, (Insets)this.getInsets());
            return dim;
        }

        private View getRootView() {
            return ((BasicTextUI)this.ui).getRootView((JTextComponent)((Object)this));
        }
    }

    private class PreviousTipAction
    extends AbstractAction {
        PreviousTipAction() {
            super(IdeBundle.message((String)"action.previous.tip", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TipsOfTheDayUsagesCollector.PREVIOUS_TIP.log();
            TipPanel.this.showNext(false);
        }
    }

    private class NextTipAction
    extends AbstractAction {
        NextTipAction() {
            super(IdeBundle.message((String)"action.next.tip", (Object[])new Object[0]));
            this.putValue("DefaultAction", Boolean.TRUE);
            this.putValue("FocusedAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TipsOfTheDayUsagesCollector.NEXT_TIP.log();
            TipPanel.this.showNext(true);
        }
    }
}

