/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import javax.swing.Icon;
import org.jetbrains.idea.svn.ConflictState;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;

public class ConflictedSvnChange
extends Change {
    private final ConflictState myConflictState;
    private TreeConflictDescription myBeforeDescription;
    private TreeConflictDescription myAfterDescription;
    private final FilePath myTreeConflictMarkHolder;
    private boolean myIsPhantom;

    public ConflictedSvnChange(ContentRevision beforeRevision, ContentRevision afterRevision, ConflictState conflictState, FilePath treeConflictMarkHolder) {
        super(beforeRevision, afterRevision);
        this.myConflictState = conflictState;
        this.myTreeConflictMarkHolder = treeConflictMarkHolder;
    }

    public ConflictedSvnChange(ContentRevision beforeRevision, ContentRevision afterRevision, FileStatus fileStatus, ConflictState conflictState, FilePath treeConflictMarkHolder) {
        super(beforeRevision, afterRevision, fileStatus);
        this.myConflictState = conflictState;
        this.myTreeConflictMarkHolder = treeConflictMarkHolder;
    }

    public ConflictState getConflictState() {
        return this.myConflictState;
    }

    public void setIsPhantom(boolean isPhantom) {
        this.myIsPhantom = isPhantom;
    }

    public boolean isTreeConflict() {
        return this.myConflictState.isTree();
    }

    public boolean isPhantom() {
        return this.myIsPhantom;
    }

    public TreeConflictDescription getBeforeDescription() {
        return this.myBeforeDescription;
    }

    public void setBeforeDescription(TreeConflictDescription beforeDescription) {
        this.myBeforeDescription = beforeDescription;
    }

    public TreeConflictDescription getAfterDescription() {
        return this.myAfterDescription;
    }

    public void setAfterDescription(TreeConflictDescription afterDescription) {
        this.myAfterDescription = afterDescription;
    }

    public Icon getAdditionalIcon() {
        return this.myConflictState.getIcon();
    }

    public String getDescription() {
        String description = this.myConflictState.getDescription();
        if (description == null) {
            return null;
        }
        return this.myBeforeDescription != null ? (this.myAfterDescription != null ? SvnBundle.message("label.file.has.conflicts.before.and.after", description, this.myBeforeDescription.toPresentableString(), this.myAfterDescription.toPresentableString()) : SvnBundle.message("label.file.has.conflicts.before.or.after", description, this.myBeforeDescription.toPresentableString())) : (this.myAfterDescription != null ? SvnBundle.message("label.file.has.conflicts.before.or.after", description, this.myAfterDescription.toPresentableString()) : SvnBundle.message("label.file.has.conflicts", description));
    }

    public FilePath getTreeConflictMarkHolder() {
        return this.myTreeConflictMarkHolder;
    }
}

