/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBaseContentRevision;
import org.jetbrains.idea.svn.SvnBinaryContentRevision;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.status.Status;

public class SvnContentRevision
extends SvnBaseContentRevision
implements ByteBackedContentRevision {
    @NotNull
    private final Revision myRevision;
    private final boolean myUseBaseRevision;

    protected SvnContentRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, @NotNull Revision revision, boolean useBaseRevision) {
        if (vcs == null) {
            SvnContentRevision.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SvnContentRevision.$$$reportNull$$$0(1);
        }
        if (revision == null) {
            SvnContentRevision.$$$reportNull$$$0(2);
        }
        super(vcs, file);
        this.myRevision = revision;
        this.myUseBaseRevision = useBaseRevision;
    }

    @NotNull
    public static SvnContentRevision createBaseRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, @NotNull Status status) {
        if (vcs == null) {
            SvnContentRevision.$$$reportNull$$$0(3);
        }
        if (file == null) {
            SvnContentRevision.$$$reportNull$$$0(4);
        }
        if (status == null) {
            SvnContentRevision.$$$reportNull$$$0(5);
        }
        Revision revision = status.getRevision().isValid() ? status.getRevision() : status.getCommitInfo().getRevision();
        return SvnContentRevision.createBaseRevision(vcs, file, revision);
    }

    @NotNull
    public static SvnContentRevision createBaseRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, @NotNull Revision revision) {
        if (vcs == null) {
            SvnContentRevision.$$$reportNull$$$0(6);
        }
        if (file == null) {
            SvnContentRevision.$$$reportNull$$$0(7);
        }
        if (revision == null) {
            SvnContentRevision.$$$reportNull$$$0(8);
        }
        if (file.getFileType().isBinary()) {
            return new SvnBinaryContentRevision(vcs, file, revision, true);
        }
        return new SvnContentRevision(vcs, file, revision, true);
    }

    @NotNull
    public static SvnContentRevision createRemote(@NotNull SvnVcs vcs, @NotNull FilePath file, @NotNull Revision revision) {
        if (vcs == null) {
            SvnContentRevision.$$$reportNull$$$0(9);
        }
        if (file == null) {
            SvnContentRevision.$$$reportNull$$$0(10);
        }
        if (revision == null) {
            SvnContentRevision.$$$reportNull$$$0(11);
        }
        if (file.getFileType().isBinary()) {
            return new SvnBinaryContentRevision(vcs, file, revision, false);
        }
        return new SvnContentRevision(vcs, file, revision, false);
    }

    @Nullable
    public String getContent() throws VcsException {
        return ContentRevisionCache.getAsString((byte[])this.getContentAsBytes(), (FilePath)this.myFile, null);
    }

    public byte @Nullable [] getContentAsBytes() throws VcsException {
        try {
            if (this.myUseBaseRevision) {
                return (byte[])ContentRevisionCache.getOrLoadCurrentAsBytes((Project)this.myVcs.getProject(), (FilePath)this.myFile, (VcsKey)this.myVcs.getKeyInstanceMethod(), (CurrentRevisionProvider)new CurrentRevisionProvider(){

                    @NotNull
                    public VcsRevisionNumber getCurrentRevision() {
                        VcsRevisionNumber vcsRevisionNumber = SvnContentRevision.this.getRevisionNumber();
                        if (vcsRevisionNumber == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return vcsRevisionNumber;
                    }

                    @NotNull
                    public Pair<VcsRevisionNumber, byte[]> get() throws VcsException {
                        Pair pair = Pair.create((Object)SvnContentRevision.this.getRevisionNumber(), (Object)SvnContentRevision.this.getUpToDateBinaryContent());
                        if (pair == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return pair;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "org/jetbrains/idea/svn/SvnContentRevision$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getCurrentRevision";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "get";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                }).getSecond();
            }
            return ContentRevisionCache.getOrLoadAsBytes((Project)this.myVcs.getProject(), (FilePath)this.myFile, (VcsRevisionNumber)this.getRevisionNumber(), (VcsKey)this.myVcs.getKeyInstanceMethod(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, () -> this.getUpToDateBinaryContent());
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private byte[] getUpToDateBinaryContent() throws VcsException {
        File file = this.myFile.getIOFile();
        File lock = new File(file.getParentFile(), SvnUtil.PATH_TO_LOCK_FILE);
        if (lock.exists()) {
            throw new VcsException(SvnBundle.message("error.can.not.access.file.base.revision.contents.administrative.area.is.locked", new Object[0]));
        }
        return SvnUtil.getFileContents(this.myVcs, Target.on(file), this.myUseBaseRevision ? Revision.BASE : this.myRevision, Revision.UNDEFINED);
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return new SvnRevisionNumber(this.myRevision);
    }

    @NonNls
    public String toString() {
        return this.myFile.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/SvnContentRevision";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createBaseRevision";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createRemote";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

