/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.WaitForProgressToShow;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AcceptResult;
import org.jetbrains.idea.svn.auth.AuthenticationData;
import org.jetbrains.idea.svn.auth.AuthenticationProvider;
import org.jetbrains.idea.svn.auth.CertificateAuthenticationData;
import org.jetbrains.idea.svn.auth.PasswordAuthenticationData;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.dialogs.SSLCredentialsDialog;
import org.jetbrains.idea.svn.dialogs.ServerSSLDialog;
import org.jetbrains.idea.svn.dialogs.SimpleCredentialsDialog;

public class SvnInteractiveAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = Logger.getInstance(SvnInteractiveAuthenticationProvider.class);
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Project myProject;
    private static final ThreadLocal<MyCallState> myCallState = new ThreadLocal();
    private final SvnAuthenticationManager myManager;

    public SvnInteractiveAuthenticationProvider(@NotNull SvnVcs vcs, SvnAuthenticationManager manager) {
        if (vcs == null) {
            SvnInteractiveAuthenticationProvider.$$$reportNull$$$0(0);
        }
        this.myManager = manager;
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
    }

    public static void clearCallState() {
        myCallState.remove();
    }

    public static boolean wasCalled() {
        return myCallState.get() != null && myCallState.get().isWasCalled();
    }

    public static boolean wasCancelled() {
        return myCallState.get() != null && myCallState.get().isWasCancelled();
    }

    @Override
    public AuthenticationData requestClientAuthentication(String kind, Url url, String realm, boolean canCache) {
        MyCallState callState = new MyCallState(true, false);
        myCallState.set(callState);
        this.myVcs.getSvnConfiguration().clearCredentials(kind, realm);
        AuthenticationData[] result = new AuthenticationData[1];
        Runnable command = null;
        boolean authCredsOn = canCache && this.myManager.getHostOptions(url).isAuthStorageEnabled();
        String userName = this.myManager.getDefaultUsername();
        if ("svn.simple".equals(kind)) {
            command = () -> {
                SimpleCredentialsDialog dialog = new SimpleCredentialsDialog(this.myProject);
                dialog.setup(realm, userName, authCredsOn);
                dialog.setTitle(SvnBundle.message("dialog.title.authentication.required", new Object[0]));
                if (dialog.showAndGet()) {
                    result[0] = new PasswordAuthenticationData(dialog.getUserName(), dialog.getPassword(), dialog.isSaveAllowed());
                }
            };
        } else if ("svn.ssl.client-passphrase".equals(kind)) {
            command = () -> {
                SvnAuthenticationManager.HostOptions options = this.myManager.getHostOptions(url);
                String file = options.getSSLClientCertFile();
                SSLCredentialsDialog dialog = new SSLCredentialsDialog(this.myProject, realm, authCredsOn);
                if (!StringUtil.isEmptyOrSpaces((String)file)) {
                    dialog.setFile(file);
                }
                dialog.setTitle(SvnBundle.message("dialog.title.authentication.required", new Object[0]));
                if (dialog.showAndGet()) {
                    result[0] = new CertificateAuthenticationData(dialog.getCertificatePath(), dialog.getCertificatePassword(), dialog.getSaveAuth());
                }
            };
        }
        if (command != null) {
            SvnInteractiveAuthenticationProvider.showAndWait(command);
            LOG.debug("3 authentication result: " + String.valueOf(result[0]));
        }
        boolean wasCanceled = result[0] == null;
        callState.setWasCancelled(wasCanceled);
        return result[0];
    }

    @Override
    public AcceptResult acceptServerAuthentication(Url url, String realm, Object certificate, boolean canCache) {
        Ref result = Ref.create((Object)((Object)AcceptResult.REJECTED));
        if (!(certificate instanceof X509Certificate) && !(certificate instanceof String)) {
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)SvnBundle.message("notification.content.unknown.certificate.type.from.url", url.toDecodedString()), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
            return AcceptResult.REJECTED;
        }
        Runnable command = () -> {
            ServerSSLDialog dialog = certificate instanceof X509Certificate ? new ServerSSLDialog(this.myProject, (X509Certificate)certificate, canCache) : new ServerSSLDialog(this.myProject, (String)certificate, canCache);
            dialog.show();
            result.set((Object)dialog.getResult());
        };
        SvnInteractiveAuthenticationProvider.showAndWait(command);
        return (AcceptResult)((Object)result.get());
    }

    private static void showAndWait(@NotNull Runnable command) {
        if (command == null) {
            SvnInteractiveAuthenticationProvider.$$$reportNull$$$0(1);
        }
        WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)command, (ModalityState)ModalityState.any());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/auth/SvnInteractiveAuthenticationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showAndWait";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyCallState {
        private final boolean myWasCalled;
        private boolean myWasCancelled;

        public MyCallState(boolean wasCalled, boolean wasCancelled) {
            this.myWasCalled = wasCalled;
            this.myWasCancelled = wasCancelled;
        }

        public boolean isWasCalled() {
            return this.myWasCalled;
        }

        public boolean isWasCancelled() {
            return this.myWasCancelled;
        }

        public void setWasCancelled(boolean wasCancelled) {
            this.myWasCancelled = wasCancelled;
        }
    }
}

