/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.authentication;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gitlab/authentication/GitLabSecurityUtil;", "", "<init>", "()V", "API_SCOPE", "", "READ_USER_SCOPE", "DEFAULT_CLIENT_NAME", "MASTER_SCOPES", "", "getMASTER_SCOPES", "()Ljava/util/List;", "buildNewTokenUrl", "serverUri", "buildNewTokenUrl$intellij_vcs_gitlab", "intellij.vcs.gitlab"})
public final class GitLabSecurityUtil {
    @NotNull
    public static final GitLabSecurityUtil INSTANCE = new GitLabSecurityUtil();
    @NotNull
    private static final String API_SCOPE = "api";
    @NotNull
    private static final String READ_USER_SCOPE = "read_user";
    @NotNull
    private static final String DEFAULT_CLIENT_NAME = "GitLab Integration Plugin";
    @NotNull
    private static final List<String> MASTER_SCOPES;

    private GitLabSecurityUtil() {
    }

    @NotNull
    public final List<String> getMASTER_SCOPES() {
        return MASTER_SCOPES;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String buildNewTokenUrl$intellij_vcs_gitlab(@NotNull String serverUri) {
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        Url url = Urls.parseEncoded((String)(serverUri + "/-/user_settings/personal_access_tokens"));
        if (url == null) return null;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)(productName + " GitLab Integration Plugin")), TuplesKt.to((Object)"scopes", (Object)CollectionsKt.joinToString$default((Iterable)MASTER_SCOPES, (CharSequence)",", null, null, (int)0, null, null, (int)62, null))};
        Url url2 = url.addParameters(MapsKt.mapOf((Pair[])pairArray));
        if (url2 == null) return null;
        String string = url2.toExternalForm();
        return string;
    }

    static {
        Object[] objectArray = new String[]{API_SCOPE, READ_USER_SCOPE};
        MASTER_SCOPES = CollectionsKt.listOf((Object[])objectArray);
    }
}

