/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Properties;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ContentHandlerProxyLocator;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ContentHandlerProxy
implements Receiver {
    private PipelineConfiguration pipe;
    private String systemId;
    protected ContentHandler handler;
    protected LexicalHandler lexicalHandler;
    private LocationProvider locationProvider;
    private int depth = 0;
    private boolean requireWellFormed = false;
    private boolean undeclareNamespaces = false;
    private Stack elementStack = new Stack();
    private Stack namespaceStack = new Stack();
    private ContentHandlerProxyTraceListener traceListener;
    protected AttributeCollectionImpl pendingAttributes;
    private NodeName pendingElement = null;
    private int currentLocationId;
    private static final String MARKER = "##";

    public void setUnderlyingContentHandler(ContentHandler handler) {
        this.handler = handler;
        if (handler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)handler);
        }
    }

    public ContentHandler getUnderlyingContentHandler() {
        return this.handler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.locationProvider = pipe.getLocationProvider();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public Configuration getConfiguration() {
        return this.pipe.getConfiguration();
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public ContentHandlerProxyTraceListener getTraceListener() {
        if (this.traceListener == null) {
            this.traceListener = new ContentHandlerProxyTraceListener();
        }
        return this.traceListener;
    }

    public LocationProvider getLocationProvider() {
        return this.locationProvider;
    }

    public int getCurrentLocationId() {
        return this.currentLocationId;
    }

    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    public void setOutputProperties(Properties details) throws XPathException {
        String prop = details.getProperty("{http://saxon.sf.net/}require-well-formed");
        if (prop != null) {
            this.requireWellFormed = prop.equals("yes");
        }
        if ((prop = details.getProperty("undeclare-prefixes")) != null) {
            this.undeclareNamespaces = prop.equals("yes");
        }
    }

    public boolean isRequireWellFormed() {
        return this.requireWellFormed;
    }

    public void setRequireWellFormed(boolean wellFormed) {
        this.requireWellFormed = wellFormed;
    }

    public boolean isUndeclareNamespaces() {
        return this.undeclareNamespaces;
    }

    public void setUndeclareNamespaces(boolean undeclareNamespaces) {
        this.undeclareNamespaces = undeclareNamespaces;
    }

    public void open() throws XPathException {
        this.pendingAttributes = new AttributeCollectionImpl(this.getPipelineConfiguration().getConfiguration());
        if (this.handler == null) {
            throw new IllegalStateException("ContentHandlerProxy.open(): no underlying handler provided");
        }
        try {
            this.locationProvider = this.getPipelineConfiguration().getLocationProvider();
            this.pendingAttributes.setLocationProvider(this.locationProvider);
            ContentHandlerProxyLocator locator = new ContentHandlerProxyLocator(this);
            this.handler.setDocumentLocator(locator);
            this.handler.startDocument();
        }
        catch (SAXException err) {
            this.handleSAXException(err);
        }
        this.depth = 0;
    }

    public void close() throws XPathException {
        if (this.depth >= 0) {
            try {
                this.handler.endDocument();
            }
            catch (SAXException err) {
                this.handleSAXException(err);
            }
        }
        this.depth = -1;
    }

    public void startDocument(int properties) throws XPathException {
    }

    public void endDocument() throws XPathException {
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, int locationId, int properties) throws XPathException {
        ++this.depth;
        if (this.depth <= 0 && this.requireWellFormed) {
            this.notifyNotWellFormed();
        }
        this.pendingElement = nameCode;
        this.currentLocationId = locationId;
        this.namespaceStack.push(MARKER);
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        String prefix = namespaceBinding.getPrefix();
        if (prefix.equals("xml")) {
            return;
        }
        String uri = namespaceBinding.getURI();
        if (!this.undeclareNamespaces && uri.length() == 0 && prefix.length() != 0) {
            return;
        }
        try {
            this.handler.startPrefixMapping(prefix, uri);
            this.namespaceStack.push(prefix);
        }
        catch (SAXException err) {
            this.handleSAXException(err);
        }
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        int index = this.pendingAttributes.findByNodeName(nameCode);
        if (index < 0) {
            this.pendingAttributes.addAttribute(nameCode, typeCode, value.toString(), locationId, properties);
        } else {
            this.pendingAttributes.setAttribute(index, nameCode, typeCode, value.toString(), locationId, properties);
        }
    }

    public void startContent() throws XPathException {
        try {
            if (this.depth > 0 || !this.requireWellFormed) {
                String uri = this.pendingElement.getURI();
                String localName = this.pendingElement.getLocalPart();
                String qname = this.pendingElement.getDisplayName();
                this.handler.startElement(uri, localName, qname, this.pendingAttributes);
                this.elementStack.push(uri);
                this.elementStack.push(localName);
                this.elementStack.push(qname);
                this.pendingAttributes.clear();
                this.pendingElement = null;
            }
        }
        catch (SAXException err) {
            this.handleSAXException(err);
        }
    }

    public void endElement() throws XPathException {
        String prefix;
        if (this.depth > 0) {
            try {
                String qname = (String)this.elementStack.pop();
                String localName = (String)this.elementStack.pop();
                String uri = (String)this.elementStack.pop();
                this.handler.endElement(uri, localName, qname);
            }
            catch (SAXException err) {
                this.handleSAXException(err);
            }
        }
        while (!(prefix = (String)this.namespaceStack.pop()).equals(MARKER)) {
            try {
                this.handler.endPrefixMapping(prefix);
            }
            catch (SAXException err) {
                this.handleSAXException(err);
            }
        }
        --this.depth;
        if (this.requireWellFormed && this.depth <= 0) {
            this.depth = Integer.MIN_VALUE;
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        boolean disable;
        this.currentLocationId = locationId;
        boolean bl = disable = (properties & 1) != 0;
        if (disable) {
            this.setEscaping(false);
        }
        try {
            if (this.depth <= 0 && this.requireWellFormed) {
                if (!Whitespace.isWhite(chars)) {
                    this.notifyNotWellFormed();
                }
            } else {
                this.handler.characters(chars.toString().toCharArray(), 0, chars.length());
            }
        }
        catch (SAXException err) {
            this.handleSAXException(err);
        }
        if (disable) {
            this.setEscaping(true);
        }
    }

    protected void notifyNotWellFormed() throws XPathException {
        XPathException err = new XPathException("The result tree cannot be supplied to the ContentHandler because it is not well-formed XML");
        err.setErrorCode("SXCH0002");
        throw err;
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        this.currentLocationId = locationId;
        try {
            this.handler.processingInstruction(target, data.toString());
        }
        catch (SAXException err) {
            this.handleSAXException(err);
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.currentLocationId = locationId;
        try {
            if (this.lexicalHandler != null) {
                this.lexicalHandler.comment(chars.toString().toCharArray(), 0, chars.length());
            }
        }
        catch (SAXException err) {
            this.handleSAXException(err);
        }
    }

    public boolean usesTypeAnnotations() {
        return false;
    }

    private void setEscaping(boolean escaping) {
        try {
            this.handler.processingInstruction(escaping ? "javax.xml.transform.enable-output-escaping" : "javax.xml.transform.disable-output-escaping", "");
        }
        catch (SAXException err) {
            throw new AssertionError((Object)err);
        }
    }

    private void handleSAXException(SAXException err) throws XPathException {
        Exception nested = err.getException();
        if (nested instanceof XPathException) {
            throw (XPathException)nested;
        }
        if (nested instanceof SchemaException) {
            throw new XPathException(nested);
        }
        XPathException de = new XPathException(err);
        de.setErrorCode("SXCH0003");
        throw de;
    }

    public static class ContentHandlerProxyTraceListener
    implements TraceListener {
        private Stack contextItemStack;

        public void setOutputDestination(Logger stream) {
        }

        public Stack getContextItemStack() {
            return this.contextItemStack;
        }

        public void open(Controller controller) {
            this.contextItemStack = new Stack();
        }

        public void close() {
            this.contextItemStack = null;
        }

        public void enter(InstructionInfo instruction, XPathContext context) {
        }

        public void leave(InstructionInfo instruction) {
        }

        public void startCurrentItem(Item currentItem) {
            if (this.contextItemStack == null) {
                this.contextItemStack = new Stack();
            }
            this.contextItemStack.push(currentItem);
        }

        public void endCurrentItem(Item currentItem) {
            this.contextItemStack.pop();
        }
    }
}

