/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CastToUnion;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public class CastableToUnion
extends UnaryExpression {
    private UnionType targetType;
    private boolean allowEmpty;
    private NamespaceResolver nsResolver = null;

    public CastableToUnion(Expression source, UnionType targetType, boolean allowEmpty) {
        super(source);
        this.targetType = targetType;
        this.allowEmpty = allowEmpty;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public UnionType getTargetType() {
        return this.targetType;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsResolver;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.targetType.isNamespaceSensitive()) {
            StaticContext env = visitor.getStaticContext();
            this.nsResolver = env.getNamespaceResolver();
        }
        this.operand = visitor.simplify(this.operand);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextInfo);
        if (this.operand instanceof Literal) {
            GroundedValue literalOperand = ((Literal)this.operand).getValue();
            if (literalOperand instanceof AtomicValue) {
                BooleanValue av = this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext());
                return Literal.makeLiteral(av, this.getContainer());
            }
            if (literalOperand.getLength() == 0) {
                return Literal.makeLiteral(BooleanValue.get(this.allowEmpty), this.getContainer());
            }
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression e2 = super.optimize(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        if (!Cardinality.allowsZero(this.operand.getCardinality())) {
            this.allowEmpty = false;
            this.resetLocalStaticProperties();
        }
        return this;
    }

    public int computeCardinality() {
        return this.allowEmpty && Cardinality.allowsZero(this.operand.getCardinality()) ? 24576 : 16384;
    }

    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        CastableToUnion c = new CastableToUnion(this.getBaseExpression().copy(), this.targetType, this.allowEmpty);
        c.nsResolver = this.nsResolver;
        return c;
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        Item item;
        int count = 0;
        SequenceIterator iter = this.operand.iterate(context);
        while ((item = iter.next()) != null) {
            if (item instanceof NodeInfo) {
                AtomicValue av;
                AtomicSequence atomizedValue = ((NodeInfo)item).atomize();
                int length = SequenceTool.getLength(atomizedValue);
                if ((count += length) > 1) {
                    return false;
                }
                if (length == 0 || CastToUnion.castable(av = (AtomicValue)atomizedValue.head(), this.targetType, this.nsResolver, context)) continue;
                return false;
            }
            if (item instanceof AtomicValue) {
                AtomicValue av = (AtomicValue)item;
                if (++count > 1) {
                    return false;
                }
                if (CastToUnion.castable(av, this.targetType, this.nsResolver, context)) continue;
                return false;
            }
            throw new XPathException("Input to 'castable' operator cannot be atomized", "XPTY0004");
        }
        return count != 0 || this.allowEmpty;
    }

    public boolean equals(Object other) {
        return super.equals(other) && other instanceof CastableToUnion && this.targetType == ((CastableToUnion)other).targetType && this.allowEmpty == ((CastableToUnion)other).allowEmpty && this.nsResolver == ((CastableToUnion)other).nsResolver;
    }

    public int hashCode() {
        return super.hashCode() ^ this.targetType.hashCode();
    }

    public String toString() {
        return this.operand.toString() + " castable as " + this.targetType.getEQName();
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("castableToUnion");
        out.emitAttribute("as", this.targetType.getEQName());
        this.operand.explain(out);
        out.endElement();
    }
}

