/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParentNodeConstructor
extends Instruction
implements ValidatingInstruction {
    protected Expression content;
    private boolean lazyConstruction = false;
    private ParseOptions validationOptions = null;
    private String baseURI;
    protected boolean preservingTypes = true;

    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setLazyConstruction(boolean lazy) {
        this.lazyConstruction = lazy;
    }

    public final boolean isLazyConstruction() {
        return this.lazyConstruction;
    }

    @Override
    public SchemaType getSchemaType() {
        return this.validationOptions == null ? null : this.validationOptions.getTopLevelType();
    }

    public ParseOptions getValidationOptions() {
        return this.validationOptions;
    }

    public void setValidationAction(int mode, SchemaType schemaType) {
        boolean bl = this.preservingTypes = mode == 3 && schemaType == null;
        if (!this.preservingTypes) {
            if (this.validationOptions == null) {
                this.validationOptions = new ParseOptions();
            }
            if (schemaType == Untyped.getInstance()) {
                this.validationOptions.setSchemaValidationMode(4);
            } else {
                this.validationOptions.setSchemaValidationMode(mode);
                this.validationOptions.setTopLevelType(schemaType);
            }
        }
    }

    @Override
    public int getValidationAction() {
        return this.validationOptions == null ? 3 : this.validationOptions.getSchemaValidationMode();
    }

    public void setNoNeedToStrip() {
        this.preservingTypes = true;
    }

    public void setContentExpression(Expression content) {
        this.content = content;
        this.adoptChildExpression(content);
    }

    public Expression getContentExpression() {
        return this.content;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.content = visitor.typeCheck(this.content, contextInfo);
        this.adoptChildExpression(this.content);
        this.verifyLazyConstruction();
        this.checkContentSequence(visitor.getStaticContext());
        return this;
    }

    protected abstract void checkContentSequence(StaticContext var1) throws XPathException;

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if (!Literal.isEmptySequence(this.content)) {
            this.content = visitor.optimize(this.content, contextItemType);
            if (this.content instanceof Block) {
                this.content = ((Block)this.content).mergeAdjacentTextInstructions();
            }
            this.adoptChildExpression(this.content);
            if (visitor.isOptimizeForStreaming()) {
                visitor.getConfiguration().obtainOptimizer().makeCopyOperationsExplicit(this, this.content);
            }
        }
        if (this.getContainer().getPackageData().isSchemaAware()) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (this.getValidationAction() == 4 && ((this.content.getSpecialProperties() & 0x4000000) != 0 || th.relationship(this.content.getItemType(), NodeKindTest.ELEMENT) == 4 && th.relationship(this.content.getItemType(), NodeKindTest.ATTRIBUTE) == 4)) {
                this.setNoNeedToStrip();
            }
        } else {
            this.setNoNeedToStrip();
        }
        return this;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.content = this.doPromotion(this.content, offer);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(new Operand(this.content, OperandRole.SINGLE_ATOMIC));
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (this.content == original) {
            this.content = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    public int getCardinality() {
        return 16384;
    }

    void verifyLazyConstruction() {
        if (!this.isLazyConstruction()) {
            return;
        }
        if ((this.getDependencies() & 0xC) != 0) {
            this.setLazyConstruction(false);
        }
        if (this.getValidationAction() == 1 || this.getValidationAction() == 2 || this.getSchemaType() != null) {
            this.setLazyConstruction(false);
        }
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet result = super.addToPathMap(pathMap, pathMapNodeSet);
        result.setReturnable(false);
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        ItemType type = this.getItemType();
        if (th.relationship(type, NodeKindTest.ELEMENT) != 4 || th.relationship(type, NodeKindTest.DOCUMENT) != 4) {
            result.addDescendants();
        }
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    public boolean isPreservingTypes() {
        return this.preservingTypes;
    }
}

